/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.zone.client;

import com.google.common.collect.Lists;
import com.samskivert.util.ResultListener;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationDecoder;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.util.PresentsContext;
import com.threerings.whirled.client.SceneDirector;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.util.WhirledContext;
import com.threerings.whirled.zone.Log;
import com.threerings.whirled.zone.client.ZoneDecoder;
import com.threerings.whirled.zone.client.ZoneObserver;
import com.threerings.whirled.zone.client.ZoneReceiver;
import com.threerings.whirled.zone.client.ZoneService;
import com.threerings.whirled.zone.data.ZoneSummary;
import com.threerings.whirled.zone.util.ZoneUtil;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneDirector
extends BasicDirector
implements ZoneReceiver,
ZoneService.ZoneMoveListener,
SceneDirector.MoveHandler {
    protected WhirledContext _ctx;
    protected SceneDirector _scdir;
    protected ZoneService _zservice;
    protected ZoneSummary _summary;
    protected ArrayList<ZoneObserver> _observers = Lists.newArrayList();
    protected int _previousZoneId = -1;
    protected int _pendingZoneId = -1;

    public ZoneDirector(WhirledContext ctx, SceneDirector scdir) {
        super((PresentsContext)ctx);
        this._ctx = ctx;
        this._scdir = scdir;
        this._scdir.setMoveHandler(this);
        this._ctx.getClient().getInvocationDirector().registerReceiver((InvocationDecoder)new ZoneDecoder(this));
    }

    public ZoneSummary getZoneSummary() {
        return this._summary;
    }

    public void addZoneObserver(ZoneObserver observer) {
        this._observers.add(observer);
    }

    public void removeZoneObserver(ZoneObserver observer) {
        this._observers.remove(observer);
    }

    public boolean moveTo(int zoneId, int sceneId) {
        return this.moveTo(zoneId, sceneId, null);
    }

    public boolean moveTo(int zoneId, int sceneId, ResultListener<PlaceConfig> rl) {
        if (zoneId < 0 || sceneId < 0) {
            Log.log.warning((Object)"Refusing moveTo(): invalid sceneId or zoneId", new Object[]{"zoneId", zoneId, "sceneId", sceneId});
            return false;
        }
        if (this._summary != null && zoneId == this._summary.zoneId) {
            return this._scdir.moveTo(sceneId);
        }
        if (!this._scdir.prepareMoveTo(sceneId, rl)) {
            return false;
        }
        this._pendingZoneId = zoneId;
        this.sendMoveRequest();
        return true;
    }

    protected void sendMoveRequest() {
        this.notifyObservers(this._pendingZoneId);
        int sceneVers = 0;
        int sceneId = this._scdir.getPendingSceneId();
        SceneModel pendingModel = this._scdir.getPendingModel();
        if (pendingModel != null) {
            sceneVers = pendingModel.version;
        }
        Log.log.info((Object)("Issuing zoned moveTo(" + ZoneUtil.toString(this._pendingZoneId) + ", " + sceneId + ", " + sceneVers + ")."), new Object[0]);
        this._zservice.moveTo(this._pendingZoneId, sceneId, sceneVers, this);
    }

    protected void fetchServices(Client client) {
        this._zservice = (ZoneService)client.requireService(ZoneService.class);
    }

    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        this._zservice = null;
        this._summary = null;
        this._previousZoneId = -1;
    }

    @Override
    public void moveRequiresServerSwitch(String hostname, int[] ports) {
        this._ctx.getClient().moveToServer(hostname, ports, new InvocationService.ConfirmListener(){

            public void requestProcessed() {
                ZoneDirector.this.sendMoveRequest();
            }

            public void requestFailed(String reason) {
                ZoneDirector.this.requestFailed(reason);
            }
        });
    }

    @Override
    public void moveSucceeded(int placeId, PlaceConfig config, ZoneSummary summary) {
        if (this._summary != null) {
            this._previousZoneId = this._summary.zoneId;
        }
        this._summary = summary;
        this._pendingZoneId = -1;
        this._scdir.moveSucceeded(placeId, config);
        this.notifyObservers((Object)summary);
    }

    @Override
    public void moveSucceededWithUpdates(int placeId, PlaceConfig config, ZoneSummary summary, SceneUpdate[] updates) {
        this._summary = summary;
        this._pendingZoneId = -1;
        this._scdir.moveSucceededWithUpdates(placeId, config, updates);
        this.notifyObservers((Object)summary);
    }

    @Override
    public void moveSucceededWithScene(int placeId, PlaceConfig config, ZoneSummary summary, SceneModel model) {
        this._summary = summary;
        this._pendingZoneId = -1;
        this._scdir.moveSucceededWithScene(placeId, config, model);
        this.notifyObservers((Object)summary);
    }

    public void requestFailed(String reason) {
        this._scdir.requestFailed(reason);
        this.notifyObservers(reason);
    }

    @Override
    public void forcedMove(final int zoneId, final int sceneId) {
        if (this._scdir.movePending()) {
            if (this._scdir.getPendingSceneId() == sceneId) {
                Log.log.info((Object)"Dropping forced move because we have a move pending", new Object[]{"pend", this._scdir.getPendingModel(), "rzId", zoneId, "rsId", sceneId});
            } else {
                Log.log.info((Object)"Delaying forced move because we have a move pending", new Object[]{"pend", this._scdir.getPendingModel(), "rzId", zoneId, "rsId", sceneId});
                this._scdir.addPendingForcedMove(new Runnable(){

                    public void run() {
                        ZoneDirector.this.forcedMove(zoneId, sceneId);
                    }
                });
            }
            return;
        }
        Log.log.info((Object)"Moving at request of server", new Object[]{"zoneId", zoneId, "sceneId", sceneId});
        this._scdir.didLeaveScene();
        this.moveTo(zoneId, sceneId, null);
    }

    @Override
    public void recoverMoveTo(int previousSceneId) {
        if (this._summary != null) {
            return;
        }
        this._pendingZoneId = -1;
        if (this._previousZoneId != -1) {
            this.moveTo(this._previousZoneId, previousSceneId);
        } else {
            this._scdir.moveTo(previousSceneId);
        }
    }

    protected void notifyObservers(Object data) {
        for (ZoneObserver obs : this._observers) {
            try {
                if (data instanceof Integer) {
                    obs.zoneWillChange((Integer)data);
                    continue;
                }
                if (data instanceof ZoneSummary) {
                    obs.zoneDidChange((ZoneSummary)((Object)data));
                    continue;
                }
                obs.zoneChangeFailed((String)data);
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Zone observer choked during notification", new Object[]{"data", data, "obs", obs, t});
            }
        }
    }
}

