/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.spot.data;

import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotSceneModel;

public class ModifyPortalsUpdate
extends SceneUpdate {
    public Portal[] portalsRemoved;
    public Portal[] portalsAdded;

    public void initialize(int targetId, int targetVersion, Portal[] removed, Portal[] added) {
        this.init(targetId, targetVersion);
        this.portalsRemoved = removed;
        this.portalsAdded = added;
    }

    public void apply(SceneModel model) {
        super.apply(model);
        SpotSceneModel spotModel = SpotSceneModel.getSceneModel(model);
        if (this.portalsRemoved != null) {
            for (Portal portal : this.portalsRemoved) {
                spotModel.removePortal(portal);
            }
        }
        if (this.portalsAdded != null) {
            for (Portal portal : this.portalsAdded) {
                spotModel.addPortal(portal);
            }
        }
    }
}

