/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.client;

import com.samskivert.util.ObserverList;
import com.threerings.media.image.Mirage;
import com.threerings.media.sprite.Sprite;
import com.threerings.puzzle.drop.client.DropBoardView;
import com.threerings.puzzle.drop.client.DropSpriteObserver;
import com.threerings.util.DirectionUtil;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;

public class DropSprite
extends Sprite {
    protected static final float DEFAULT_VELOCITY = 0.03f;
    protected long _rowstamp;
    protected long _endstamp;
    protected long _stopstamp;
    protected DropBoardView _view;
    protected int _unit;
    protected Point _srcPos = new Point();
    protected Point _destPos = new Point();
    protected Point _renderPos = new Point();
    protected int _dist;
    protected float _vel = 0.03f;
    protected int _offx;
    protected int _offy;
    protected int _row;
    protected int _col;
    protected int[] _pieces;
    protected boolean _bouncing;
    protected static final int[] ORIENT_DX = new int[]{-1, 0, 1, 0};
    protected static final int[] ORIENT_DY = new int[]{0, -1, 0, 1};

    public DropSprite(DropBoardView view, int col, int row, int[] pieces, int dist) {
        this(view, col, row, pieces, dist, -1);
    }

    public DropSprite(DropBoardView view, int col, int row, int[] pieces, int dist, int renderOrder) {
        this._view = view;
        this._col = col;
        this._row = row;
        this._pieces = pieces;
        this._dist = dist == 0 ? 1 : dist;
        this._orient = 3;
        this._unit = this._view.getPieceHeight();
        this.setRenderOrder(renderOrder);
    }

    protected void init() {
        super.init();
        this.updateBounds();
        this.setBoardLocation(this._row, this._col);
        this.setRowOffset(-(this._pieces.length - 1));
    }

    public int getDistance() {
        return this._dist;
    }

    public int getColumn() {
        return this._col;
    }

    public int getRow() {
        return this._row;
    }

    public int[] getPieces() {
        return this._pieces;
    }

    public float getVelocity() {
        return this._vel;
    }

    public void setBoardLocation(int row, int col) {
        this._row = row;
        this._col = col;
        this.updatePosition();
    }

    public void setColumn(int col) {
        this._col = col;
        this.updatePosition();
    }

    public void setRow(int row) {
        this._row = row;
        this.updatePosition();
    }

    public void setColumnOffset(int count) {
        this._offx = count;
        this.updateRenderOffset();
        this.updateRenderOrigin();
    }

    public void setRowOffset(int count) {
        this._offy = count;
        this.updateRenderOffset();
        this.updateRenderOrigin();
    }

    public void setPieces(int[] pieces) {
        this._pieces = pieces;
    }

    public void setVelocity(float velocity) {
        if (this._vel == velocity) {
            return;
        }
        if (this._rowstamp > 0L) {
            long now = this._view.getTimeStamp();
            float pctdone = this.getPercentDone(now);
            float travpix = pctdone * (float)this._unit;
            long msecs = (long)(travpix / velocity);
            this._rowstamp = now - msecs;
        }
        this._vel = velocity;
    }

    public void drop() {
        if (this._dist <= 0) {
            this._dist = 1;
        }
        if (this._stopstamp > 0L) {
            long delta = this._view.getTimeStamp() - this._stopstamp;
            this._rowstamp += delta;
            this._stopstamp = 0L;
        } else {
            this._rowstamp = this._endstamp;
        }
    }

    public boolean isDropping() {
        return this._stopstamp == 0L && this._rowstamp != 0L;
    }

    public void stop() {
        if (this._stopstamp == 0L) {
            this._stopstamp = this._view.getTimeStamp();
        }
    }

    public void setBouncing(boolean bouncing) {
        this._bouncing = bouncing;
        if (this._bouncing) {
            this.shiftForBounce();
            this._endstamp = this._rowstamp = this._view.getTimeStamp();
        }
    }

    public boolean isBouncing() {
        return this._bouncing;
    }

    protected void shiftForBounce() {
        this.setLocation(this._ox, this._srcPos.y + 1);
    }

    public boolean inside(Shape shape) {
        return shape.contains(this._bounds);
    }

    public float getPercentDone(long timestamp) {
        if (this._rowstamp == 0L) {
            return 0.0f;
        }
        long msecs = Math.max(0L, timestamp - this._rowstamp);
        float travpix = (float)msecs * this._vel;
        float pctdone = travpix / (float)this._unit;
        return pctdone;
    }

    public void paint(Graphics2D gfx) {
        int oidx = this._orient / 2;
        int incx = ORIENT_DX[oidx];
        int incy = ORIENT_DY[oidx];
        int dx = this._ox - this._srcPos.x;
        int dy = this._oy - this._srcPos.y;
        int pcol = this._col;
        int prow = this._row;
        for (int ii = 0; ii < this._pieces.length; ++ii) {
            this._view.getPiecePosition(pcol, prow, this._renderPos);
            this.paintPieceImage(gfx, ii, pcol, prow, this._orient, this._renderPos.x + dx, this._renderPos.y + dy);
            pcol += incx;
            prow += incy;
        }
    }

    protected void paintPieceImage(Graphics2D gfx, int pieceidx, int col, int row, int orient, int x, int y) {
        Mirage image = this._view.getPieceImage(this._pieces[pieceidx], col, row, orient);
        image.paint(gfx, x, y);
    }

    public void tick(long timestamp) {
        super.tick(timestamp);
        if (this._rowstamp == 0L) {
            this._rowstamp = timestamp;
        }
        if (this._bouncing || this._stopstamp > 0L) {
            return;
        }
        PieceMovedOp pmop = null;
        float pctdone = this.getPercentDone(timestamp);
        if (pctdone >= 1.0f) {
            this.advancePosition();
            --this._dist;
            long used = (long)((float)this._unit / this._vel);
            this._rowstamp = this._endstamp = this._rowstamp + used;
            pctdone = (float)((double)pctdone - 1.0);
            pmop = new PieceMovedOp(this, timestamp, this._col, this._row);
        }
        pctdone = Math.min(pctdone, 1.0f);
        int nx = this._srcPos.x + (int)((float)(this._destPos.x - this._srcPos.x) * pctdone);
        int ny = this._srcPos.y + (int)((float)(this._destPos.y - this._srcPos.y) * pctdone);
        if (this._ox != nx || this._oy != ny) {
            this.setLocation(nx, ny);
        }
        if (pmop != null) {
            this._observers.apply((ObserverList.ObserverOp)pmop);
        }
    }

    protected void advancePosition() {
        this.setRow(this._row + 1);
    }

    public void fastForward(long timeDelta) {
        if (this._rowstamp > 0L) {
            this._rowstamp += timeDelta;
        }
    }

    public void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", orient=").append(DirectionUtil.toShortString((int)this._orient));
        buf.append(", row=").append(this._row);
        buf.append(", col=").append(this._col);
        buf.append(", offx=").append(this._offx);
        buf.append(", offy=").append(this._offy);
        buf.append(", dist=").append(this._dist);
    }

    protected void updatePosition() {
        this._view.getPiecePosition(this._col, this._row, this._srcPos);
        this._view.getPiecePosition(this._col, this._row + 1, this._destPos);
        this.setLocation(this._srcPos.x, this._srcPos.y);
    }

    public void setOrientation(int orient) {
        this.invalidate();
        super.setOrientation(orient);
        this.updateBounds();
        this.invalidate();
    }

    protected void updateBounds() {
        Dimension size = this._view.getPieceSegmentSize(this._col, this._row, this._orient, this._pieces.length);
        this._bounds.width = size.width;
        this._bounds.height = size.height;
    }

    protected void updateRenderOffset() {
        this._oxoff = -(this._view.getPieceWidth() * this._offx);
        this._oyoff = -(this._view.getPieceHeight() * this._offy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PieceMovedOp
    implements ObserverList.ObserverOp<Object> {
        protected DropSprite _sprite;
        protected long _when;
        protected int _col;
        protected int _row;

        public PieceMovedOp(DropSprite sprite, long when, int col, int row) {
            this._sprite = sprite;
            this._when = when;
            this._col = col;
            this._row = row;
        }

        public boolean apply(Object observer) {
            if (observer instanceof DropSpriteObserver) {
                ((DropSpriteObserver)observer).pieceMoved(this._sprite, this._when, this._col, this._row);
            }
            return true;
        }
    }
}

