/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.turn.client;

import com.google.common.collect.Maps;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.parlor.turn.data.TurnGameObject;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.ElementUpdateListener;
import com.threerings.presents.dobj.ElementUpdatedEvent;
import com.threerings.util.Name;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TurnDisplay
extends JPanel
implements PlaceView,
AttributeChangeListener,
ElementUpdateListener {
    protected TurnGameObject _turnObj;
    protected HashMap<Name, JLabel> _labels = Maps.newHashMap();
    protected Icon[] _playerIcons;
    protected String _winnerText = "";
    protected String _drawText = "";
    protected Icon _turnIcon;

    public TurnDisplay() {
    }

    public TurnDisplay(Icon turnIcon) {
        this.setTurnIcon(turnIcon);
    }

    public void setTurnIcon(Icon turnIcon) {
        this._turnIcon = turnIcon;
        if (this._turnObj != null) {
            this.createList();
        }
    }

    public void setWinnerText(String winnerText) {
        this._winnerText = winnerText;
    }

    public void setDrawText(String drawText) {
        this._drawText = drawText;
    }

    public void setPlayerIcons(Icon[] icons) {
        this._playerIcons = icons;
        if (this._turnObj != null) {
            this.createList();
        }
    }

    protected void createList() {
        this.removeAll();
        this._labels.clear();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints iconC = new GridBagConstraints();
        GridBagConstraints labelC = new GridBagConstraints();
        labelC.fill = 1;
        iconC.fill = 1;
        labelC.weightx = 1.0;
        labelC.insets.left = 10;
        labelC.gridwidth = 0;
        Name[] names = this._turnObj.getPlayers();
        GameObject gameobj = (GameObject)((Object)this._turnObj);
        boolean[] winners = gameobj.winners;
        Name holder = this._turnObj.getTurnHolder();
        int ii = 0;
        int jj = 0;
        while (ii < names.length) {
            if (names[ii] != null) {
                JLabel iconLabel = new JLabel();
                if (winners == null) {
                    if (names[ii].equals((Object)holder)) {
                        iconLabel.setIcon(this._turnIcon);
                    }
                } else if (gameobj.isDraw()) {
                    iconLabel.setText(this._drawText);
                } else if (winners[ii]) {
                    iconLabel.setText(this._winnerText);
                }
                iconLabel.setForeground(Color.BLACK);
                this._labels.put(names[ii], iconLabel);
                this.add((Component)iconLabel, iconC);
                JLabel label = new JLabel(names[ii].toString());
                if (this._playerIcons != null) {
                    label.setIcon(this._playerIcons[jj]);
                }
                this.add((Component)label, labelC);
            }
            ++ii;
            ++jj;
        }
        SwingUtil.refresh((JComponent)this);
    }

    public void willEnterPlace(PlaceObject plobj) {
        this._turnObj = (TurnGameObject)plobj;
        plobj.addListener((ChangeListener)this);
        this.createList();
    }

    public void didLeavePlace(PlaceObject plobj) {
        plobj.removeListener((ChangeListener)this);
        this._turnObj = null;
        this.removeAll();
    }

    public void attributeChanged(AttributeChangedEvent event) {
        String name = event.getName();
        if (name.equals(this._turnObj.getTurnHolderFieldName())) {
            JLabel newLabel;
            JLabel oldLabel = this._labels.get(event.getOldValue());
            if (oldLabel != null) {
                oldLabel.setIcon(null);
            }
            if ((newLabel = this._labels.get(event.getValue())) != null) {
                newLabel.setIcon(this._turnIcon);
            }
        } else if (name.equals("players")) {
            this.createList();
        } else if (name.equals("winners")) {
            this.createList();
        }
    }

    public void elementUpdated(ElementUpdatedEvent event) {
        String name = event.getName();
        if (name.equals("players")) {
            this.createList();
        }
    }
}

