/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.rating.server.persist;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Query;
import com.samskivert.depot.clause.OrderBy;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMaps;
import com.threerings.parlor.rating.server.persist.PercentileRecord;
import com.threerings.parlor.rating.server.persist.RatingRecord;
import com.threerings.parlor.rating.util.Percentiler;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RatingRepository
extends DepotRepository {
    @Inject
    public RatingRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public RatingRecord getRating(int gameId, int playerId) {
        return (RatingRecord)this.load(RatingRecord.getKey(gameId, playerId), new QueryClause[0]);
    }

    public List<RatingRecord> getRatings(int gameId, Integer ... players) {
        if (players.length == 0) {
            return Collections.emptyList();
        }
        return this.from(RatingRecord.class).where(new SQLExpression[]{RatingRecord.GAME_ID.eq((Comparable)Integer.valueOf(gameId)), RatingRecord.PLAYER_ID.in((Comparable[])players)}).select();
    }

    public List<RatingRecord> getRatings(int playerId, long since, int count) {
        Query query = this.from(RatingRecord.class);
        if (since > 0L) {
            Timestamp when = new Timestamp(System.currentTimeMillis() - since);
            query = query.where(new SQLExpression[]{RatingRecord.PLAYER_ID.eq((Comparable)Integer.valueOf(playerId)), RatingRecord.LAST_UPDATED.greaterThan((Comparable)when)});
        } else {
            query = query.where(RatingRecord.PLAYER_ID, (Comparable)Integer.valueOf(playerId));
        }
        if (count > 0) {
            query = query.limit(count);
        }
        return query.descending(RatingRecord.LAST_UPDATED).select();
    }

    public List<RatingRecord> getTopRatings(int gameId, int limit, long since, Set<Integer> playerIds) {
        ArrayList where = Lists.newArrayList();
        where.add(RatingRecord.GAME_ID.eq((Comparable)Integer.valueOf(gameId)));
        if (since > 0L) {
            where.add(RatingRecord.LAST_UPDATED.greaterThan((Comparable)new Timestamp(System.currentTimeMillis() - since)));
        }
        if (playerIds != null) {
            where.add(RatingRecord.PLAYER_ID.in(playerIds));
        }
        OrderBy ob = new OrderBy(new SQLExpression[]{RatingRecord.RATING, RatingRecord.LAST_UPDATED}, new OrderBy.Order[]{OrderBy.Order.DESC, OrderBy.Order.DESC});
        return this.from(RatingRecord.class).where((Iterable)where).limit(limit).orderBy(ob).select();
    }

    public void setRating(int gameId, int playerId, int rating, int experience) {
        this.store(new RatingRecord(gameId, playerId, rating, experience));
    }

    public void deleteRating(int gameId, int playerId) {
        this.delete(RatingRecord.getKey(gameId, playerId));
    }

    public Percentiler loadPercentile(int gameId, int gameMode) {
        PercentileRecord record = (PercentileRecord)this.load(PercentileRecord.getKey(gameId, gameMode), new QueryClause[0]);
        return record == null ? new Percentiler() : new Percentiler(record.data);
    }

    public Map<Integer, Percentiler> loadPercentiles(int gameId) {
        HashMap tilers = Maps.newHashMap();
        for (PercentileRecord record : this.from(PercentileRecord.class).where(PercentileRecord.GAME_ID, (Comparable)Integer.valueOf(gameId)).select()) {
            tilers.put(record.gameMode, new Percentiler(record.data));
        }
        return tilers;
    }

    public void updatePercentile(int gameId, int gameMode, Percentiler tiler) {
        PercentileRecord record = new PercentileRecord();
        record.gameId = gameId;
        record.gameMode = gameMode;
        record.data = tiler.toBytes();
        this.store(record);
    }

    public void deletePercentile(int gameId, int gameMode) {
        this.delete(PercentileRecord.getKey(gameId, gameMode));
    }

    public void purgeGame(int gameId) {
        this.from(RatingRecord.class).where(RatingRecord.GAME_ID, (Comparable)Integer.valueOf(gameId)).delete(null);
        this.from(PercentileRecord.class).where(PercentileRecord.GAME_ID, (Comparable)Integer.valueOf(gameId)).delete(null);
    }

    public void purgePlayers(Collection<Integer> playerIds) {
        this.from(RatingRecord.class).where(new SQLExpression[]{RatingRecord.PLAYER_ID.in(playerIds)}).delete(null);
    }

    public Collection<RatingRecord> getMostRecentRatings(Collection<Integer> playerIds, int gameIdSign) {
        return this.getMostRecentRatings(playerIds, null, gameIdSign);
    }

    public Collection<RatingRecord> getMostRecentRatings(Collection<Integer> playerIds, Collection<Integer> gameIds, int gameIdSign) {
        ArrayList conditions = Lists.newArrayList();
        conditions.add(RatingRecord.PLAYER_ID.in(playerIds));
        if (gameIds != null) {
            conditions.add(RatingRecord.GAME_ID.in(gameIds));
        }
        if (gameIdSign != 0) {
            conditions.add(gameIdSign < 0 ? RatingRecord.GAME_ID.lessThan((Comparable)Integer.valueOf(0)) : RatingRecord.GAME_ID.greaterThan((Comparable)Integer.valueOf(0)));
        }
        HashIntMap ratings = IntMaps.newHashIntMap();
        for (RatingRecord record : this.from(RatingRecord.class).where((Iterable)conditions).descending(RatingRecord.LAST_UPDATED).select()) {
            if (ratings.containsKey(record.playerId)) continue;
            ratings.put(record.playerId, (Object)record);
        }
        return ratings.values();
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(RatingRecord.class);
        classes.add(PercentileRecord.class);
    }
}

