/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.client;

import com.threerings.parlor.Log;
import com.threerings.parlor.client.InvitationResponseObserver;
import com.threerings.parlor.client.ParlorService;
import com.threerings.parlor.data.ParlorCodes;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.util.ParlorContext;
import com.threerings.util.Name;

public class Invitation
implements ParlorCodes,
ParlorService.InviteListener {
    public int inviteId = -1;
    public Name opponent;
    public GameConfig config;
    protected ParlorContext _ctx;
    protected ParlorService _pservice;
    protected InvitationResponseObserver _observer;
    protected boolean _cancelled = false;

    public Invitation(ParlorContext ctx, ParlorService pservice, Name opponent, GameConfig config, InvitationResponseObserver observer) {
        this._ctx = ctx;
        this._pservice = pservice;
        this._observer = observer;
        this.opponent = opponent;
        this.config = config;
    }

    public void accept() {
        this._pservice.respond(this.inviteId, 0, null, this);
    }

    public void refuse(String message) {
        this._pservice.respond(this.inviteId, 1, message, this);
    }

    public void cancel() {
        if (this.inviteId == -1) {
            this._cancelled = true;
        } else {
            this._pservice.cancel(this.inviteId, this);
            this._ctx.getParlorDirector().clearInvitation(this);
        }
    }

    public void counter(GameConfig config, InvitationResponseObserver observer) {
        this._observer = observer;
        this._pservice.respond(this.inviteId, 2, config, this);
    }

    public void inviteReceived(int inviteId) {
        this.inviteId = inviteId;
        if (this._cancelled) {
            this._pservice.cancel(inviteId, this);
        } else {
            this._ctx.getParlorDirector().registerInvitation(this);
        }
    }

    public void requestFailed(String reason) {
        this._observer.invitationRefused(this, reason);
    }

    protected void receivedResponse(int code, Object arg) {
        if (this._observer == null) {
            Log.log.warning((Object)("No observer registered for invitation " + this + "."), new Object[0]);
            return;
        }
        try {
            switch (code) {
                case 0: {
                    this._observer.invitationAccepted(this);
                    break;
                }
                case 1: {
                    this._observer.invitationRefused(this, (String)arg);
                    break;
                }
                case 2: {
                    this._observer.invitationCountered(this, (GameConfig)arg);
                }
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)("Invitation response observer choked on response [code=" + code + ", arg=" + arg + ", invite=" + this + "]."), new Object[]{e});
        }
        if (code != 2) {
            this._ctx.getParlorDirector().clearInvitation(this);
        }
    }

    public String toString() {
        return "[inviteId=" + this.inviteId + ", opponent=" + this.opponent + ", config=" + this.config + ", observer=" + this._observer + ", cancelled=" + this._cancelled + "]";
    }
}

