/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.client;

import com.samskivert.swing.Controller;
import com.threerings.crowd.data.BodyObject;
import com.threerings.micasa.Log;
import com.threerings.micasa.client.LogonPanel;
import com.threerings.micasa.client.MiCasaFrame;
import com.threerings.micasa.data.MiCasaBootstrapData;
import com.threerings.micasa.util.MiCasaContext;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.SessionObserver;
import java.awt.event.ActionEvent;

public class ClientController
extends Controller
implements SessionObserver {
    protected MiCasaContext _ctx;
    protected MiCasaFrame _frame;
    protected BodyObject _body;
    protected LogonPanel _logonPanel;

    public ClientController(MiCasaContext ctx, MiCasaFrame frame) {
        this._ctx = ctx;
        this._frame = frame;
        this._ctx.getClient().addClientObserver((SessionObserver)this);
        this._logonPanel = new LogonPanel(this._ctx);
        this._frame.setPanel(this._logonPanel);
    }

    public boolean handleAction(ActionEvent action) {
        String cmd = action.getActionCommand();
        if (cmd.equals("logoff")) {
            this._ctx.getClient().logoff(true);
            return true;
        }
        Log.log.info((Object)("Unhandled action: " + action), new Object[0]);
        return false;
    }

    public void clientWillLogon(Client client) {
    }

    public void clientDidLogon(Client client) {
        Log.log.info((Object)("Client did logon [client=" + client + "]."), new Object[0]);
        this._body = (BodyObject)client.getClientObject();
        int moveOid = -1;
        String jumpOidStr = null;
        try {
            jumpOidStr = System.getProperty("jumpoid");
        }
        catch (SecurityException se) {
            Log.log.info((Object)"Not checking for jumpOid as we're in an applet.", new Object[0]);
        }
        if (jumpOidStr != null) {
            try {
                moveOid = Integer.parseInt(jumpOidStr);
            }
            catch (NumberFormatException nfe) {
                Log.log.warning((Object)("Invalid jump oid [oid=" + jumpOidStr + ", err=" + nfe + "]."), new Object[0]);
            }
        } else if (this._body.location != null) {
            moveOid = this._body.location.placeOid;
        } else {
            MiCasaBootstrapData data = (MiCasaBootstrapData)client.getBootstrapData();
            moveOid = data.defLobbyOid;
        }
        if (moveOid > 0) {
            this._ctx.getLocationDirector().moveTo(moveOid);
        }
    }

    public void clientObjectDidChange(Client client) {
        this._body = (BodyObject)client.getClientObject();
    }

    public void clientDidLogoff(Client client) {
        Log.log.info((Object)("Client did logoff [client=" + client + "]."), new Object[0]);
        this._frame.setPanel(this._logonPanel);
    }
}

