/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.spot.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.crowd.chat.data.ChatCodes;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.chat.server.SpeakUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.server.InvocationException;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.util.Name;
import com.threerings.whirled.data.ScenePlace;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.spot.Log;
import com.threerings.whirled.spot.client.SpotService;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotMarshaller;
import com.threerings.whirled.spot.data.SpotScene;
import com.threerings.whirled.spot.server.SpotProvider;
import com.threerings.whirled.spot.server.SpotSceneManager;
import com.threerings.whirled.spot.server.SpotSceneMoveHandler;

@Singleton
public class SpotSceneRegistry
extends SceneRegistry
implements SpotProvider {
    @Inject
    public SpotSceneRegistry(InvocationManager invmgr) {
        super(invmgr);
        invmgr.registerProvider((InvocationProvider)this, SpotMarshaller.class, "whirled");
    }

    public void sendClusterChatMessage(int sceneId, int speakerOid, Name speaker, String bundle, String message, byte mode) {
        this.sendClusterChatMessage(sceneId, speakerOid, new UserMessage(speaker, bundle, message, mode));
    }

    public void sendClusterChatMessage(int sceneId, int speakerOid, UserMessage message) {
        SpotSceneManager smgr = (SpotSceneManager)this.getSceneManager(sceneId);
        if (smgr == null) {
            Log.log.warning((Object)"User requested cluster chat in non-existent scene", new Object[]{"user", message.speaker, "sceneId", sceneId, "message", message});
            return;
        }
        smgr.handleClusterMessageRequest(speakerOid, message);
    }

    public void traversePortal(ClientObject caller, int sceneId, int portalId, int destSceneVer, SpotService.SpotSceneMoveListener listener) throws InvocationException {
        BodyObject body = this._locator.forClient(caller);
        int cSceneId = ScenePlace.getSceneId(body);
        if (cSceneId != sceneId) {
            Log.log.info((Object)"Ignoring stale traverse portal request", new Object[]{"caller", caller.who(), "oSceneId", sceneId, "portalId", portalId, "cSceneId", cSceneId});
            listener.requestCancelled();
            return;
        }
        SpotSceneManager srcmgr = (SpotSceneManager)this.getSceneManager(sceneId);
        if (srcmgr == null) {
            Log.log.warning((Object)"Traverse portal missing source scene", new Object[]{"user", body.who(), "sceneId", sceneId, "portalId", portalId});
            throw new InvocationException("m.internal_error");
        }
        SpotScene rss = (SpotScene)((Object)srcmgr.getScene());
        Portal dest = rss.getPortal(portalId);
        String errmsg = srcmgr.mayTraversePortal(body, dest);
        if (errmsg != null) {
            throw new InvocationException(errmsg);
        }
        if (dest == null || !dest.isValid()) {
            Log.log.warning((Object)"Traverse portal with invalid portal", new Object[]{"user", body.who(), "scene", srcmgr.where(), "pid", portalId, "portal", dest, "portals", rss.getPortals()});
            throw new InvocationException("m.no_such_portal");
        }
        this.resolveScene(dest.targetSceneId, new SpotSceneMoveHandler(this._locman, srcmgr, body, destSceneVer, dest, listener));
    }

    public void changeLocation(ClientObject caller, int sceneId, Location loc, InvocationService.ConfirmListener listener) throws InvocationException {
        BodyObject source = this._locator.forClient(caller);
        int cSceneId = ScenePlace.getSceneId(source);
        if (cSceneId != sceneId) {
            Log.log.info((Object)"Rejecting changeLocation for invalid scene", new Object[]{"user", source.who(), "insid", cSceneId, "wantsid", sceneId, "loc", loc});
            throw new InvocationException("m.invalid_location");
        }
        SpotSceneManager smgr = (SpotSceneManager)this.getSceneManager(sceneId);
        if (smgr == null) {
            Log.log.warning((Object)"User requested to change location from non-existent scene", new Object[]{"user", source.who(), "sceneId", sceneId, "loc", loc});
            throw new InvocationException("m.internal_error");
        }
        smgr.handleChangeLoc(source, loc);
        listener.requestProcessed();
    }

    public void joinCluster(ClientObject caller, int friendOid, InvocationService.ConfirmListener listener) throws InvocationException {
        BodyObject source = this._locator.forClient(caller);
        int sceneId = ScenePlace.getSceneId(source);
        SpotSceneManager smgr = (SpotSceneManager)this.getSceneManager(sceneId);
        if (smgr == null) {
            Log.log.warning((Object)"User requested to join cluster from non-existent scene", new Object[]{"user", source.who(), "sceneId", sceneId, "foid", friendOid});
            throw new InvocationException("m.internal_error");
        }
        smgr.handleJoinCluster(source, friendOid);
        listener.requestProcessed();
    }

    public void clusterSpeak(ClientObject caller, String message, byte mode) {
        BodyObject source = this._locator.forClient(caller);
        String errmsg = source.checkAccess(ChatCodes.CHAT_ACCESS, null);
        if (errmsg != null) {
            SpeakUtil.sendFeedback((DObject)source, (String)"global", (String)errmsg);
        } else {
            this.sendClusterChatMessage(ScenePlace.getSceneId(source), source.getOid(), source.getVisibleName(), null, message, mode);
        }
    }
}

