/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.data;

import com.samskivert.util.StringUtil;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.util.ActionScript;
import com.threerings.whirled.Log;
import com.threerings.whirled.data.SceneModel;
import java.io.IOException;

public class SceneUpdate
implements Streamable,
Cloneable {
    protected transient int _targetId;
    protected transient int _targetVersion;
    @ActionScript(omit=true)
    protected static ThreadLocal<Boolean> _dbSer = new ThreadLocal();

    public void init(int targetId, int targetVersion) {
        this._targetId = targetId;
        this._targetVersion = targetVersion;
    }

    public int getSceneId() {
        return this._targetId;
    }

    public int getSceneVersion() {
        return this._targetVersion;
    }

    public int getVersionIncrement() {
        return 1;
    }

    public void validate(SceneModel model) throws IllegalStateException {
        if (model.sceneId != this._targetId) {
            String errmsg = "Wrong target scene, expected id " + this._targetId + " got id " + model.sceneId;
            throw new IllegalStateException(errmsg);
        }
        if (model.version != this._targetVersion) {
            String errmsg = "Target scene not proper version, expected " + this._targetVersion + " got " + model.version;
            throw new IllegalStateException(errmsg);
        }
    }

    public void apply(SceneModel model) {
        model.version = Math.max(this._targetVersion + this.getVersionIncrement(), model.version);
        if (model.version == this._targetVersion) {
            Log.log.warning((Object)("Egads! This scene has been updated two billion times [model=" + model + ", update=" + this + "]."), new Object[0]);
        }
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        if (null == _dbSer.get()) {
            out.writeInt(this._targetId);
            out.writeInt(this._targetVersion);
        }
        out.defaultWriteObject();
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (null == _dbSer.get()) {
            this._targetId = in.readInt();
            this._targetVersion = in.readInt();
        }
        in.defaultReadObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ActionScript(omit=true)
    public void persistTo(ObjectOutputStream out) throws IOException {
        _dbSer.set(Boolean.TRUE);
        try {
            out.writeBareObject((Object)this);
        }
        finally {
            _dbSer.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ActionScript(omit=true)
    public void unpersistFrom(ObjectInputStream in) throws IOException, ClassNotFoundException {
        _dbSer.set(Boolean.TRUE);
        try {
            in.readBareObject((Object)this);
        }
        finally {
            _dbSer.set(null);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        this.toString(buf);
        return buf.append("]").toString();
    }

    @ActionScript(name="toStringBuilder")
    protected void toString(StringBuilder buf) {
        buf.append("sceneId=").append(this._targetId);
        buf.append(", version=").append(this._targetVersion);
        buf.append(", ");
        StringUtil.fieldsToString((StringBuilder)buf, (Object)this);
    }
}

