/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.collect.Lists;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileUtil;
import com.threerings.stage.Log;
import com.threerings.stage.tools.editor.EditorModelListener;
import java.util.List;

public class EditorModel {
    public static final int ACTION_PLACE_TILE = 0;
    public static final int ACTION_EDIT_TILE = 1;
    public static final int ACTION_PLACE_PORTAL = 2;
    public static final int NUM_ACTIONS = 3;
    public static final int BASE_LAYER = 0;
    public static final int OBJECT_LAYER = 1;
    public static final String[] LAYER_NAMES = new String[]{"Base", "Object"};
    public static final String[] TIP_ACTIONS = new String[]{"Place/Delete tiles.", "Edit object tiles.", "Create/Edit/Delete portal."};
    public static final String[] CMD_ACTIONS = new String[]{"place_tile", "edit_tile", "place_portal"};
    protected int _mode;
    protected TileSet _tileSet;
    protected int _tileSetId;
    protected int _tileIndex;
    protected int _fqTileId;
    protected int _lnum;
    protected Tile _tile;
    protected List<EditorModelListener> _listeners = Lists.newArrayList();
    protected TileManager _tilemgr;
    protected int _objectGrip = 7;

    public EditorModel(TileManager tilemgr) {
        this._tilemgr = tilemgr;
        this._tileIndex = -1;
        this._tileSetId = -1;
        this._mode = 0;
        this._lnum = 0;
    }

    public void addListener(EditorModelListener l) {
        if (!this._listeners.contains(l)) {
            this._listeners.add(l);
        }
    }

    protected void notifyListeners(int event) {
        int size = this._listeners.size();
        for (int ii = 0; ii < size; ++ii) {
            this._listeners.get(ii).modelChanged(event);
        }
    }

    public boolean isTileValid() {
        return this._tile != null;
    }

    public int getActionMode() {
        return this._mode;
    }

    public int getLayerIndex() {
        return this._lnum;
    }

    public TileSet getTileSet() {
        return this._tileSet;
    }

    public int getTileSetId() {
        return this._tileSetId;
    }

    public int getTileId() {
        return this._tileIndex;
    }

    public Tile getTile() {
        return this._tile;
    }

    public int getFQTileId() {
        return this._fqTileId;
    }

    public void clearTile() {
        this._tileSet = null;
        this._tileSetId = -1;
        this._tileIndex = -1;
        this._tile = null;
    }

    public void setActionMode(String cmd) {
        for (int ii = 0; ii < CMD_ACTIONS.length; ++ii) {
            if (!CMD_ACTIONS[ii].equals(cmd)) continue;
            this._mode = ii;
            this.notifyListeners(0);
            return;
        }
        Log.log.warning((Object)("Attempt to set to unknown mode [cmd=" + cmd + "]."), new Object[0]);
    }

    public void setLayerIndex(int lnum) {
        if (lnum != this._lnum) {
            this._lnum = lnum;
            this.notifyListeners(1);
        }
    }

    public void setTile(TileSet set, int tileSetId, int tileIndex) {
        this._tile = set.getTile(tileIndex);
        this._tileSet = set;
        this._tileSetId = tileSetId;
        this._tileIndex = tileIndex;
        this._fqTileId = TileUtil.getFQTileId((int)tileSetId, (int)tileIndex);
        this.notifyListeners(2);
    }

    public void setTileId(int tileIndex) {
        this.setTile(this._tileSet, this._tileSetId, tileIndex);
    }

    public void setObjectGripDirection(int direction) {
        this._objectGrip = direction;
    }

    public int getObjectGripDirection() {
        return this._objectGrip;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[set=").append(this._tileSet);
        buf.append(", tid=").append(this._tileIndex);
        buf.append(", lnum=").append(this._lnum);
        buf.append(", tile=").append(this._tile);
        return buf.append("]").toString();
    }
}

