/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.client;

import com.google.common.collect.Maps;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.Colorization;
import com.threerings.media.tile.TileSet;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.stage.Log;
import com.threerings.stage.data.StageScene;
import java.util.Iterator;
import java.util.Map;

public class SceneColorizer
implements TileSet.Colorizer {
    protected TileSet.Colorizer _aux;
    protected ColorPository _cpos;
    protected StageScene _scene;
    protected Map<String, int[]> _cids = Maps.newHashMap();

    public SceneColorizer(ColorPository cpos, StageScene scene) {
        this._cpos = cpos;
        this._scene = scene;
        Iterator iter = this._cpos.enumerateClasses();
        while (iter.hasNext()) {
            String cname = ((ColorPository.ClassRecord)iter.next()).name;
            this._cids.put(cname, this._cpos.enumerateColorIds(cname));
        }
    }

    public void setAuxiliary(TileSet.Colorizer aux) {
        this._aux = aux;
    }

    public TileSet.Colorizer getColorizer(final ObjectInfo oinfo) {
        if (oinfo.zations == 0) {
            return this;
        }
        return new TileSet.Colorizer(){

            public Colorization getColorization(int index, String zation) {
                int colorId = 0;
                switch (index) {
                    case 0: {
                        colorId = oinfo.getPrimaryZation();
                        break;
                    }
                    case 1: {
                        colorId = oinfo.getSecondaryZation();
                        break;
                    }
                    case 2: {
                        colorId = oinfo.getTertiaryZation();
                        break;
                    }
                    case 3: {
                        colorId = oinfo.getQuaternaryZation();
                    }
                }
                if (colorId == 0) {
                    return SceneColorizer.this.getColorization(index, zation);
                }
                return SceneColorizer.this._cpos.getColorization(zation, colorId);
            }
        };
    }

    public Colorization getColorization(int index, String zation) {
        Colorization c;
        if (this._aux != null && (c = this._aux.getColorization(index, zation)) != null) {
            return c;
        }
        return this._cpos.getColorization(zation, this.getColorId(zation));
    }

    public int getColorId(String zation) {
        ColorPository.ClassRecord rec = this._cpos.getClassRecord(zation);
        int colorId = this._scene.getDefaultColor(rec.classId);
        if (colorId == -1) {
            ColorPository.ColorRecord def = rec.getDefault();
            if (def != null) {
                return def.colorId;
            }
            int[] cids = this._cids.get(zation);
            if (cids == null) {
                Log.log.warning((Object)("Zoiks, have no colorizations for '" + zation + "'."), new Object[0]);
                return -1;
            }
            colorId = cids[this._scene.getZoneId() % cids.length];
        }
        return colorId;
    }
}

