/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.util;

import com.threerings.puzzle.Log;
import java.awt.Point;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointSet {
    protected int _rangeX;
    protected int _rangeY;
    protected boolean[][] _points;
    protected int _count;

    public PointSet(int rangeX, int rangeY) {
        this._rangeX = rangeX;
        this._rangeY = rangeY;
        this._points = new boolean[rangeX][rangeY];
    }

    public boolean add(int x, int y) {
        boolean present = this._points[x][y];
        this._points[x][y] = true;
        if (!present) {
            ++this._count;
        }
        return present;
    }

    public void addAll(PointSet set) {
        Point pt;
        Iterator<Point> iter = set.iterator();
        while ((pt = iter.next()) != null) {
            this.add(pt.x, pt.y);
        }
    }

    public void clear() {
        if (this._count == 0) {
            return;
        }
        for (int xx = 0; xx < this._rangeX; ++xx) {
            for (int yy = 0; yy < this._rangeY; ++yy) {
                this._points[xx][yy] = false;
            }
        }
        this._count = 0;
    }

    public boolean contains(int x, int y) {
        return this._points[x][y];
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public Iterator<Point> iterator() {
        return new PointIterator();
    }

    public boolean remove(int x, int y) {
        boolean present = this._points[x][y];
        this._points[x][y] = false;
        if (present) {
            --this._count;
        }
        return present;
    }

    public int size() {
        return this._count;
    }

    public String toString() {
        Point val;
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Iterator<Point> iter = this.iterator();
        while ((val = iter.next()) != null) {
            buf.append("(").append(val.x);
            buf.append(",").append(val.y);
            buf.append(")");
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.append("]").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PointIterator
    implements Iterator<Point> {
        protected int _curCount = 0;
        protected int _curX = 0;
        protected int _curY = 0;
        protected Point _point = new Point();

        protected PointIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._curCount < PointSet.this._count;
        }

        @Override
        public Point next() {
            if (this._curCount == PointSet.this._count) {
                return null;
            }
            while (!PointSet.this._points[this._curX][this._curY]) {
                this.advance();
            }
            ++this._curCount;
            this._point.setLocation(this._curX, this._curY);
            if (this._curCount < PointSet.this._count) {
                this.advance();
            }
            return this._point;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void advance() {
            if (++this._curX >= PointSet.this._rangeX) {
                this._curX = 0;
                ++this._curY;
            }
            if (this._curY >= PointSet.this._rangeY) {
                Log.log.warning((Object)"Advanced past point range.", new Object[0]);
                this._curY = 0;
            }
        }
    }
}

