/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.turn.client;

import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.parlor.game.client.GameController;
import com.threerings.parlor.game.client.GameControllerDelegate;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.parlor.turn.client.TurnGameController;
import com.threerings.parlor.turn.data.TurnGameObject;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.util.Name;

public class TurnGameControllerDelegate
extends GameControllerDelegate
implements AttributeChangeListener {
    protected TurnGameController _tgctrl;
    protected CrowdContext _ctx;
    protected GameObject _gameObj;
    protected TurnGameObject _turnGame;
    protected String _thfield;

    public TurnGameControllerDelegate(TurnGameController tgctrl) {
        super((GameController)((Object)tgctrl));
        this._tgctrl = tgctrl;
    }

    public boolean isOurTurn() {
        BodyObject self = (BodyObject)this._ctx.getClient().getClientObject();
        return this._gameObj.isInPlay() && self.getVisibleName().equals((Object)this._turnGame.getTurnHolder());
    }

    public int getTurnHolderIndex() {
        return this._gameObj.getPlayerIndex(this._turnGame.getTurnHolder());
    }

    public void init(CrowdContext ctx, PlaceConfig config) {
        this._ctx = ctx;
    }

    public void willEnterPlace(PlaceObject plobj) {
        this._gameObj = (GameObject)plobj;
        this._turnGame = (TurnGameObject)plobj;
        this._thfield = this._turnGame.getTurnHolderFieldName();
        plobj.addListener((ChangeListener)this);
    }

    public void didLeavePlace(PlaceObject plobj) {
        plobj.removeListener((ChangeListener)this);
        this._turnGame = null;
    }

    public void attributeChanged(AttributeChangedEvent event) {
        if (event.getName().equals(this._thfield)) {
            Name name = (Name)event.getValue();
            Name oname = (Name)event.getOldValue();
            if (!TurnGameObject.TURN_HOLDER_REPLACED.equals((Object)name) && !TurnGameObject.TURN_HOLDER_REPLACED.equals((Object)oname)) {
                this._tgctrl.turnDidChange(name);
            }
        }
    }
}

