/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.rating.util;

import com.samskivert.util.StringUtil;
import com.threerings.parlor.Log;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class Percentiler {
    protected boolean _fixedRange;
    protected long _total;
    protected long _snapTotal;
    protected int _min;
    protected int _max;
    protected int _nextRecomp;
    protected int[] _counts = new int[100];
    protected byte[] _percentile = new byte[100];
    protected byte[] _reverse = new byte[100];
    protected static final int BUCKET_COUNT = 100;
    protected static final int INT_SIZE = 4;

    public Percentiler() {
    }

    public Percentiler(int min, int max) {
        this._min = min;
        this._max = max;
        this._fixedRange = true;
    }

    public Percentiler(byte[] data) {
        ByteBuffer in = ByteBuffer.wrap(data);
        IntBuffer iin = in.asIntBuffer();
        this._max = iin.get();
        iin.get(this._counts);
        in.position(iin.position() * 4);
        LongBuffer lin = in.asLongBuffer();
        this._snapTotal = this._total = lin.get();
        in.position(iin.position() * 4 + lin.position() * 2 * 4);
        this._min = in.position() == in.limit() ? 0 : in.asIntBuffer().get();
        if (this._max < this._min) {
            Log.log.warning((Object)"Percentiler initialized with bogus range. Coping.", new Object[]{"min", this._min, "max", this._max});
            this._max = this._min + 1;
        }
        this.recomputePercentiles();
    }

    public void recordValue(float value) {
        this.recordValue(value, true);
    }

    public void recordValue(float value, boolean logNewMax) {
        if (this._total == 0L && !this._fixedRange) {
            this._min = (int)Math.floor(value);
            this._max = Math.max((int)Math.ceil(value), this._min + 1);
        }
        if (value < (float)this._min || value > (float)this._max) {
            int newmax;
            if (this._fixedRange) {
                Log.log.warning((Object)"Recording value outside of initially fixed range", new Object[]{"min", this._min, "max", this._max, "value", Float.valueOf(value)});
                this._fixedRange = false;
            }
            int newmin = value < (float)this._min ? this._max - (int)Math.ceil(((float)this._max - value) * 1.2f) : this._min;
            int n = newmax = value > (float)this._max ? this._min + (int)Math.ceil((value - (float)this._min) * 1.2f) : this._max;
            if (newmin > this._min || newmax < this._max) {
                Log.log.warning((Object)"Grew our range in crazy ways?!", new Object[]{"value", Float.valueOf(value), "total", this._total, "new", "" + newmin + ":" + newmax, "old", "" + this._min + ":" + this._max});
            }
            if (logNewMax) {
                Log.log.info((Object)"Resizing", new Object[]{"value", Float.valueOf(value), "total", this._total, "new", "" + newmin + ":" + newmax, "old", "" + this._min + ":" + this._max});
            }
            float ndelta = (float)(newmax - newmin) / 100.0f;
            float odelta = (float)(this._max - this._min) / 100.0f;
            int[] counts = new int[100];
            for (int ii = 0; ii < 100; ++ii) {
                float obot = (float)this._min + odelta * (float)ii;
                int newidx = Math.min(99, (int)Math.floor((obot - (float)newmin) / ndelta));
                float newoff = (float)Math.IEEEremainder(obot - (float)newmin, ndelta);
                float nextfrac = newoff + odelta - ndelta;
                if (nextfrac <= 0.0f || newidx == 99) {
                    int n2 = newidx;
                    counts[n2] = counts[n2] + this._counts[ii];
                    continue;
                }
                int next = Math.round((float)this._counts[ii] * nextfrac / odelta);
                int n3 = newidx;
                counts[n3] = counts[n3] + (this._counts[ii] - next);
                int n4 = newidx + 1;
                counts[n4] = counts[n4] + next;
            }
            this._min = newmin;
            this._max = newmax;
            this._counts = counts;
            this._nextRecomp = 0;
        }
        int n = this.toBucketIndex(value);
        this._counts[n] = this._counts[n] + 1;
        ++this._total;
        if (this._nextRecomp-- <= 0) {
            this.recomputePercentiles();
            this._nextRecomp = (int)(this._total / 20L);
        }
    }

    public long getRecordedCount() {
        return this._total;
    }

    public boolean isModified() {
        return this._total != this._snapTotal;
    }

    public void clearModified() {
        this._snapTotal = this._total;
    }

    public int getPercentile(float value) {
        if (value < (float)this._min) {
            return 0;
        }
        if (value > (float)this._max) {
            return 100;
        }
        return this._percentile[this.toBucketIndex(value)];
    }

    public float getRequiredScore(int percentile) {
        percentile = Math.max(0, Math.min(99, percentile));
        return (float)this._reverse[percentile] * ((float)(this._max - this._min) / 100.0f) + (float)this._min;
    }

    public int getMaxScore() {
        return this._max;
    }

    public int getMinScore() {
        return this._min;
    }

    public float[] getRequiredScores() {
        float[] scores = new float[100];
        for (int ii = 0; ii < 100; ++ii) {
            scores[ii] = this.getRequiredScore(ii);
        }
        return scores;
    }

    public int[] getCounts() {
        return (int[])this._counts.clone();
    }

    public void recomputePercentiles() {
        int ii;
        long accum = 0L;
        for (ii = 0; ii < 99; ++ii) {
            this._percentile[ii + 1] = (byte)(this._total == 0L ? 50 : (byte)((accum += (long)this._counts[ii]) * 100L / this._total));
        }
        int pp = 0;
        for (ii = 0; ii < 100; ++ii) {
            while (this._percentile[pp] < ii && pp < 99) {
                ++pp;
            }
            this._reverse[ii] = (byte)pp;
        }
    }

    public byte[] toBytes() {
        byte[] data = new byte[416];
        ByteBuffer out = ByteBuffer.wrap(data);
        IntBuffer iout = out.asIntBuffer();
        iout.put(this._max);
        iout.put(this._counts);
        out.position(iout.position() * 4);
        LongBuffer lout = out.asLongBuffer();
        lout.put(this._total);
        out.position(iout.position() * 4 + lout.position() * 2 * 4);
        out.asIntBuffer().put(this._min);
        return data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[total=").append(this._total);
        buf.append(", min=").append(this._min);
        buf.append(", max=").append(this._max);
        buf.append(", pcts=(");
        for (int ii = 0; ii < 10; ++ii) {
            if (ii > 0) {
                buf.append("-");
            }
            buf.append(StringUtil.format((float)this.getRequiredScore(10 * ii)));
        }
        return buf.append(")]").toString();
    }

    public void dumpGnuPlot(PrintWriter out) {
        float delta = (float)(this._max - this._min) / 100.0f;
        for (int ii = 0; ii < 100; ++ii) {
            out.println((float)this._min + (float)ii * delta + " " + this._percentile[ii] + " " + this._counts[ii]);
        }
    }

    public void dump(PrintWriter out) {
        int ii;
        int max = 0;
        for (int ii2 = 0; ii2 < 100; ++ii2) {
            if (this._counts[ii2] <= max) continue;
            max = this._counts[ii2];
        }
        int digits = (int)Math.ceil(Math.log(max) / Math.log(10.0));
        digits = Math.max(digits, 1);
        for (int rr = 9; rr >= 0; --rr) {
            out.print(StringUtil.pad((String)("" + (rr + 1) * max / 10), (int)digits) + " ");
            for (int ii3 = 0; ii3 < 100; ++ii3) {
                out.print(this._counts[ii3] * 10 / max > rr ? "*" : " ");
            }
            out.println("");
        }
        out.print(this.spaces(digits));
        for (ii = 0; ii < 100; ++ii) {
            out.print("-");
        }
        out.println("");
        out.print(this.spaces(digits));
        for (ii = 0; ii < 100; ++ii) {
            out.print(this._percentile[ii] % 10);
        }
        out.println("");
        out.print(this.spaces(digits));
        for (ii = 0; ii < 100; ++ii) {
            out.print(this._percentile[ii] / 10 % 10);
        }
        out.println("");
        out.println("");
        out.println("total: " + this._total + " min: " + this._min + " max: " + this._max + " delta: " + (float)this._max / 100.0f);
    }

    protected final String spaces(int count) {
        StringBuilder buf = new StringBuilder();
        for (int ii = 0; ii < count; ++ii) {
            buf.append(" ");
        }
        return buf.toString();
    }

    protected final int toBucketIndex(float value) {
        int idx = Math.round((value - (float)this._min) * 100.0f / (float)(this._max - this._min));
        if ((idx = Math.min(idx, 99)) < 0 || idx >= 100) {
            Log.log.warning((Object)"Bogus bucket index, using 0", new Object[]{"value", Float.valueOf(value), "max", this._max, "min", this._min, "idx", idx, new Throwable()});
            return 0;
        }
        return idx;
    }
}

