/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.card.client;

import com.threerings.media.sprite.FadableImageSprite;
import com.threerings.parlor.card.client.CardPanel;
import com.threerings.parlor.card.data.Card;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class CardSprite
extends FadableImageSprite {
    protected CardPanel _panel;
    protected Card _card;
    protected boolean _facingUp;
    protected boolean _draggable;
    protected double _scaleFactor = 1.0;
    protected long _flipDuration;
    protected long _flipStamp;
    protected Card _flipCard;

    public CardSprite(CardPanel panel, Card card) {
        this._panel = panel;
        this._card = card;
        this._facingUp = true;
        this.updateMirage();
    }

    public CardSprite(CardPanel panel, Card card, boolean facingUp) {
        this._panel = panel;
        this._card = card;
        this._facingUp = facingUp;
        this.updateMirage();
    }

    public void setCard(Card card) {
        this._card = card;
        this.updateMirage();
    }

    public Card getCard() {
        return this._card;
    }

    public void setFacingUp(boolean facingUp) {
        this._facingUp = facingUp;
        this.updateMirage();
    }

    public boolean isFacingUp() {
        return this._facingUp;
    }

    public void setDraggable(boolean draggable) {
        this._draggable = draggable;
    }

    public boolean isDraggable() {
        return this._draggable;
    }

    public void flip(Card newCard, long duration) {
        this._flipStamp = 0L;
        this._flipDuration = duration;
        this._flipCard = newCard;
        this._scaleFactor = 1.0;
    }

    public void tick(long tickStamp) {
        super.tick(tickStamp);
        if (this._flipDuration != -1L) {
            long diff;
            if (this._flipStamp == 0L) {
                this._flipStamp = tickStamp;
            }
            if ((diff = tickStamp - this._flipStamp) < this._flipDuration / 2L) {
                this._scaleFactor = 1.0 - (double)((float)diff * 2.0f / (float)this._flipDuration);
            } else {
                if (this._flipCard != null) {
                    this.setCard(this._flipCard);
                    this._flipCard = null;
                }
                this._scaleFactor = (double)((float)diff * 2.0f / (float)this._flipDuration) - 1.0;
            }
            if (this._scaleFactor > 1.0) {
                this._scaleFactor = 1.0;
                this._flipDuration = -1L;
            }
            if (this._mgr != null) {
                this._mgr.getRegionManager().invalidateRegion(this._bounds);
            }
        }
    }

    public void paint(Graphics2D gfx) {
        if (this._scaleFactor <= 0.0) {
            return;
        }
        AffineTransform otrans = gfx.getTransform();
        if (this._scaleFactor < 1.0) {
            int xtrans = this.getX() + this.getWidth() / 2;
            gfx.translate(xtrans, 0);
            gfx.scale(this._scaleFactor, 1.0);
            gfx.translate(-xtrans, 0);
        }
        super.paint(gfx);
        gfx.setTransform(otrans);
    }

    protected void updateMirage() {
        this.setMirage(this._card != null && this._facingUp ? this._panel.getCardImage(this._card) : this._panel.getCardBackImage());
    }
}

