/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.zone.data;

import com.google.protobuf.Message;
import com.hexnova.narya.data.ZoneSummary;
import com.samskivert.util.StringUtil;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import com.threerings.util.Name;
import com.threerings.whirled.zone.data.SceneSummary;
import java.io.IOException;

public class ZoneSummary
extends SimpleStreamableObject
implements ProtobufProvider<Message> {
    public int zoneId;
    public Name name;
    public SceneSummary[] scenes;
    private transient ZoneSummary.Builder builder = null;

    public String toString() {
        return "[zoneId=" + this.zoneId + ", name=" + this.name + ", scenes=" + StringUtil.toString((Object)this.scenes) + "]";
    }

    public void populate(Message message) throws IOException {
        com.hexnova.narya.data.ZoneSummary obj = (com.hexnova.narya.data.ZoneSummary)message;
        this.name = new Name(obj.getName());
        this.zoneId = obj.getZoneId();
        if (obj.getScenesCount() > 0) {
            this.scenes = new SceneSummary[obj.getScenesCount()];
        }
        for (int i = 0; i < obj.getScenesCount(); ++i) {
            com.hexnova.narya.data.SceneSummary s = obj.getScenes(i);
            this.scenes[i] = (SceneSummary)ProtobufRegistry.transform((Message)s);
        }
    }

    public Message transform() throws IOException {
        ZoneSummary.Builder builder = (ZoneSummary.Builder)this.getBuilder();
        builder.setZoneId(this.zoneId);
        builder.setName(this.name.toString());
        if (this.scenes != null) {
            for (SceneSummary s : this.scenes) {
                builder.addScenes((com.hexnova.narya.data.SceneSummary)s.transform());
            }
        }
        return builder.build();
    }

    public Message.Builder getBuilder() {
        if (this.builder == null) {
            this.builder = com.hexnova.narya.data.ZoneSummary.newBuilder();
        } else {
            this.builder.clear();
        }
        return this.builder;
    }
}

