/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.spot.tools.xml;

import com.samskivert.util.StringUtil;
import com.samskivert.util.ValueMarshaller;
import com.samskivert.xml.SetPropertyFieldsRule;
import com.threerings.tools.xml.NestableRuleSet;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotSceneModel;
import com.threerings.whirled.spot.tools.EditablePortal;
import java.lang.reflect.Field;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public abstract class SpotSceneRuleSet
implements NestableRuleSet {
    public String getOuterElement() {
        return "spot";
    }

    public void addRuleInstances(String prefix, Digester digester) {
        digester.addObjectCreate(prefix, SpotSceneModel.class.getName());
        digester.addRule(prefix, (Rule)new SetPropertyFieldsRule());
        digester.addRule(prefix + "/portal", (Rule)new PortalCreateRule(this));
        digester.addRule(prefix + "/portal", (Rule)new PortalFieldsRule());
        digester.addSetNext(prefix + "/portal", "addPortal", Portal.class.getName());
    }

    protected abstract Location createLocation();

    protected static class PortalFieldsRule
    extends Rule {
        protected PortalFieldsRule() {
        }

        public void begin(String namespace, String name, Attributes attrs) throws Exception {
            Portal portal = (Portal)this.digester.peek();
            Class<?> portalClass = portal.getClass();
            Location loc = portal.loc;
            Class<?> locClass = loc.getClass();
            for (int ii = 0; ii < attrs.getLength(); ++ii) {
                Cloneable container;
                Field field;
                String lname = attrs.getLocalName(ii);
                if (StringUtil.isBlank((String)lname)) {
                    lname = attrs.getQName(ii);
                }
                try {
                    field = portalClass.getField(lname);
                    container = portal;
                }
                catch (NoSuchFieldException nsfe) {
                    try {
                        field = locClass.getField(lname);
                        container = loc;
                    }
                    catch (NoSuchFieldException nsfe2) {
                        this.digester.getLogger().warn((Object)("Skipping property '" + lname + "' for which there is no field."));
                        continue;
                    }
                }
                String valstr = attrs.getValue(ii);
                Object value = ValueMarshaller.unmarshal(field.getType(), (String)valstr);
                if (this.digester.getLogger().isDebugEnabled()) {
                    this.digester.getLogger().debug((Object)("  Setting property '" + lname + "' to '" + valstr + "'"));
                }
                field.set(container, value);
            }
        }
    }

    protected static class PortalCreateRule
    extends ObjectCreateRule {
        protected SpotSceneRuleSet _ruleset;

        public PortalCreateRule(SpotSceneRuleSet ruleset) {
            super(EditablePortal.class.getName());
            this._ruleset = ruleset;
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            super.begin(namespace, name, attributes);
            Portal p = (Portal)this.digester.peek();
            p.loc = this._ruleset.createLocation();
        }
    }
}

