/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stats.data;

import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.stats.data.IntStat;
import com.threerings.stats.data.Stat;
import java.io.EOFException;
import java.io.IOException;

public class MaxIntStat
extends IntStat {
    protected int _maxValue;

    public int getMaxValue() {
        return this._maxValue;
    }

    @Override
    public boolean increment(int delta) {
        if (super.increment(delta)) {
            this._maxValue = Math.max(delta, this._maxValue);
            return true;
        }
        return false;
    }

    @Override
    public String valueToString() {
        return super.valueToString() + " " + String.valueOf(this._maxValue);
    }

    @Override
    public void persistTo(ObjectOutputStream out, Stat.AuxDataSource aux) throws IOException {
        super.persistTo(out, aux);
        out.writeInt(this._maxValue);
    }

    @Override
    public void unpersistFrom(ObjectInputStream in, Stat.AuxDataSource aux) throws IOException, ClassNotFoundException {
        super.unpersistFrom(in, aux);
        try {
            this._maxValue = in.readInt();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }
}

