/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.QuickSort;
import com.samskivert.util.StringUtil;
import com.threerings.media.SafeScrollPane;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileSetRepository;
import com.threerings.miso.tile.MisoTileManager;
import com.threerings.stage.Log;
import com.threerings.stage.tools.editor.EditorModel;
import com.threerings.stage.tools.editor.EditorModelListener;
import com.threerings.stage.tools.editor.EditorTileManager;
import com.threerings.stage.tools.editor.util.EditorContext;
import com.threerings.stage.tools.editor.util.TileSetUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class TileInfoPanel
extends JSplitPane
implements ListSelectionListener,
TreeSelectionListener,
EditorModelListener {
    protected static final int WIDTH = 400;
    protected static final int HEIGHT = 300;
    protected static final int EDGE_TILE_H = 4;
    protected static final int EDGE_TILE_V = 4;
    protected Map<Integer, List<TileSetRecord>> _layerSets = Maps.newHashMap();
    protected Map<Integer, TreePath> _idToTreePathMap = Maps.newHashMap();
    protected int[] _layerLengths;
    protected JTree _tsettree;
    protected DefaultMutableTreeNode _selected;
    protected JTable _tiletable;
    protected JList _quickList;
    protected TileSetRecord _curTrec;
    protected int _tablewid;
    protected SafeScrollPane _scroller;
    protected EditorModel _model;
    protected EditorContext _ctx;
    protected TileTableModel _tablemodel;
    protected boolean _settingTileOurselves;

    public TileInfoPanel(EditorContext ctx, EditorModel model) {
        TileSetRepository tsrepo = ctx.getTileSetRepository();
        this.registerKeyListener(ctx);
        this._model = model;
        this._model.addListener(this);
        this._ctx = ctx;
        try {
            this._layerLengths = new int[2];
            for (int ii = 0; ii < 2; ++ii) {
                this._layerSets.put(ii, new ArrayList());
            }
            Iterator tsids = tsrepo.enumerateTileSetIds();
            while (tsids.hasNext()) {
                Integer tsid = (Integer)tsids.next();
                TileSet set = tsrepo.getTileSet(tsid.intValue());
                int lidx = TileSetUtil.getLayerIndex(set);
                if (lidx == -1) continue;
                TileSetRecord rec = new TileSetRecord(lidx, tsid, set);
                this._layerSets.get(lidx).add(rec);
            }
            for (int ii = 0; ii < 2; ++ii) {
                this._layerLengths[ii] = this._layerSets.get(ii).size();
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)"Error enumerating tilesets.", new Object[]{e});
        }
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(BorderFactory.createTitledBorder(border, "Tile Info"));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this._tsettree = new JTree(root);
        DefaultTreeCellRenderer cellrend = (DefaultTreeCellRenderer)this._tsettree.getCellRenderer();
        cellrend.setLeafIcon(null);
        cellrend.setOpenIcon(null);
        cellrend.setClosedIcon(null);
        this._tsettree.getSelectionModel().setSelectionMode(1);
        this._tsettree.addTreeSelectionListener(this);
        SafeScrollPane scrolly = new SafeScrollPane((Component)this._tsettree);
        scrolly.setVerticalScrollBarPolicy(22);
        DefaultListModel<String> qmodel = new DefaultListModel<String>();
        for (int ii = 0; ii < 10; ++ii) {
            qmodel.addElement("");
        }
        this._quickList = new JList(qmodel);
        this._quickList.setSelectionMode(0);
        this._quickList.addListSelectionListener(this);
        this._quickList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setText("" + (index + 11) % 10 + ". " + this.getText());
                return result;
            }
        });
        JSplitPane leftSplit = new JSplitPane(0);
        leftSplit.setTopComponent((Component)new SafeScrollPane((Component)this._quickList));
        leftSplit.setBottomComponent((Component)scrolly);
        this.setLeftComponent(leftSplit);
        this._tablemodel = new TileTableModel();
        this._tiletable = new JTable(this._tablemodel);
        this._tiletable.getSelectionModel().addListSelectionListener(this);
        this._tiletable.setSelectionMode(0);
        this.updateTileTable();
        this._scroller = new SafeScrollPane((Component)this._tiletable);
        this._scroller.setVerticalScrollBarPolicy(22);
        this.setRightComponent((Component)this._scroller);
        this.updateTileSetTree();
        this.setDividerLocation(230);
    }

    @Override
    public void modelChanged(int event) {
        if (event == 2 && !this._settingTileOurselves) {
            this.updateTileTable();
            TreePath path = this._idToTreePathMap.get(this._model.getTileSetId());
            this._tsettree.setSelectionPath(path);
            this._tsettree.scrollPathToVisible(path);
        }
    }

    protected void registerKeyListener(EditorContext ctx) {
        ctx.getKeyDispatcher().addGlobalKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keychar = e.getKeyChar();
                if (keychar < '0' || keychar > '9') {
                    return;
                }
                int index = (keychar - 48 + 9) % 10;
                if (e.isControlDown() || e.isAltDown()) {
                    if (TileInfoPanel.this._curTrec == null) {
                        return;
                    }
                    TileInfoPanel.this._quickList.clearSelection();
                    DefaultListModel model = (DefaultListModel)TileInfoPanel.this._quickList.getModel();
                    int olddex = model.indexOf(TileInfoPanel.this._curTrec);
                    if (olddex != -1) {
                        model.set(olddex, "");
                    }
                    model.set(index, TileInfoPanel.this._curTrec);
                    TileInfoPanel.this._quickList.setSelectedIndex(index);
                } else {
                    TileInfoPanel.this._quickList.setSelectedIndex(index);
                }
            }
        });
    }

    public void selectPreviousTile() {
        int row = this._tiletable.getSelectedRow();
        if (--row >= 0) {
            this._tiletable.setRowSelectionInterval(row, row);
        }
    }

    public void selectNextTile() {
        int row = this._tiletable.getSelectedRow();
        if (++row < this._tiletable.getRowCount()) {
            this._tiletable.setRowSelectionInterval(row, row);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tsettree.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            this._selected = node;
            Object uobj = node.getUserObject();
            if (!(uobj instanceof TileSetRecord)) {
                Log.log.info((Object)"Eh? Non-TileSetRecord leaf", new Object[]{"obj", uobj, "class", StringUtil.shortClassName((Object)uobj)});
                return;
            }
            this.tileSetSelected((TileSetRecord)uobj);
            this._quickList.clearSelection();
        }
    }

    protected void tileSetSelected(TileSetRecord trec) {
        if (this._model.getTileSet() != trec.tileSet) {
            this._curTrec = trec;
            this._model.setLayerIndex(trec.layer);
            this._settingTileOurselves = true;
            this._model.setTile(trec.tileSet, trec.tileSetId, 0);
            this._settingTileOurselves = false;
            this.updateTileTable();
        }
    }

    protected void insertTestTiles(HashIntMap<TileSet> tests) {
        for (int ii = 0; ii < 2; ++ii) {
            for (int jj = this._layerSets.get(ii).size() - 1; jj >= this._layerLengths[ii]; --jj) {
                this._layerSets.get(ii).remove(jj);
            }
        }
        MisoTileManager tileMgr = this._ctx.getTileManager();
        if (tileMgr instanceof EditorTileManager) {
            ((EditorTileManager)tileMgr).clearTestTileSets();
        }
        for (Integer tsid : tests.keySet()) {
            TileSet set = (TileSet)tests.get((Object)tsid);
            int lidx = TileSetUtil.getLayerIndex(set);
            if (lidx != -1) {
                TileSetRecord rec = new TileSetRecord(lidx, tsid, set);
                this._layerSets.get(lidx).add(rec);
            }
            if (!(tileMgr instanceof EditorTileManager)) continue;
            ((EditorTileManager)tileMgr).addTestTileSet(tsid, set);
        }
        this.updateTileSetTree();
    }

    public void updateTileSetTree() {
        this._idToTreePathMap.clear();
        DefaultTreeModel model = (DefaultTreeModel)this._tsettree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        root.removeAllChildren();
        ArrayList expand = Lists.newArrayList();
        DefaultMutableTreeNode base = new DefaultMutableTreeNode("Base Layer");
        root.add(base);
        this.addNodes(base, this.getSortedTileSets(0), "", 0, expand);
        DefaultMutableTreeNode obj = new DefaultMutableTreeNode("Object Layer");
        root.add(obj);
        this.addNodes(obj, this.getSortedTileSets(1), "", 0, expand);
        model.reload();
        for (TreePath treePath : expand) {
            this._tsettree.expandPath(treePath);
        }
        if (this._selected == null) {
            this._selected = root.getFirstLeaf();
        }
        this._tsettree.setSelectionPath(new TreePath(this._selected.getPath()));
    }

    protected TileSetRecord[] getSortedTileSets(int layer) {
        List<TileSetRecord> sets = this._layerSets.get(layer);
        Comparable[] sorted = new TileSetRecord[sets.size()];
        sets.toArray(sorted);
        QuickSort.sort((Comparable[])sorted);
        return sorted;
    }

    protected int addNodes(DefaultMutableTreeNode node, TileSetRecord[] list, String prefix, int position, ArrayList<TreePath> expand) {
        int prefixlen = prefix.length();
        int ii = position;
        while (ii < list.length) {
            String name = list[ii].fullname();
            if (!name.startsWith(prefix)) {
                return ii - position;
            }
            int dex = name.indexOf(47, prefixlen);
            if (dex == -1) {
                DefaultMutableTreeNode item = new DefaultMutableTreeNode(list[ii]);
                node.add(item);
                if (this._selected != null && list[ii].equals(this._selected.getUserObject())) {
                    this._selected = item;
                }
                this._idToTreePathMap.put(list[ii].tileSetId, new TreePath(item.getPath()));
                ++ii;
                continue;
            }
            String catname = name.substring(prefixlen, dex);
            DefaultMutableTreeNode category = new DefaultMutableTreeNode(catname);
            node.add(category);
            if (name.indexOf(47, dex + 1) != -1) {
                expand.add(new TreePath(category.getPath()));
            }
            ii += this.addNodes(category, list, name.substring(0, dex + 1), ii, expand);
        }
        return list.length - position;
    }

    protected void updateTileTable() {
        TableColumn tcol = this._tiletable.getColumnModel().getColumn(0);
        this._tablewid = tcol.getWidth() - 8;
        this._tiletable.clearSelection();
        this._tablemodel.updateTileSet();
        if (!this._model.isTileValid()) {
            return;
        }
        int numTiles = this.getTileCount();
        TileSet set = this._model.getTileSet();
        for (int ii = 0; ii < numTiles; ++ii) {
            BufferedImage img = set.getRawTileImage(ii);
            int hei = this.getScaledTileImageHeight(img);
            this._tiletable.setRowHeight(ii, hei + 8);
        }
        int tid = this._model.getTileId();
        this._tiletable.setRowSelectionInterval(tid, tid);
        if (this._scroller != null) {
            Rectangle r = this._tiletable.getCellRect(tid, 0, true);
            this._scroller.getViewport().setViewPosition(new Point(r.x, r.y));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object src = e.getSource();
        if (src == this._quickList) {
            Object o = this._quickList.getSelectedValue();
            if (o instanceof TileSetRecord) {
                this.tileSetSelected((TileSetRecord)o);
                if (o != this._selected.getUserObject()) {
                    this._tsettree.clearSelection();
                }
            }
        } else {
            ListSelectionModel lsm = (ListSelectionModel)src;
            if (!lsm.isSelectionEmpty()) {
                this._settingTileOurselves = true;
                this._model.setTileId(lsm.getMinSelectionIndex());
                this._settingTileOurselves = false;
            }
        }
    }

    protected int getTileCount() {
        if (!this._model.isTileValid()) {
            return 0;
        }
        TileSet set = this._model.getTileSet();
        return set == null ? 0 : set.getTileCount();
    }

    protected int getScaledTileImageHeight(Image img) {
        int wid = img.getWidth(null);
        int hei = img.getHeight(null);
        if (wid > this._tablewid) {
            float frac = (float)wid / (float)this._tablewid;
            return (int)((float)hei / frac);
        }
        return hei;
    }

    protected static class TileSetRecord
    implements Comparable<TileSetRecord> {
        public int layer;
        public int tileSetId;
        public TileSet tileSet;
        public String shortname;

        public TileSetRecord(int layer, int tileSetId, TileSet tileSet) {
            this.layer = layer;
            this.tileSetId = tileSetId;
            this.tileSet = tileSet;
            this.shortname = this.fullname();
            int lastdex = this.shortname.lastIndexOf(47);
            if (lastdex != -1) {
                this.shortname = this.shortname.substring(lastdex + 1);
            }
        }

        public String fullname() {
            return this.tileSet.getName();
        }

        public String toString() {
            return this.shortname;
        }

        @Override
        public int compareTo(TileSetRecord o) {
            return this.fullname().compareToIgnoreCase(o.fullname());
        }

        public boolean equals(Object o) {
            if (o instanceof TileSetRecord) {
                TileSetRecord tsr = (TileSetRecord)o;
                return tsr.layer == this.layer && tsr.tileSetId == this.tileSetId;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.layer, this.tileSetId});
        }
    }

    protected class TileTableModel
    extends AbstractTableModel {
        protected ImageIcon[] _icons;

        protected TileTableModel() {
        }

        public synchronized void updateTileSet() {
            int numTiles = TileInfoPanel.this.getTileCount();
            this._icons = new ImageIcon[numTiles];
            this.fireTableRowsInserted(0, numTiles);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        @Override
        public int getRowCount() {
            return TileInfoPanel.this.getTileCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this._icons[row] != null) {
                return this._icons[row];
            }
            TileSet set = TileInfoPanel.this._model.getTileSet();
            Image img = set.getRawTileImage(row);
            int hei = TileInfoPanel.this.getScaledTileImageHeight(img);
            if (hei != ((Image)img).getHeight(null)) {
                img = img.getScaledInstance(TileInfoPanel.this._tablewid, hei, 4);
            }
            this._icons[row] = new ImageIcon(img);
            return this._icons[row];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

