/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.collect.Lists;
import com.samskivert.swing.DimmedIcon;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileIcon;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.UniformTileSet;
import com.threerings.stage.Log;
import com.threerings.stage.tools.editor.EditorModel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class EditorToolBarPanel
extends JPanel
implements ActionListener {
    protected List<JButton> _buttons;
    protected EditorModel _model;
    protected static final String ICONS_PATH = "media/stage/tools/editor/toolbar_icons.png";

    public EditorToolBarPanel(TileManager tilemgr, EditorModel model) {
        this._model = model;
        this.setLayout(new FlowLayout(0));
        UniformTileSet tbset = tilemgr.loadTileSet(ICONS_PATH, 40, 40);
        JToolBar toolbar = new JToolBar();
        this._buttons = Lists.newArrayList();
        for (int ii = 0; ii < 3; ++ii) {
            Tile tile = tbset.getTile(ii);
            if (tile != null) {
                String cmd = EditorModel.CMD_ACTIONS[ii];
                String tip = EditorModel.TIP_ACTIONS[ii];
                JButton b = this.addButton(toolbar, cmd, tip, new TileIcon(tile));
                this._buttons.add(b);
                continue;
            }
            Log.log.warning((Object)("Unable to load toolbar icon [index=" + ii + "]."), new Object[0]);
        }
        this.setSelectedButton(this._buttons.get(0));
        this.add(toolbar);
    }

    protected JButton addButton(JToolBar toolbar, String cmd, String tip, TileIcon icon) {
        JButton button = new JButton((Icon)new DimmedIcon((Icon)icon));
        button.setSelectedIcon((Icon)icon);
        button.addActionListener(this);
        button.setActionCommand("tbar_" + cmd);
        button.setToolTipText(tip);
        toolbar.add(button);
        return button;
    }

    protected void setSelectedButton(JButton button) {
        for (int ii = 0; ii < this._buttons.size(); ++ii) {
            JButton tb;
            tb.setSelected((tb = this._buttons.get(ii)) == button);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.startsWith("tbar")) {
            this.setSelectedButton((JButton)e.getSource());
            this._model.setActionMode(cmd.substring(5));
        } else {
            Log.log.warning((Object)("Unknown action command [cmd=" + cmd + "]."), new Object[0]);
        }
    }
}

