/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.samskivert.swing.ScrollBox;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.stage.tools.editor.EditorScenePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class EditorScrollBox
extends ScrollBox {
    protected BufferedImage _miniMap;
    protected EditorScenePanel _panel;
    protected boolean _updatingView;
    protected static final int MAX_HEIGHT = 200;

    public EditorScrollBox(EditorScenePanel panel) {
        super(panel.getHorizModel(), panel.getVertModel());
        this._panel = panel;
        this._panel.setEditorScrollBox(this);
        this._panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtil.refresh((JComponent)((Object)EditorScrollBox.this));
            }
        });
        this.createMiniMap(1, 1);
    }

    public void updateView() {
        this._updatingView = true;
        this._horz.setValue(this._horz.getMinimum());
        this._vert.setValue(this._vert.getMinimum());
    }

    public Graphics2D getMiniGraphics() {
        Graphics2D gfx = (Graphics2D)this._miniMap.getGraphics();
        gfx.transform(AffineTransform.getTranslateInstance(this._box.x, this._box.y));
        gfx.transform(AffineTransform.getScaleInstance(this._hFactor, this._vFactor));
        if (this._updatingView) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorScrollBox.this.doNextPieceOfUpdate();
                }
            });
        }
        return gfx;
    }

    protected void doNextPieceOfUpdate() {
        int x = this._horz.getValue();
        int y = this._vert.getValue();
        int lastX = this._horz.getMaximum() - this._horz.getExtent();
        if (x != lastX) {
            x = Math.min(x + this._horz.getExtent(), lastX);
        } else {
            x = this._horz.getMinimum();
            int lastY = this._vert.getMaximum() - this._vert.getExtent();
            if (y != lastY) {
                y = Math.min(y + this._vert.getExtent(), lastY);
            } else {
                this._updatingView = false;
                return;
            }
        }
        this._horz.setValue(x);
        this._vert.setValue(y);
    }

    public Dimension getPreferredSize() {
        int horz = this._horz.getMaximum() - this._horz.getMinimum();
        int vert = this._vert.getMaximum() - this._vert.getMinimum();
        int height = 200;
        int width = Math.round((float)horz * ((float)height / (float)vert));
        int maxwidth = this.getParent().getWidth();
        if (maxwidth > 0 && width > maxwidth) {
            height = Math.round((float)height * ((float)maxwidth / (float)width));
            width = maxwidth;
        }
        return new Dimension(width, height);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (w != this._miniMap.getWidth() || h != this._miniMap.getHeight()) {
            this.createMiniMap(w, h);
        }
    }

    protected void paintBackground(Graphics g) {
        g.drawImage(this._miniMap, 0, 0, null);
    }

    protected void createMiniMap(int w, int h) {
        BufferedImage newMini;
        this._miniMap = newMini = new BufferedImage(w, h, 2);
        Graphics g = this._miniMap.getGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        g.dispose();
    }

    protected boolean isActiveButton(MouseEvent e) {
        return true;
    }
}

