/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.util;

import com.google.common.collect.Lists;
import com.threerings.puzzle.drop.data.DropBoard;
import com.threerings.puzzle.drop.data.DropPieceCodes;
import com.threerings.puzzle.drop.data.SegmentInfo;
import java.util.List;

public class PieceDestroyer
implements DropPieceCodes {
    protected DestroyLogic _logic;
    protected SegmentLengthOperation _lengthOp = new SegmentLengthOperation();
    protected List<SegmentInfo> _destroyed = Lists.newArrayList();

    public PieceDestroyer(DestroyLogic logic) {
        this._logic = logic;
    }

    public List<SegmentInfo> destroyPieces(DropBoard board, DropBoard.PieceOperation destroyOp) {
        int bwid = board.getWidth();
        int bhei = board.getHeight();
        this._destroyed.clear();
        int end = bwid - this._logic.getMinimumLength() + 1;
        for (int yy = bhei - 1; yy >= 0; --yy) {
            for (int xx = 0; xx < end; xx += this.findSegment(board, 0, xx, yy)) {
            }
        }
        end = this._logic.getMinimumLength() - 2;
        for (int xx = 0; xx < bwid; ++xx) {
            for (int yy = bhei - 1; yy > end; yy -= this.findSegment(board, 1, xx, yy)) {
            }
        }
        int size = this._destroyed.size();
        for (int ii = 0; ii < size; ++ii) {
            SegmentInfo si = this._destroyed.get(ii);
            board.applyOp(si.dir, si.x, si.y, si.len, destroyOp);
        }
        return this._destroyed;
    }

    protected int findSegment(DropBoard board, int dir, int x, int y) {
        this._lengthOp.reset();
        board.applyOp(dir, x, y, this._lengthOp);
        int len = this._lengthOp.getLength();
        if (len >= this._logic.getMinimumLength()) {
            this._destroyed.add(new SegmentInfo(dir, x, y, len));
        }
        return len;
    }

    protected class SegmentLengthOperation
    implements DropBoard.PieceOperation {
        protected int _piece;
        protected int _len;

        protected SegmentLengthOperation() {
        }

        public void reset() {
            this._len = 0;
        }

        public int getLength() {
            return this._len;
        }

        @Override
        public boolean execute(DropBoard board, int col, int row) {
            int piece = board.getPiece(col, row);
            if (this._len == 0) {
                this._len = 1;
                this._piece = piece;
                return piece != -1;
            }
            if (PieceDestroyer.this._logic.isEquivalent(piece, this._piece)) {
                ++this._len;
                return true;
            }
            return false;
        }
    }

    public static interface DestroyLogic {
        public int getMinimumLength();

        public boolean isEquivalent(int var1, int var2);
    }
}

