/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.client;

import com.google.common.collect.Lists;
import com.samskivert.swing.util.MouseHijacker;
import com.samskivert.util.CollectionUtil;
import com.samskivert.util.ObserverList;
import com.threerings.crowd.client.PlaceController;
import com.threerings.crowd.client.PlaceControllerDelegate;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.media.FrameParticipant;
import com.threerings.parlor.game.client.GameController;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.ElementUpdateListener;
import com.threerings.presents.dobj.ElementUpdatedEvent;
import com.threerings.presents.dobj.NamedAttributeListener;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.client.PuzzleBoardView;
import com.threerings.puzzle.client.PuzzleControllerDelegate;
import com.threerings.puzzle.client.PuzzlePanel;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.data.PuzzleCodes;
import com.threerings.puzzle.data.PuzzleObject;
import com.threerings.puzzle.util.PuzzleContext;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

public abstract class PuzzleController
extends GameController
implements PuzzleCodes {
    public static final String TOGGLE_CHATTING = "toggle_chat";
    protected Unpauser _unpauser;
    protected Updater _updater = this.createUpdater();
    protected ElementUpdateListener _kolist = new ElementUpdateListener(){

        public void elementUpdated(ElementUpdatedEvent event) {
            String name = event.getName();
            if (name.equals("playerStatus") && event.getIntValue() == 1) {
                PuzzleController.this.playerKnockedOut(event.getIndex());
            }
        }
    };
    protected AttributeChangeListener _mlist = new NamedAttributeListener("seed"){

        public void namedAttributeChanged(AttributeChangedEvent event) {
            PuzzleController.this.generateNewBoard();
        }
    };
    protected PuzzleContext _pctx;
    protected int _pidx;
    protected PuzzlePanel _panel;
    protected PuzzleObject _puzobj;
    protected PuzzleBoardView _pview;
    protected Board _pboard;
    protected List<Integer> _events = Lists.newArrayList();
    protected List<Board> _states = Lists.newArrayList();
    protected boolean _chatting = false;
    protected int _astate = 0;
    protected ObserverList<ClearPender> _clearPenders = ObserverList.newSafeInOrder();
    protected KeyListener _globalKeyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            int keycode = e.getKeyCode();
            if (keycode == 27 || keycode == 19) {
                PuzzleController.this.setChatting(!PuzzleController.this.isChatting());
            } else if (keycode == 80 && !PuzzleController.this.isChatting() && !PuzzleController.this._panel._xlate.hasCommand(80)) {
                PuzzleController.this.setChatting(true);
            }
        }
    };
    protected static final long DEFAULT_PROGRESS_INTERVAL = 6000L;
    protected static final int ACTION_CLEARED = 0;
    protected static final int CLEAR_PENDING = 1;
    protected static final int ACTION_GOING = 2;

    protected void didInit() {
        super.didInit();
        this._panel = (PuzzlePanel)this._view;
        this._pctx = (PuzzleContext)this._ctx;
        this._panel.init(this._config);
        this._pview = this._panel.getBoardView();
        this._pview.setController(this);
    }

    protected abstract Board newBoard();

    public Board getBoard() {
        return this._pboard;
    }

    public int getPlayerIndex() {
        return this._pidx;
    }

    @Override
    public void setGameOver(boolean gameOver) {
        super.setGameOver(gameOver);
        if (gameOver) {
            this.clearAction();
        }
    }

    public boolean hasAction() {
        return this._astate == 2;
    }

    public void setChatting(boolean chatting) {
        if (this.isChatting() == chatting || chatting && (!this.canStartChatting() || !this.hasAction())) {
            return;
        }
        this._panel.setPuzzleGrabsKeys(!chatting);
        if (chatting) {
            if (this._unpauser != null) {
                Log.log.warning((Object)"Huh? Already have a mouse unpauser?", new Object[0]);
                this._unpauser.release();
            }
            this._unpauser = new Unpauser(this._panel);
        } else if (this._unpauser != null) {
            this._unpauser.release();
            this._unpauser = null;
        }
        this._chatting = chatting;
        this.applyToDelegates(new PlaceController.DelegateOp(PuzzleControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((PuzzleControllerDelegate)delegate).setChatting(PuzzleController.this._chatting);
            }
        });
        if (this.supportsActionPause()) {
            if (chatting) {
                this.clearAction();
            } else {
                this.safeStartAction();
            }
            this._pview.setPaused(chatting);
        }
    }

    public String getPauseString() {
        return "m.paused";
    }

    protected boolean supportsActionPause() {
        return true;
    }

    protected boolean canStartChatting() {
        final boolean[] canChatNow = new boolean[]{true};
        this.applyToDelegates(new PlaceController.DelegateOp(PuzzleControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                canChatNow[0] = ((PuzzleControllerDelegate)delegate).canStartChatting() && canChatNow[0];
            }
        });
        return canChatNow[0];
    }

    public boolean isChatting() {
        return this._chatting;
    }

    @Override
    public void willEnterPlace(PlaceObject plobj) {
        super.willEnterPlace(plobj);
        this._puzobj = (PuzzleObject)plobj;
        this._puzobj.addListener((ChangeListener)this._kolist);
        this._puzobj.addListener((ChangeListener)this._mlist);
        this._pctx.getKeyDispatcher().addGlobalKeyListener(this._globalKeyListener);
        this._pidx = this._puzobj.getPlayerIndex(this._pctx.getUsername());
        this.generateNewBoard();
        if (this._puzobj.isInPlay() && this._puzobj.isActivePlayer(this._pidx)) {
            this.startAction();
        }
    }

    public void mayLeavePlace(PlaceObject plobj) {
        super.mayLeavePlace(plobj);
        this.sendProgressUpdate();
    }

    @Override
    public void didLeavePlace(PlaceObject plobj) {
        super.didLeavePlace(plobj);
        this.clearAction();
        this._pctx.getKeyDispatcher().removeGlobalKeyListener(this._globalKeyListener);
        if (this._puzobj != null) {
            this._puzobj.removeListener((ChangeListener)this._mlist);
            this._puzobj.removeListener((ChangeListener)this._kolist);
            this._puzobj = null;
        }
    }

    protected boolean isActionPuzzle() {
        return true;
    }

    protected boolean startActionImmediately() {
        return true;
    }

    @Override
    public void attributeChanged(AttributeChangedEvent event) {
        String name = event.getName();
        if (name.equals("state")) {
            switch (event.getIntValue()) {
                case 1: {
                    this.fireWhenActionCleared(new ClearPender(){

                        @Override
                        public int actionCleared() {
                            PuzzleController.this.gameDidStart();
                            return PuzzleController.this.startActionImmediately() ? -1 : 0;
                        }
                    });
                    break;
                }
                case 2: {
                    this.clearAction();
                    this.fireWhenActionCleared(new ClearPender(){

                        @Override
                        public int actionCleared() {
                            PuzzleController.this.gameDidEnd();
                            return 0;
                        }
                    });
                    break;
                }
                default: {
                    super.attributeChanged(event);
                    break;
                }
            }
        } else if (name.equals("sessionId")) {
            this._events.clear();
        }
    }

    @Override
    protected void gameWillReset() {
        super.gameWillReset();
        this.clearAction();
    }

    public void setBoard(Board board) {
    }

    protected void startAction() {
        if (!this.isActionPuzzle()) {
            return;
        }
        if (this._pidx != -1 && !this._pview.isShowing()) {
            Log.log.warning((Object)"Refusing to start action on hidden puzzle.", new Object[]{new Exception()});
            return;
        }
        if (this._astate != 0) {
            Log.log.warning((Object)"Action state inappropriate for startAction()", new Object[]{"astate", this._astate, new Exception()});
            return;
        }
        if (this.isChatting() && this.supportsActionPause()) {
            Log.log.info((Object)"Not starting action, player is chatting in a puzzle that supports pausing the action.", new Object[0]);
            return;
        }
        Log.log.debug((Object)"Starting puzzle action.", new Object[0]);
        if (!this._pctx.getFrameManager().isRegisteredFrameParticipant((FrameParticipant)this._updater)) {
            this._pctx.getFrameManager().registerFrameParticipant((FrameParticipant)this._updater);
        }
        this._astate = 2;
        this._panel.startAction();
        if (!this.isChatting()) {
            this._panel.setPuzzleGrabsKeys(true);
        }
        this.applyToDelegates(new PlaceController.DelegateOp(PuzzleControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((PuzzleControllerDelegate)delegate).startAction();
            }
        });
    }

    protected void safeStartAction() {
        if (!this.isActionPuzzle()) {
            return;
        }
        this.fireWhenActionCleared(new ClearPender(){

            @Override
            public int actionCleared() {
                return -1;
            }
        });
    }

    protected void clearAction() {
        if (!this.isActionPuzzle()) {
            return;
        }
        if (this._astate == 1 || this._astate == 0) {
            return;
        }
        Log.log.debug((Object)"Attempting to clear puzzle action.", new Object[0]);
        this._astate = 1;
        this.maybeClearAction();
    }

    protected void boardActionCleared() {
        this.maybeClearAction();
    }

    protected void fireWhenActionCleared(ClearPender pender) {
        if (this._astate == 0) {
            if (pender.actionCleared() == -1) {
                Log.log.debug((Object)("Restarting action at behest of pender " + pender + "."), new Object[0]);
                this.startAction();
            }
        } else {
            Log.log.debug((Object)("Queueing action pender " + pender + "."), new Object[0]);
            this._clearPenders.add((Object)pender);
        }
    }

    protected boolean canClearAction() {
        final boolean[] canClear = new boolean[]{this._pview.getActionCount() == 0};
        this.applyToDelegates(new PlaceController.DelegateOp(PuzzleControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                canClear[0] = canClear[0] && ((PuzzleControllerDelegate)delegate).canClearAction();
            }
        });
        return canClear[0];
    }

    protected void maybeClearAction() {
        if (this._astate == 1 && this.canClearAction()) {
            this.actuallyClearAction();
        }
    }

    protected void actuallyClearAction() {
        Log.log.debug((Object)"Actually clearing action.", new Object[0]);
        this._astate = 0;
        this.applyToDelegates(new PlaceController.DelegateOp(PuzzleControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((PuzzleControllerDelegate)delegate).clearAction();
            }
        });
        this._panel.clearAction();
        this._panel.setPuzzleGrabsKeys(false);
        this.sendProgressUpdate();
        try {
            this.actionWasCleared();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Choked in actionWasCleared", new Object[]{e});
        }
        final int[] results = new int[2];
        this._clearPenders.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ClearPender>(){

            public boolean apply(ClearPender observer) {
                switch (observer.actionCleared()) {
                    case -1: {
                        results[0] = results[0] + 1;
                        break;
                    }
                    case 1: {
                        results[1] = results[1] + 1;
                    }
                }
                return true;
            }
        });
        this._clearPenders.clear();
        if (results[1] == 0 && results[0] > 0) {
            this.startAction();
        }
    }

    protected void actionWasCleared() {
    }

    @Override
    public boolean handleAction(ActionEvent action) {
        String cmd = action.getActionCommand();
        if (!cmd.equals(TOGGLE_CHATTING)) {
            return super.handleAction(action);
        }
        this.setChatting(!this.isChatting());
        return true;
    }

    protected long getProgressInterval() {
        return 6000L;
    }

    protected void generateNewBoard() {
        this.fireWhenActionCleared(new ClearPender(){

            @Override
            public int actionCleared() {
                PuzzleController.this._pboard = PuzzleController.this.newBoard();
                if (PuzzleController.this._puzobj.seed != 0L) {
                    PuzzleController.this._pboard.initializeSeed(PuzzleController.this._puzobj.seed);
                }
                PuzzleController.this.setBoard(PuzzleController.this._pboard);
                PuzzleController.this._pview.setBoard(PuzzleController.this._pboard);
                PuzzleController.this._pview.repaint();
                PuzzleController.this.applyToDelegates(new PlaceController.DelegateOp(PuzzleControllerDelegate.class){

                    public void apply(PlaceControllerDelegate delegate) {
                        ((PuzzleControllerDelegate)delegate).setBoard(PuzzleController.this._pboard);
                    }
                });
                return 0;
            }
        });
    }

    public int getEventCount() {
        return this._events.size();
    }

    protected boolean isSyncingBoards() {
        return PuzzlePanel.isSyncingBoards();
    }

    public void addProgressEvent(int event, Board board) {
        if (this._puzobj.state != 1) {
            Log.log.warning((Object)"Rejecting progress event; game not in play", new Object[]{"puzobj", this._puzobj.which(), "event", event});
            return;
        }
        this.getBoard().seedFromEvent(this.getPlayerIndex(), event);
        this._events.add(event);
        if (this.isSyncingBoards()) {
            this._states.add(board == null ? null : board.clone());
            if (board == null) {
                Log.log.warning((Object)"Added progress event with no associated board state, server will not be able to ensure board state synchronization.", new Object[0]);
            }
        }
    }

    public void sendProgressUpdate() {
        int size = this._events.size();
        if (size == 0 || this._puzobj == null) {
            return;
        }
        int[] events = CollectionUtil.toIntArray(this._events);
        this._events.clear();
        int numStates = this._states.size();
        if (numStates == size) {
            Board[] states = new Board[numStates];
            this._states.toArray(states);
            this._states.clear();
            this._puzobj.puzzleGameService.updateProgressSync(this._puzobj.sessionId, events, states);
        } else {
            this._puzobj.puzzleGameService.updateProgress(this._puzobj.sessionId, events);
        }
    }

    protected void playerKnockedOut(final int pidx) {
        this.applyToDelegates(new PlaceController.DelegateOp(PuzzleControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((PuzzleControllerDelegate)delegate).playerKnockedOut(pidx);
            }
        });
    }

    protected Updater createUpdater() {
        return new Updater();
    }

    protected class Updater
    implements FrameParticipant {
        public long _lastProgressTick;

        protected Updater() {
        }

        public void tick(long tickStamp) {
            if (PuzzleController.this._astate == 0) {
                PuzzleController.this._pctx.getFrameManager().removeFrameParticipant((FrameParticipant)PuzzleController.this._updater);
            } else if (tickStamp - this._lastProgressTick > PuzzleController.this.getProgressInterval()) {
                this._lastProgressTick = tickStamp;
                PuzzleController.this.sendProgressUpdate();
            }
        }

        public boolean needsPaint() {
            return false;
        }

        public Component getComponent() {
            return null;
        }
    }

    class Unpauser
    extends MouseHijacker {
        protected MouseAdapter _clicker;
        protected PuzzlePanel _panel;

        public Unpauser(PuzzlePanel panel) {
            super((Component)((Object)panel.getBoardView()));
            this._clicker = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    PuzzleController.this.setChatting(false);
                }
            };
            this._panel = panel;
            panel.addMouseListener(this._clicker);
            panel.getBoardView().addMouseListener(this._clicker);
        }

        public Component release() {
            this._panel.removeMouseListener(this._clicker);
            this._panel.getBoardView().removeMouseListener(this._clicker);
            return super.release();
        }
    }

    public static interface ClearPender {
        public static final int RESTART_ACTION = -1;
        public static final int CARE_NOT = 0;
        public static final int NO_RESTART_ACTION = 1;

        public int actionCleared();
    }
}

