/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.tourney.server.persist;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.io.PersistenceException;
import com.samskivert.jdbc.ConnectionProvider;
import com.samskivert.jdbc.DatabaseLiaison;
import com.samskivert.jdbc.JDBCUtil;
import com.samskivert.jdbc.JORARepository;
import com.samskivert.jdbc.jora.Table;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.parlor.Log;
import com.threerings.parlor.tourney.data.TourneyConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

@Singleton
public class TourneyRepository
extends JORARepository {
    public static final String TOURNEY_DB_IDENT = "tourneydb";
    protected Table<TourneyRecord> _ttable;

    @Inject
    public TourneyRepository(ConnectionProvider conprov) {
        super(conprov, TOURNEY_DB_IDENT);
    }

    public void insertTourney(TourneyConfig tourney) throws PersistenceException {
        tourney.tourneyId = this.insert(this._ttable, new TourneyRecord(tourney));
    }

    public void updateTourney(TourneyConfig tourney) throws PersistenceException {
        this.store(this._ttable, new TourneyRecord(tourney));
    }

    public void deleteTourney(int tourneyId) throws PersistenceException {
        this.delete(this._ttable, new TourneyRecord(tourneyId));
    }

    public ArrayList<TourneyConfig> loadTournies() throws PersistenceException {
        ArrayList recordList = this.loadAll(this._ttable, "");
        ArrayList configList = Lists.newArrayListWithCapacity((int)recordList.size());
        for (TourneyRecord record : recordList) {
            configList.add(record.getTourneyConfig());
        }
        return configList;
    }

    protected void migrateSchema(Connection conn, DatabaseLiaison liaison) throws SQLException, PersistenceException {
        JDBCUtil.createTableIfMissing((Connection)conn, (String)"TOURNEYS", (String[])new String[]{"TOURNEY_ID INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY", "CONFIG BLOB"}, (String)"");
    }

    protected void createTables() {
        this._ttable = new Table(TourneyRecord.class, "TOURNEYS", "TOURNEY_ID", true);
    }

    public static class TourneyRecord {
        public int tourneyId;
        public byte[] config;

        public TourneyRecord() {
        }

        public TourneyRecord(int tourneyId) {
            this.tourneyId = tourneyId;
        }

        public TourneyRecord(TourneyConfig tourneyConfig) {
            this(tourneyConfig.tourneyId);
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            ObjectOutputStream ostream = new ObjectOutputStream((OutputStream)bstream);
            try {
                ostream.writeObject((Object)this.config);
                this.config = bstream.toByteArray();
            }
            catch (IOException e) {
                Log.log.warning((Object)("Error writing TourneyConfig to byte array [e=" + e + "]."), new Object[0]);
            }
        }

        public TourneyConfig getTourneyConfig() {
            ObjectInputStream ostream = new ObjectInputStream((InputStream)new ByteArrayInputStream(this.config));
            TourneyConfig tconfig = null;
            try {
                tconfig = (TourneyConfig)((Object)ostream.readObject());
            }
            catch (Exception e) {
                Log.log.warning((Object)("Error reading TourneyConfig from byte array [e=" + e + "]."), new Object[0]);
            }
            return tconfig;
        }
    }
}

