/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.rating.server.persist;

import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.annotation.Index;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.util.StringUtil;
import java.sql.Timestamp;

@Entity
public class RatingRecord
extends PersistentRecord {
    public static final Class<RatingRecord> _R = RatingRecord.class;
    public static final ColumnExp<Integer> GAME_ID = RatingRecord.colexp(_R, (String)"gameId");
    public static final ColumnExp<Integer> PLAYER_ID = RatingRecord.colexp(_R, (String)"playerId");
    public static final ColumnExp<Integer> RATING = RatingRecord.colexp(_R, (String)"rating");
    public static final ColumnExp<Integer> EXPERIENCE = RatingRecord.colexp(_R, (String)"experience");
    public static final ColumnExp<Timestamp> LAST_UPDATED = RatingRecord.colexp(_R, (String)"lastUpdated");
    public static final int SCHEMA_VERSION = 4;
    @Id
    public int gameId;
    @Id
    @Index
    public int playerId;
    public int rating;
    public int experience;
    public Timestamp lastUpdated;

    public RatingRecord() {
    }

    public RatingRecord(int gameId, int playerId, int rating, int experience) {
        this.gameId = gameId;
        this.playerId = playerId;
        this.rating = rating;
        this.experience = experience;
        this.lastUpdated = new Timestamp(System.currentTimeMillis());
    }

    public String toString() {
        return StringUtil.fieldsToString((Object)((Object)this));
    }

    public static Key<RatingRecord> getKey(int gameId, int playerId) {
        return RatingRecord.newKey(_R, (Comparable[])new Comparable[]{Integer.valueOf(gameId), Integer.valueOf(playerId)});
    }

    static {
        RatingRecord.registerKeyFields((ColumnExp[])new ColumnExp[]{GAME_ID, PLAYER_ID});
    }
}

