/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.parlor.data.ParlorCodes;
import com.threerings.parlor.data.TableConfig;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.util.ActionScript;
import com.threerings.util.Name;
import java.util.ArrayList;
import java.util.HashSet;

public class Table
implements DSet.Entry,
ParlorCodes {
    public static final int ANY_POSITION = -1;
    public int tableId;
    public int lobbyOid;
    public int gameOid = -1;
    public Name[] players;
    public Name[] watchers = this.createPlayerNamesArray(0);
    public transient int[] bodyOids;
    public GameConfig config;
    public TableConfig tconfig;
    protected static int _tableIdCounter = 0;
    protected transient HashSet<Name> _bannedUsers;

    @ActionScript(omit=true)
    public void init(int lobbyOid, TableConfig tconfig, GameConfig config) {
        this.tableId = ++_tableIdCounter;
        this.lobbyOid = lobbyOid;
        this.tconfig = tconfig;
        this.config = config;
        if (config.getMatchType() != 2) {
            this.players = this.createPlayerNamesArray(tconfig.desiredPlayerCount);
            this.bodyOids = new int[this.players.length];
            int acount = config.ais == null ? 0 : config.ais.length;
            for (int ii = 0; ii < acount; ++ii) {
                this.players[ii] = new Name("AI " + (ii + 1));
            }
        } else {
            this.players = this.createPlayerNamesArray(0);
            this.bodyOids = new int[0];
        }
    }

    @ActionScript(omit=true)
    public boolean isEmpty() {
        for (int bodyOid : this.bodyOids) {
            if (bodyOid == 0) continue;
            return false;
        }
        return true;
    }

    public int getOccupiedCount() {
        int count = 0;
        if (this.players != null) {
            for (Name player : this.players) {
                if (player == null) continue;
                ++count;
            }
        }
        return count;
    }

    public Name[] getPlayers() {
        if (1 == this.config.getMatchType()) {
            return this.createPlayerNamesArray(this.tconfig.desiredPlayerCount);
        }
        Name[] plist = this.createPlayerNamesArray(this.getOccupiedCount());
        if (this.players != null) {
            int dex = 0;
            for (int ii = 0; ii < this.players.length; ++ii) {
                if (this.players[ii] == null) continue;
                plist[dex++] = this.players[ii];
            }
        }
        return plist;
    }

    public int[][] getTeamMemberIndices() {
        int[][] teams = this.tconfig.teamMemberIndices;
        if (teams == null) {
            return null;
        }
        ArrayIntSet set = new ArrayIntSet();
        int[][] newTeams = new int[teams.length][];
        Object[] plist = this.getPlayers();
        for (int ii = 0; ii < teams.length; ++ii) {
            set.clear();
            for (int jj = 0; jj < teams[ii].length; ++jj) {
                Name occ = this.players[teams[ii][jj]];
                if (occ == null) continue;
                set.add(ListUtil.indexOf((Object[])plist, (Object)occ));
            }
            newTeams[ii] = set.toIntArray();
        }
        return newTeams;
    }

    @ActionScript(omit=true)
    public String setPlayer(int position, BodyObject player) {
        if (this._bannedUsers != null && this._bannedUsers.contains(player.getVisibleName())) {
            return "m.banned_from_table";
        }
        if (position == -1) {
            for (int ii = 0; ii < this.tconfig.desiredPlayerCount; ++ii) {
                if (this.players[ii] != null) continue;
                this.setPlayerPos(ii, player);
                return null;
            }
            return "m.table_position_occupied";
        }
        if (position >= this.tconfig.desiredPlayerCount || position < 0) {
            return "m.invalid_table_position";
        }
        if (this.players[position] != null) {
            return "m.table_position_occupied";
        }
        this.setPlayerPos(position, player);
        return null;
    }

    @ActionScript(omit=true)
    public void setPlayerPos(int position, BodyObject player) {
        this.players[position] = player.getVisibleName();
        this.bodyOids[position] = player.getOid();
    }

    public void addBannedUser(Name player) {
        if (this._bannedUsers == null) {
            this._bannedUsers = Sets.newHashSet();
        }
        this._bannedUsers.add(player);
    }

    @ActionScript(omit=true)
    public boolean clearPlayer(Name username) {
        if (this.players != null) {
            for (int ii = 0; ii < this.players.length; ++ii) {
                if (!username.equals((Object)this.players[ii])) continue;
                this.clearPlayerPos(ii);
                return true;
            }
        }
        return false;
    }

    @ActionScript(omit=true)
    public boolean clearPlayerByOid(int bodyOid) {
        if (this.bodyOids != null) {
            for (int ii = 0; ii < this.bodyOids.length; ++ii) {
                if (bodyOid != this.bodyOids[ii]) continue;
                this.clearPlayerPos(ii);
                return true;
            }
        }
        return false;
    }

    @ActionScript(omit=true)
    public void clearPlayerPos(int position) {
        this.players[position] = null;
        this.bodyOids[position] = 0;
    }

    @ActionScript(omit=true)
    public boolean containsPlayer(Name player) {
        return this.players != null && ListUtil.indexOf((Object[])this.players, (Object)player) != -1;
    }

    @ActionScript(omit=true)
    public void updateOccupants(GameObject gameobj) {
        ArrayList wlist = Lists.newArrayList();
        for (OccupantInfo info : gameobj.occupantInfo) {
            if (this.containsPlayer(info.username)) continue;
            wlist.add(info.username);
        }
        this.watchers = wlist.toArray(this.createPlayerNamesArray(wlist.size()));
    }

    public boolean mayBeStarted() {
        int[][] teams;
        switch (this.config.getMatchType()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        if (this.tconfig.teamMemberIndices == null) {
            return this.tconfig.minimumPlayerCount <= this.getOccupiedCount();
        }
        for (int[] team : teams = this.tconfig.teamMemberIndices) {
            int teamCount = 0;
            for (int element : team) {
                if (this.players[element] == null) continue;
                ++teamCount;
            }
            if (teamCount >= this.tconfig.minimumPlayerCount) continue;
            return false;
        }
        return true;
    }

    public boolean shouldBeStarted() {
        switch (this.config.getMatchType()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return this.tconfig.desiredPlayerCount <= this.getOccupiedCount();
    }

    public boolean inPlay() {
        return this.gameOid != -1;
    }

    public Comparable<?> getKey() {
        return this.tableId;
    }

    public boolean equals(Object other) {
        return other instanceof Table && this.tableId == ((Table)other).tableId;
    }

    public int hashCode() {
        return this.tableId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.shortClassName((Object)this));
        buf.append(" [");
        this.toString(buf);
        buf.append("]");
        return buf.toString();
    }

    @ActionScript(name="toStringBuilder")
    protected void toString(StringBuilder buf) {
        buf.append("tableId=").append(this.tableId);
        buf.append(", lobbyOid=").append(this.lobbyOid);
        buf.append(", gameOid=").append(this.gameOid);
        buf.append(", players=").append(StringUtil.toString((Object)this.players));
        buf.append(", config=").append(this.config);
    }

    protected Name[] createPlayerNamesArray(int length) {
        return new Name[length];
    }
}

