/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.client;

import com.samskivert.swing.SimpleSlider;
import com.threerings.parlor.client.TableConfigurator;
import com.threerings.parlor.game.client.SwingGameConfigurator;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class DefaultSwingTableConfigurator
extends TableConfigurator {
    protected SimpleSlider _playerSlider;
    protected JCheckBox _privateCheck;

    public DefaultSwingTableConfigurator(int players) {
        this(players, players > 2);
    }

    public DefaultSwingTableConfigurator(int players, boolean allowPrivate) {
        this(players, players, players, allowPrivate);
    }

    public DefaultSwingTableConfigurator(int minPlayers, int desiredPlayers, int maxPlayers, boolean allowPrivate) {
        this._config.minimumPlayerCount = minPlayers;
        if (minPlayers != maxPlayers) {
            this._playerSlider = new SimpleSlider("", minPlayers, maxPlayers, desiredPlayers);
        } else {
            this._config.desiredPlayerCount = desiredPlayers;
        }
        if (allowPrivate) {
            this._privateCheck = new JCheckBox();
        }
    }

    @Override
    protected void createConfigInterface() {
        super.createConfigInterface();
        SwingGameConfigurator gconf = (SwingGameConfigurator)this._gameConfigurator;
        if (this._playerSlider != null) {
            gconf.addControl(new JLabel("Players:"), (JComponent)this._playerSlider);
        }
        if (this._privateCheck != null) {
            gconf.addControl(new JLabel("Private:"), this._privateCheck);
        }
    }

    @Override
    public boolean isEmpty() {
        return this._playerSlider == null && this._privateCheck == null;
    }

    @Override
    protected void flushTableConfig() {
        super.flushTableConfig();
        if (this._playerSlider != null) {
            this._config.desiredPlayerCount = this._playerSlider.getValue();
        }
        if (this._privateCheck != null) {
            this._config.privateTable = this._privateCheck.isSelected();
        }
    }
}

