/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.lobby;

import com.threerings.crowd.client.PlaceController;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.micasa.Log;
import com.threerings.micasa.lobby.LobbyConfig;
import com.threerings.micasa.lobby.LobbyPanel;
import com.threerings.micasa.util.MiCasaContext;
import com.threerings.parlor.client.Invitation;
import com.threerings.parlor.client.InvitationHandler;
import com.threerings.parlor.client.InvitationResponseObserver;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.util.Name;

public class LobbyController
extends PlaceController
implements InvitationHandler,
InvitationResponseObserver {
    protected MiCasaContext _ctx;
    protected LobbyConfig _config;

    public void init(CrowdContext ctx, PlaceConfig config) {
        this._ctx = (MiCasaContext)ctx;
        this._config = (LobbyConfig)config;
        super.init(ctx, config);
        this._ctx.getParlorDirector().setInvitationHandler(this);
    }

    protected PlaceView createPlaceView(CrowdContext ctx) {
        return new LobbyPanel(this._ctx, this._config);
    }

    public void willEnterPlace(PlaceObject plobj) {
        super.willEnterPlace(plobj);
        try {
            String invitee = System.getProperty("invitee");
            if (invitee != null) {
                try {
                    GameConfig config = this._config.getGameConfig();
                    this._ctx.getParlorDirector().invite(new Name(invitee), config, this);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Error instantiating game config.", new Object[]{e});
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void invitationReceived(Invitation invite) {
        Log.log.info((Object)("Invitation received [invite=" + invite + "]."), new Object[0]);
        invite.accept();
    }

    @Override
    public void invitationCancelled(Invitation invite) {
        Log.log.info((Object)("Invitation cancelled " + invite + "."), new Object[0]);
    }

    @Override
    public void invitationAccepted(Invitation invite) {
        Log.log.info((Object)("Invitation accepted " + invite + "."), new Object[0]);
    }

    @Override
    public void invitationRefused(Invitation invite, String message) {
        Log.log.info((Object)("Invitation refused [invite=" + invite + ", message=" + message + "]."), new Object[0]);
    }

    @Override
    public void invitationCountered(Invitation invite, GameConfig config) {
        Log.log.info((Object)("Invitation countered [invite=" + invite + ", config=" + config + "]."), new Object[0]);
    }
}

