/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.client;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.event.AncestorAdapter;
import com.threerings.crowd.chat.client.ChatDisplay;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.SystemMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.client.OccupantObserver;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.micasa.Log;
import com.threerings.util.Name;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ChatPanel
extends JPanel
implements ActionListener,
ChatDisplay,
OccupantObserver,
PlaceView {
    protected CrowdContext _ctx;
    protected boolean _focus = true;
    protected JComboBox _roombox;
    protected JTextPane _text;
    protected JButton _send;
    protected JTextField _entry;
    protected Style _nameStyle;
    protected Style _msgStyle;
    protected Style _errStyle;
    protected Style _noticeStyle;
    protected static final int PREFERRED_WIDTH = 200;

    public ChatPanel(CrowdContext ctx) {
        this(ctx, true);
    }

    public ChatPanel(CrowdContext ctx, boolean showHintLabel) {
        this._ctx = ctx;
        this._ctx.getChatDirector().addChatDisplay((ChatDisplay)this);
        this._ctx.getOccupantDirector().addOccupantObserver((OccupantObserver)this);
        VGroupLayout gl = new VGroupLayout(GroupLayout.STRETCH);
        gl.setOffAxisPolicy(GroupLayout.STRETCH);
        this.setLayout((LayoutManager)gl);
        this._text = new JTextPane();
        this._text.setEditable(false);
        this.add(new JScrollPane(this._text));
        this.createStyles(this._text);
        if (showHintLabel) {
            this.add((Component)new JLabel("Type here to chat:"), GroupLayout.FIXED);
        }
        gl = new HGroupLayout(GroupLayout.STRETCH, GroupLayout.STRETCH, 5, GroupLayout.LEFT);
        JPanel epanel = new JPanel((LayoutManager)gl);
        this._entry = new JTextField();
        epanel.add(this._entry);
        this._entry.setActionCommand("send");
        this._entry.addActionListener(this);
        this._entry.setEnabled(false);
        this._send = new JButton("Chat!");
        this._send.setEnabled(false);
        this._send.addActionListener(this);
        this._send.setActionCommand("send");
        epanel.add((Component)this._send, GroupLayout.FIXED);
        this.add((Component)epanel, GroupLayout.FIXED);
        this.addAncestorListener((AncestorListener)new AncestorAdapter(){

            public void ancestorAdded(AncestorEvent e) {
                if (ChatPanel.this._focus) {
                    ChatPanel.this._entry.requestFocusInWindow();
                }
            }
        });
    }

    public void removeSendButton() {
        if (this._send.isVisible()) {
            this._send.setVisible(false);
        }
    }

    public void setRequestFocus(boolean focus) {
        this._focus = focus;
    }

    protected void createStyles(JTextPane text) {
        StyleContext sctx = StyleContext.getDefaultStyleContext();
        Style defstyle = sctx.getStyle("default");
        this._nameStyle = text.addStyle("name", defstyle);
        StyleConstants.setForeground(this._nameStyle, Color.blue);
        this._msgStyle = text.addStyle("msg", defstyle);
        StyleConstants.setForeground(this._msgStyle, Color.black);
        this._errStyle = text.addStyle("err", defstyle);
        StyleConstants.setForeground(this._errStyle, Color.red);
        this._noticeStyle = text.addStyle("notice", defstyle);
        StyleConstants.setForeground(this._noticeStyle, Color.magenta);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("send")) {
            this.sendText();
        } else {
            System.out.println("Unknown action event: " + cmd);
        }
    }

    public void occupantEntered(OccupantInfo info) {
        this.displayOccupantMessage("*** " + info.username + " entered.");
    }

    public void occupantLeft(OccupantInfo info) {
        this.displayOccupantMessage("*** " + info.username + " left.");
    }

    public void occupantUpdated(OccupantInfo oinfo, OccupantInfo info) {
    }

    protected void displayOccupantMessage(String message) {
        this.append(message + "\n", this._noticeStyle);
    }

    protected void sendText() {
        String text = this._entry.getText();
        if (text.startsWith("/tell")) {
            StringTokenizer tok = new StringTokenizer(text);
            if (tok.countTokens() < 3) {
                this.displayError("Usage: /tell username message");
                return;
            }
            tok.nextToken();
            String username = tok.nextToken();
            int uidx = text.indexOf(username);
            String message = text.substring(uidx + username.length()).trim();
            this._ctx.getChatDirector().requestTell(new Name(username), message, null);
        } else if (text.startsWith("/clear")) {
            this._ctx.getChatDirector().clearDisplays();
        } else {
            this._ctx.getChatDirector().requestSpeak(null, text, (byte)0);
        }
        this._entry.setText("");
    }

    public void clear() {
        this._text.setText("");
    }

    public boolean displayMessage(ChatMessage message, boolean displayed) {
        if (message instanceof UserMessage) {
            UserMessage msg = (UserMessage)message;
            if (msg.localtype == "userChat") {
                this.append("[" + msg.speaker + " whispers] ", this._nameStyle);
                this.append(msg.message + "\n", this._msgStyle);
            } else {
                this.append("<" + msg.speaker + "> ", this._nameStyle);
                this.append(msg.message + "\n", this._msgStyle);
            }
            return true;
        }
        if (message instanceof SystemMessage) {
            this.append(message.message + "\n", this._noticeStyle);
            return true;
        }
        Log.log.warning((Object)("Received unknown message type [message=" + message + "]."), new Object[0]);
        return false;
    }

    protected void displayError(String message) {
        this.append(message + "\n", this._errStyle);
    }

    protected void append(String text, Style style) {
        Document doc = this._text.getDocument();
        try {
            doc.insertString(doc.getLength(), text, style);
        }
        catch (BadLocationException ble) {
            Log.log.warning((Object)("Unable to insert text!? [error=" + ble + "]."), new Object[0]);
        }
    }

    public void willEnterPlace(PlaceObject place) {
        this._entry.setEnabled(true);
        this._send.setEnabled(true);
        if (this._focus) {
            this._entry.requestFocusInWindow();
        }
    }

    public void didLeavePlace(PlaceObject place) {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = 200;
        return size;
    }
}

