//
// $Id$
//
// Vilya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/vilya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.whirled.zone.data;

import java.io.IOException;

import com.samskivert.util.StringUtil;

import com.threerings.io.SimpleStreamableObject;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;
import com.threerings.util.Name;

/**
 * The zone summary contains information on a zone, including its name and
 * summary info on all of the scenes in this zone (which can be used to
 * generate a map of the zone on the client).
 */
public class ZoneSummary extends SimpleStreamableObject implements ProtobufProvider<com.google.protobuf.Message>
{
    /** The zone's fully qualified unique identifier. */
    public int zoneId;

    /** The name of the zone. */
    public Name name;

    /** The summary information for all of the scenes in the zone. */
    public SceneSummary[] scenes;

    @Override
    public String toString ()
    {
        return "[zoneId=" + zoneId + ", name=" + name +
            ", scenes=" + StringUtil.toString(scenes) + "]";
    }
    
    @Override
   	public void populate(com.google.protobuf.Message message) throws IOException {
       	com.hexnova.narya.data.ZoneSummary obj = (com.hexnova.narya.data.ZoneSummary)message;
       	this.name = new Name(obj.getName());
       	this.zoneId = obj.getZoneId();
       	
       	if(obj.getScenesCount() > 0) {
       		scenes = new SceneSummary[obj.getScenesCount()];
       	}
       	
       	for(int i=0;i<obj.getScenesCount();i++) {
       		com.hexnova.narya.data.SceneSummary s = obj.getScenes(i);
       		scenes[i] = ProtobufRegistry.transform(s);
       	}
   	}

   	@Override
   	public com.google.protobuf.Message transform() throws IOException {
   		com.hexnova.narya.data.ZoneSummary.Builder builder = (com.hexnova.narya.data.ZoneSummary.Builder)getBuilder();
   		builder.setZoneId(zoneId);
   		builder.setName(name.toString());
   		if(scenes != null) {
   			for(SceneSummary s : scenes) {
   				builder.addScenes((com.hexnova.narya.data.SceneSummary)s.transform());
   			}
   		}
   		return builder.build();
   	}

   	@Override
   	public com.google.protobuf.Message.Builder getBuilder() {
   		if(builder == null) {
   			builder = com.hexnova.narya.data.ZoneSummary.newBuilder();
   		}else {
   			builder.clear();
   		}
   		return builder;
   	}
   	
   	private transient com.hexnova.narya.data.ZoneSummary.Builder builder = null;
}
