/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.zone.peer.server;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.samskivert.util.Lifecycle;
import com.samskivert.util.Tuple;
import com.threerings.crowd.peer.server.CrowdPeerManager;
import com.threerings.presents.peer.data.NodeObject;
import com.threerings.util.Name;
import com.threerings.whirled.zone.Log;
import com.threerings.whirled.zone.peer.data.HostedZone;
import com.threerings.whirled.zone.peer.server.ZoneNodeObject;

public abstract class ZonePeerManager
extends CrowdPeerManager {
    @Inject
    public ZonePeerManager(Lifecycle cycle) {
        super(cycle);
    }

    protected NodeObject createNodeObject() {
        return new ZoneNodeObject();
    }

    public static NodeObject.Lock getZoneLock(int sceneId) {
        return new NodeObject.Lock("ZoneHost", (Comparable)Integer.valueOf(sceneId));
    }

    public Tuple<String, HostedZone> getZoneHost(final int zoneId) {
        return (Tuple)this.lookupNodeDatum(new NodeFunc<Tuple<String, HostedZone>>(){

            @Override
            public Tuple<String, HostedZone> apply(ZoneNodeObject nodeobj) {
                HostedZone info = (HostedZone)nodeobj.hostedZones.get((Comparable)Integer.valueOf(zoneId));
                return info == null ? null : Tuple.newTuple((Object)nodeobj.nodeName, (Object)((Object)info));
            }
        });
    }

    public void zoneDidStartup(int zoneId, Name name) {
        Log.log.debug((Object)"Hosting zone", new Object[]{"id", zoneId, "name", name});
        ((ZoneNodeObject)this._nodeobj).addToHostedZones(new HostedZone(zoneId, name));
    }

    public void zoneDidShutdown(int zoneId) {
        Log.log.debug((Object)"No longer hosting zone", new Object[]{"id", zoneId});
        ((ZoneNodeObject)this._nodeobj).removeFromHostedZones(Integer.valueOf(zoneId));
    }

    public static abstract class NodeFunc<T>
    implements Function<NodeObject, T> {
        public abstract T apply(ZoneNodeObject var1);

        public T apply(NodeObject nodeobj) {
            return this.apply((ZoneNodeObject)nodeobj);
        }
    }
}

