/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.server;

import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.LocationManager;
import com.threerings.presents.data.InvocationException;
import com.threerings.whirled.client.SceneService;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.server.AbstractSceneMoveHandler;
import com.threerings.whirled.server.SceneManager;

public class SceneMoveHandler
extends AbstractSceneMoveHandler {
    protected int _version;

    public SceneMoveHandler(LocationManager locman, BodyObject body, int sceneVer, SceneService.SceneMoveListener listener) {
        super(locman, body, listener);
        this._version = sceneVer;
    }

    @Override
    protected void effectSceneMove(SceneManager scmgr) throws InvocationException {
        int ploid = scmgr.getPlaceObject().getOid();
        PlaceConfig config = this._locman.moveTo(this._body, ploid);
        SceneService.SceneMoveListener listener = (SceneService.SceneMoveListener)this._listener;
        SceneModel model = scmgr.getScene().getSceneModel();
        if (this._version != model.version) {
            SceneUpdate[] updates = null;
            if (this._version < model.version) {
                updates = scmgr.getUpdates(this._version);
            }
            if (updates != null) {
                listener.moveSucceededWithUpdates(ploid, config, updates);
            } else {
                listener.moveSucceededWithScene(ploid, config, model);
            }
        } else {
            listener.moveSucceeded(ploid, config);
        }
    }
}

