/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.server;

import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.server.LocationManager;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.whirled.Log;
import com.threerings.whirled.server.SceneManager;
import com.threerings.whirled.server.SceneRegistry;

public abstract class AbstractSceneMoveHandler
implements SceneRegistry.ResolutionListener {
    protected LocationManager _locman;
    protected BodyObject _body;
    protected InvocationService.InvocationListener _listener;

    public AbstractSceneMoveHandler(LocationManager locman, BodyObject body, InvocationService.InvocationListener listener) {
        this._locman = locman;
        this._body = body;
        this._listener = listener;
    }

    @Override
    public void sceneWasResolved(SceneManager scmgr) {
        if (!this._body.isActive()) {
            Log.log.info((Object)("Abandoning scene move, client gone [who=" + this._body.who() + ", dest=" + scmgr.where() + "]."), new Object[0]);
            InvocationMarshaller.setNoResponse((InvocationService.InvocationListener)this._listener);
            return;
        }
        try {
            this.effectSceneMove(scmgr);
        }
        catch (InvocationException sfe) {
            this._listener.requestFailed(sfe.getMessage());
        }
        catch (RuntimeException re) {
            Log.log.warning((Object)re, new Object[0]);
            this._listener.requestFailed("m.internal_error");
        }
    }

    @Override
    public void sceneFailedToResolve(int sceneId, Exception reason) {
        Log.log.warning((Object)("Unable to resolve scene [sceneid=" + sceneId + ", reason=" + reason + "]."), new Object[0]);
        this._listener.requestFailed("m.no_such_place");
    }

    protected abstract void effectSceneMove(SceneManager var1) throws InvocationException;
}

