/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stats.data;

import com.threerings.presents.dobj.DSet;
import com.threerings.stats.data.IntArrayStat;
import com.threerings.stats.data.IntStat;
import com.threerings.stats.data.MaxIntStat;
import com.threerings.stats.data.SetStat;
import com.threerings.stats.data.Stat;
import com.threerings.stats.data.StatModifier;
import com.threerings.stats.data.StringMapStat;
import java.util.Iterator;

public class StatSet
extends DSet<Stat> {
    protected transient Container _container;

    public StatSet(Iterable<Stat> contents) {
        super(contents);
    }

    public StatSet(Iterator<Stat> contents) {
        super(contents);
    }

    public StatSet() {
    }

    public void setContainer(Container container) {
        this._container = container;
    }

    public <T extends Stat> void syncStat(StatModifier<T> modifier) {
        boolean wasModified = false;
        Stat stat = this.getStat(modifier.getType());
        if (stat != null) {
            wasModified = stat.isModified();
            modifier.modify(stat);
            this.updateStat(stat, true);
        } else {
            Stat nstat;
            stat = nstat = modifier.getType().newStat();
            modifier.modify(stat);
            this.addStat(stat, true);
        }
        stat.setModified(wasModified);
        stat.setModCount((byte)((stat.getModCount() + 1) % 127));
    }

    public void setStat(Stat.Type type, int value) {
        IntStat stat = (IntStat)this.getStat(type);
        if (stat == null) {
            stat = (IntStat)type.newStat();
            stat.setValue(value);
            this.addStat(stat, false);
        } else if (stat.setValue(value)) {
            this.updateStat(stat, false);
        }
    }

    public void maxStat(Stat.Type type, int value) {
        int ovalue = this.getIntStat(type);
        if (value > ovalue) {
            this.setStat(type, value);
        }
    }

    public void incrementStat(Stat.Type type, int delta) {
        IntStat stat = (IntStat)this.getStat(type);
        if (stat == null) {
            stat = (IntStat)type.newStat();
            stat.increment(delta);
            this.addStat(stat, false);
        } else if (stat.increment(delta)) {
            this.updateStat(stat, false);
        }
    }

    public void appendStat(Stat.Type type, int value) {
        IntArrayStat stat = (IntArrayStat)this.getStat(type);
        if (stat == null) {
            stat = (IntArrayStat)type.newStat();
            stat.appendValue(value);
            this.addStat(stat, false);
        } else {
            stat.appendValue(value);
            this.updateStat(stat, false);
        }
    }

    public <T> void addToSetStat(Stat.Type type, T value) {
        SetStat stat = (SetStat)this.getStat(type);
        if (stat == null) {
            SetStat nstat;
            stat = nstat = (SetStat)type.newStat();
            stat.add(value);
            this.addStat(stat, false);
        } else if (stat.add(value)) {
            this.updateStat(stat, false);
        }
    }

    public void incrementMapStat(Stat.Type type, String value, int amount) {
        StringMapStat stat = (StringMapStat)this.getStat(type);
        if (stat == null) {
            stat = (StringMapStat)type.newStat();
            stat.increment(value, amount);
            this.addStat(stat, false);
        } else if (stat.increment(value, amount)) {
            this.updateStat(stat, false);
        }
    }

    public int getIntStat(Stat.Type type) {
        IntStat stat = (IntStat)this.getStat(type);
        return stat == null ? 0 : stat.getValue();
    }

    public int getMaxIntStat(Stat.Type type) {
        MaxIntStat stat = (MaxIntStat)this.getStat(type);
        return stat == null ? 0 : stat.getMaxValue();
    }

    public int[] getIntArrayStat(Stat.Type type) {
        IntArrayStat stat = (IntArrayStat)this.getStat(type);
        return stat == null ? new int[]{} : stat.getValue();
    }

    public int getSetStatSize(Stat.Type type) {
        SetStat stat = (SetStat)this.getStat(type);
        return stat == null ? 0 : stat.size();
    }

    public <T> boolean containsValue(Stat.Type type, T value) {
        SetStat stat = (SetStat)this.getStat(type);
        return stat == null ? false : stat.contains(value);
    }

    public int getMapValue(Stat.Type type, String value) {
        StringMapStat stat = (StringMapStat)this.getStat(type);
        return stat == null ? 0 : stat.get(value);
    }

    public void addQuietly(Stat stat) {
        this.add(stat);
    }

    protected void addStat(Stat stat, boolean syncingWithRepo) {
        if (this._container != null) {
            this._container.addToStats(stat);
        } else {
            this.add(stat);
        }
    }

    protected void updateStat(Stat stat, boolean syncingWithRepo) {
        if (this._container != null) {
            this._container.updateStats(stat);
        }
    }

    protected Stat getStat(Stat.Type type) {
        return (Stat)this.get((Comparable)((Object)type.name()));
    }

    public static interface Container {
        public void addToStats(Stat var1);

        public void updateStats(Stat var1);
    }
}

