/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.util;

import com.google.common.collect.Lists;
import com.samskivert.util.SortableArrayList;
import com.threerings.media.tile.BaseSizableTileSet;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileUtil;
import com.threerings.media.tile.TrimmedObjectTileSet;
import com.threerings.media.util.AStarPathUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.MisoConfig;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.tile.BaseTileSet;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import com.threerings.miso.util.ObjectSet;
import com.threerings.stage.Log;
import com.threerings.stage.data.StageLocation;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.data.StageSceneModel;
import com.threerings.util.DirectionUtil;
import com.threerings.whirled.spot.data.Cluster;
import com.threerings.whirled.spot.data.SceneLocation;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class StageSceneUtil {
    public static final int OBJECT_ORIENTATION = -1;
    protected static MisoSceneMetrics _metrics = MisoConfig.getSceneMetrics();
    protected static final double[] CLUSTER_METRICS = new double[]{0.7853981633974483, 1.5707963267948966, 0.7853981633974483, 1.5707963267948966, 0.0, 0.7853981633974483, 0.2617993877991494, 0.5235987755982988, 0.0, 0.39269908169872414, 0.1308996938995747, 0.2617993877991494};
    protected static final int MAX_OBJECT_SIZE = 15;

    public static MisoSceneMetrics getMetrics() {
        return _metrics;
    }

    public static StageLocation locationForObject(TileManager tilemgr, ObjectInfo info) {
        return StageSceneUtil.locationForObject(tilemgr, info, -1);
    }

    public static StageLocation locationForObject(TileManager tilemgr, ObjectInfo info, int orient) {
        return StageSceneUtil.locationForObject(tilemgr, info.tileId, info.x, info.y, orient);
    }

    public static StageLocation locationForObject(TileManager tilemgr, int tileId, int tx, int ty) {
        return StageSceneUtil.locationForObject(tilemgr, tileId, tx, ty, -1);
    }

    public static StageLocation locationForObject(TileManager tilemgr, int tileId, int tx, int ty, int orient) {
        TrimmedObjectTileSet tset;
        int tidx;
        block4: {
            try {
                int tsid = TileUtil.getTileSetId((int)tileId);
                tidx = TileUtil.getTileIndex((int)tileId);
                tset = (TrimmedObjectTileSet)tilemgr.getTileSet(tsid);
                if (tset != null && (orient != -1 || tset.getSpotOrient(tidx) >= 0)) break block4;
                return null;
            }
            catch (Exception e) {
                Log.log.warning((Object)"Unable to look up object tile for scene object", new Object[]{"tileId", tileId, e});
                return null;
            }
        }
        if (orient == -1) {
            orient = tset.getSpotOrient(tidx);
        }
        Point opos = MisoUtil.tilePlusFineToFull((MisoSceneMetrics)_metrics, (int)tx, (int)ty, (int)tset.getXSpot(tidx), (int)tset.getYSpot(tidx), (Point)new Point());
        return new StageLocation(opos.x, opos.y, (byte)orient);
    }

    public static void locationToCoords(int lx, int ly, Point coords) {
        int tx = MisoUtil.fullToTile((int)lx);
        int fx = MisoUtil.fullToFine((int)lx);
        int ty = MisoUtil.fullToTile((int)ly);
        int fy = MisoUtil.fullToFine((int)ly);
        coords.x = tx * StageSceneUtil._metrics.finegran + fx;
        coords.y = ty * StageSceneUtil._metrics.finegran + fy;
    }

    public static void coordsToLocation(int cx, int cy, Point loc) {
        loc.x = MisoUtil.toFull((int)(cx / StageSceneUtil._metrics.finegran), (int)(cx % StageSceneUtil._metrics.finegran));
        loc.y = MisoUtil.toFull((int)(cy / StageSceneUtil._metrics.finegran), (int)(cy % StageSceneUtil._metrics.finegran));
    }

    public static Rectangle getObjectFootprint(TileManager tilemgr, int tileId, int ox, int oy) {
        Rectangle foot = new Rectangle();
        StageSceneUtil.getObjectFootprint(tilemgr, tileId, ox, oy, foot);
        return foot;
    }

    public static boolean getObjectFootprint(TileManager tilemgr, int tileId, int ox, int oy, Rectangle foot) {
        BaseSizableTileSet tset;
        int tidx;
        block3: {
            try {
                int tsid = TileUtil.getTileSetId((int)tileId);
                tidx = TileUtil.getTileIndex((int)tileId);
                tset = (BaseSizableTileSet)tilemgr.getTileSet(tsid);
                if (tset != null) break block3;
                return false;
            }
            catch (Exception e) {
                Log.log.warning((Object)"Unable to look up object tile for scene object", new Object[]{"tileId", tileId, e});
                return false;
            }
        }
        int bwidth = tset.getBaseWidth(tidx);
        int bheight = tset.getBaseHeight(tidx);
        foot.setBounds(ox - bwidth + 1, oy - bheight + 1, bwidth, bheight);
        return true;
    }

    public static boolean isPassable(TileManager tilemgr, int tileId) {
        if (tileId <= 0) {
            return false;
        }
        try {
            int tsid = TileUtil.getTileSetId((int)tileId);
            int tidx = TileUtil.getTileIndex((int)tileId);
            BaseTileSet tset = (BaseTileSet)tilemgr.getTileSet(tsid);
            return tset.getPassability()[tidx];
        }
        catch (Exception e) {
            Log.log.warning((Object)"Unable to look up base tile", new Object[]{"tileId", tileId, e});
            return true;
        }
    }

    public static List<SceneLocation> getClusterLocs(Cluster cluster) {
        ArrayList list = Lists.newArrayList();
        int fx = cluster.x * StageSceneUtil._metrics.finegran + 1;
        int fy = cluster.y * StageSceneUtil._metrics.finegran + 1;
        int fwid = cluster.width * StageSceneUtil._metrics.finegran - 2;
        int fhei = cluster.height * StageSceneUtil._metrics.finegran - 2;
        int cx = fx + fwid / 2;
        int cy = fy + fhei / 2;
        if (cluster.width == 1) {
            StageLocation loc = new StageLocation(MisoUtil.toFull((int)cluster.x, (int)2), MisoUtil.toFull((int)cluster.y, (int)2), 0);
            list.add(new SceneLocation(loc, 0));
            return list;
        }
        double radius = (double)fwid / 2.0;
        int clidx = cluster.width - 2;
        if (clidx >= CLUSTER_METRICS.length / 2 || clidx < 0) {
            Log.log.warning((Object)("Requested locs from invalid cluster " + cluster + "."), new Object[]{new Exception()});
            return list;
        }
        double angle = CLUSTER_METRICS[clidx * 2];
        while (angle < Math.PI * 2) {
            int sx = cx + (int)Math.round(Math.cos(angle) * radius);
            int sy = cy + (int)Math.round(Math.sin(angle) * radius);
            int orient = 2 * (int)(Math.round(angle / 0.7853981633974483) % 8L);
            orient = DirectionUtil.rotateCW((int)7, (int)orient);
            orient = DirectionUtil.getOpposite((int)orient);
            int tx = MathUtil.floorDiv((int)sx, (int)StageSceneUtil._metrics.finegran);
            sx = MisoUtil.toFull((int)tx, (int)(sx - tx * StageSceneUtil._metrics.finegran));
            int ty = MathUtil.floorDiv((int)sy, (int)StageSceneUtil._metrics.finegran);
            sy = MisoUtil.toFull((int)ty, (int)(sy - ty * StageSceneUtil._metrics.finegran));
            StageLocation loc = new StageLocation(sx, sy, (byte)orient);
            list.add(new SceneLocation(loc, 0));
            angle += CLUSTER_METRICS[clidx * 2 + 1];
        }
        return list;
    }

    public static StageLocation findStandingSpot(Rectangle foot, int dist, AStarPathUtil.TraversalPred pred, Object traverser, final Point nearto, int orient) {
        SortableArrayList spots = new SortableArrayList();
        int dd = 1;
        while (dd <= dist) {
            int yy1 = foot.y - dd;
            int yy2 = foot.y + foot.height + dd - 1;
            int xx1 = foot.x - dd;
            int xx2 = foot.x + foot.width + dd - 1;
            spots.add((Object)new StageLocation(xx1, yy1, 0));
            spots.add((Object)new StageLocation(xx1, yy2, 6));
            spots.add((Object)new StageLocation(xx2, yy1, 2));
            spots.add((Object)new StageLocation(xx2, yy2, 4));
            int xx = xx1 + 1;
            while (xx < xx2) {
                spots.add((Object)new StageLocation(xx, yy1, 1));
                spots.add((Object)new StageLocation(xx, yy2, 5));
                ++xx;
            }
            int yy = yy1 + 1;
            while (yy < yy2) {
                spots.add((Object)new StageLocation(xx1, yy, 7));
                spots.add((Object)new StageLocation(xx2, yy, 3));
                ++yy;
            }
            spots.sort((Comparator)new Comparator<StageLocation>(){

                @Override
                public int compare(StageLocation o1, StageLocation o2) {
                    return this.dist(o1) - this.dist(o2);
                }

                private final int dist(StageLocation l) {
                    return Math.round(100.0f * MathUtil.distance((int)l.x, (int)l.y, (int)nearto.x, (int)nearto.y));
                }
            });
            int ii = 0;
            int ll = spots.size();
            while (ii < ll) {
                StageLocation loc = (StageLocation)spots.get(ii);
                if (pred.canTraverse(traverser, loc.x, loc.y)) {
                    loc.x = MisoUtil.toFull((int)loc.x, (int)2);
                    loc.y = MisoUtil.toFull((int)loc.y, (int)2);
                    if (-1 != orient) {
                        loc.orient = (byte)orient;
                    }
                    return loc;
                }
                ++ii;
            }
            spots.clear();
            ++dd;
        }
        return null;
    }

    public static ObjectInfo[] getIntersectedObjects(TileManager tmgr, StageSceneModel model, Rectangle rect) {
        ObjectSet objs = new ObjectSet();
        Rectangle orect = new Rectangle(rect);
        orect.grow(15, 15);
        StageMisoSceneModel mmodel = StageMisoSceneModel.getSceneModel(model);
        mmodel.getObjects(orect, objs);
        Rectangle foot = new Rectangle();
        int ii = 0;
        while (ii < objs.size()) {
            ObjectInfo info = objs.get(ii);
            if (StageSceneUtil.getObjectFootprint(tmgr, info.tileId, info.x, info.y, foot)) {
                if (!foot.intersects(rect)) {
                    objs.remove(ii--);
                }
            } else {
                Log.log.warning((Object)("Unknown potentially intersecting object?! [scene=" + model.name + " (" + model.sceneId + "), info=" + info + "]."), new Object[0]);
            }
            ++ii;
        }
        return objs.toArray();
    }
}

