/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.ListUtil;
import com.threerings.media.tile.ObjectTile;
import com.threerings.media.tile.TileManager;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.data.SparseMisoSceneModel;
import com.threerings.stage.Log;
import com.threerings.stage.data.StageCodes;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.data.StageScene;
import com.threerings.util.DirectionCodes;
import com.threerings.util.DirectionUtil;
import com.threerings.util.MessageBundle;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PlacementConstraints
implements DirectionCodes,
StageCodes {
    protected TileManager _tilemgr;
    protected StageScene _scene;
    protected StageMisoSceneModel _mmodel;
    protected HashMap<ObjectInfo, ObjectData> _objectData = Maps.newHashMap();
    protected static final Rectangle _constrainRect = new Rectangle();

    public PlacementConstraints(TileManager tilemgr, StageScene scene) {
        this._tilemgr = tilemgr;
        this._scene = scene;
        this._mmodel = StageMisoSceneModel.getSceneModel(scene.getSceneModel());
        SparseMisoSceneModel.ObjectVisitor visitor = new SparseMisoSceneModel.ObjectVisitor(){

            public void visit(ObjectInfo info) {
                ObjectData data = PlacementConstraints.this.createObjectData(info);
                if (data != null) {
                    PlacementConstraints.this._objectData.put(info.clone(), data);
                }
            }
        };
        this._mmodel.visitObjects(visitor);
    }

    public String allowAddObject(ObjectInfo info) {
        return this.allowModifyObjects(new ObjectInfo[]{info}, new ObjectInfo[0]);
    }

    public void addObject(ObjectInfo info) {
        ObjectData data = this.createObjectData(info);
        if (data != null) {
            this._scene.addObject(info);
            this._objectData.put(info, data);
        }
    }

    public String allowRemoveObject(ObjectInfo info) {
        return this.allowModifyObjects(new ObjectInfo[0], new ObjectInfo[]{info});
    }

    public void removeObject(ObjectInfo info) {
        this._scene.removeObject(info);
        this._objectData.remove(info);
    }

    public String allowModifyObjects(ObjectInfo[] added, ObjectInfo[] removed) {
        ObjectData[] addedData = new ObjectData[added.length];
        int ii = 0;
        while (ii < added.length) {
            addedData[ii] = this.createObjectData(added[ii]);
            if (addedData[ii] == null) {
                return "m.internal_error";
            }
            ++ii;
        }
        ObjectData[] removedData = this.getObjectDataFromInfo(removed);
        if (removedData == null) {
            return "m.internal_error";
        }
        return this.allowModifyObjects(addedData, removedData);
    }

    protected ObjectData[] getObjectDataFromInfo(ObjectInfo[] info) {
        if (info == null) {
            return null;
        }
        ObjectData[] data = new ObjectData[info.length];
        int ii = 0;
        while (ii < info.length) {
            data[ii] = this._objectData.get(info[ii]);
            if (data[ii] == null) {
                Log.log.warning((Object)("Couldn't match object info up to data [info=" + info[ii] + "]."), new Object[0]);
                return null;
            }
            ++ii;
        }
        return data;
    }

    protected String allowModifyObjects(ObjectData[] added, ObjectData[] removed) {
        DirectionType dirtype = new DirectionType();
        int ii = 0;
        while (ii < added.length) {
            if (added[ii].tile.hasConstraint("ON_SURFACE") && !this.isOnSurface(added[ii], added, removed)) {
                return MessageBundle.qualify((String)"stage.general", (String)"m.not_on_surface");
            }
            if (this.getConstraintDirectionType(added[ii], "ON_WALL_", dirtype) && !this.isOnWall(added[ii], added, removed, dirtype.dir, dirtype.type)) {
                return MessageBundle.qualify((String)"stage.general", (String)"m.not_on_wall");
            }
            if (this.getConstraintDirectionType(added[ii], "ATTACH_", dirtype) && !this.isAttached(added[ii], added, removed, dirtype.dir, dirtype.type)) {
                return MessageBundle.qualify((String)"stage.general", (String)"m.not_attached");
            }
            int dir = this.getConstraintDirection(added[ii], "SPACE_");
            if (dir != -1 && !this.hasSpace(added[ii], added, removed, dir)) {
                return MessageBundle.qualify((String)"stage.general", (String)"m.no_space");
            }
            if (this.hasSpaceConstrainedAdjacent(added[ii], added, removed)) {
                return MessageBundle.qualify((String)"stage.general", (String)"m.no_space_adj");
            }
            ++ii;
        }
        ObjectData[] objectDataArray = removed;
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectData element = objectDataArray[n2];
            if (element.tile.hasConstraint("SURFACE") && this.hasOnSurface(element, added, removed)) {
                return MessageBundle.qualify((String)"stage.general", (String)"m.has_on_surface");
            }
            int dir = this.getConstraintDirection(element, "WALL_");
            if (dir != -1) {
                if (this.hasOnWall(element, added, removed, dir)) {
                    return MessageBundle.qualify((String)"stage.general", (String)"m.has_on_wall");
                }
                if (this.hasAttached(element, added, removed, dir)) {
                    return MessageBundle.qualify((String)"stage.general", (String)"m.has_attached");
                }
            }
            ++n2;
        }
        return null;
    }

    protected boolean hasOnSurface(ObjectData data, ObjectData[] added, ObjectData[] removed) {
        List<ObjectData> objects = this.getObjectData(data.bounds, added, removed);
        int ii = 0;
        int size = objects.size();
        while (ii < size) {
            ObjectData odata = objects.get(ii);
            if (odata.tile.hasConstraint("ON_SURFACE") && !this.isOnSurface(odata, added, removed)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    protected boolean hasOnWall(ObjectData data, ObjectData[] added, ObjectData[] removed, int dir) {
        DirectionType dirtype = new DirectionType();
        List<ObjectData> objects = this.getObjectData(data.bounds, added, removed);
        int ii = 0;
        int size = objects.size();
        while (ii < size) {
            ObjectData odata = objects.get(ii);
            if (this.getConstraintDirectionType(odata, "ON_WALL_", dirtype) && !this.isAttached(odata, added, removed, dirtype.dir, dirtype.type)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    protected boolean hasAttached(ObjectData data, ObjectData[] added, ObjectData[] removed, int dir) {
        DirectionType dirtype = new DirectionType();
        List<ObjectData> objects = this.getObjectData(this.getAdjacentEdge(data.bounds, DirectionUtil.getOpposite((int)dir)), added, removed);
        int ii = 0;
        int size = objects.size();
        while (ii < size) {
            ObjectData odata = objects.get(ii);
            if (this.getConstraintDirectionType(odata, "ATTACH_", dirtype) && !this.isAttached(odata, added, removed, dirtype.dir, dirtype.type)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    protected boolean hasSpaceConstrainedAdjacent(ObjectData data, ObjectData[] added, ObjectData[] removed) {
        Rectangle r = data.bounds;
        _constrainRect.setBounds(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        List<ObjectData> objects = this.getObjectData(_constrainRect, added, removed);
        int ii = 0;
        int size = objects.size();
        while (ii < size) {
            ObjectData odata = objects.get(ii);
            int dir = this.getConstraintDirection(odata, "SPACE_");
            if (dir != -1 && !this.hasSpace(odata, added, removed, dir)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    protected boolean hasSpace(ObjectData data, ObjectData[] added, ObjectData[] removed, int dir) {
        return this.getObjectData(this.getAdjacentEdge(data.bounds, dir), added, removed).size() == 0;
    }

    protected boolean isOnSurface(ObjectData data, ObjectData[] added, ObjectData[] removed) {
        return this.isCovered(data.bounds, added, removed, "SURFACE", null);
    }

    protected boolean isOnWall(ObjectData data, ObjectData[] added, ObjectData[] removed, int dir, int type) {
        return this.isCovered(data.bounds, added, removed, this.getDirectionalConstraint("WALL_", dir), type == DirectionType.LOW ? this.getDirectionalConstraint("WALL_", dir, DirectionType.LOW) : null);
    }

    protected boolean isAttached(ObjectData data, ObjectData[] added, ObjectData[] removed, int dir, int type) {
        return this.isCovered(this.getAdjacentEdge(data.bounds, dir), added, removed, this.getDirectionalConstraint("WALL_", dir), type == DirectionType.LOW ? this.getDirectionalConstraint("WALL_", dir, DirectionType.LOW) : null);
    }

    protected boolean isCovered(Rectangle rect, ObjectData[] added, ObjectData[] removed, String constraint, String altstraint) {
        List<ObjectData> objects = this.getObjectData(rect, added, removed);
        int y = rect.y;
        int ymax = rect.y + rect.height;
        while (y < ymax) {
            int x = rect.x;
            int xmax = rect.x + rect.width;
            while (x < xmax) {
                boolean covered = false;
                int ii = 0;
                int size = objects.size();
                while (ii < size) {
                    ObjectData data = objects.get(ii);
                    if (data.bounds.contains(x, y) && (constraint == null || data.tile.hasConstraint(constraint) || altstraint != null && data.tile.hasConstraint(altstraint))) {
                        covered = true;
                        break;
                    }
                    ++ii;
                }
                if (!covered) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    protected Rectangle getAdjacentEdge(Rectangle rect, int dir) {
        switch (dir) {
            case 3: {
                return new Rectangle(rect.x - 1, rect.y, 1, rect.height);
            }
            case 5: {
                return new Rectangle(rect.x, rect.y - 1, rect.width, 1);
            }
            case 7: {
                return new Rectangle(rect.x + rect.width, rect.y, 1, rect.height);
            }
            case 1: {
                return new Rectangle(rect.x, rect.y + rect.height, rect.width, 1);
            }
        }
        return null;
    }

    protected int getConstraintDirection(ObjectData data, String prefix) {
        DirectionType dirtype = new DirectionType();
        return this.getConstraintDirectionType(data, prefix, dirtype) ? dirtype.dir : -1;
    }

    protected boolean getConstraintDirectionType(ObjectData data, String prefix, DirectionType dirtype) {
        String[] constraints = data.tile.getConstraints();
        if (constraints == null) {
            return false;
        }
        String[] stringArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            String constraint = stringArray[n2];
            if (constraint.startsWith(prefix)) {
                int fromidx = prefix.length();
                int toidx = constraint.indexOf(95, fromidx);
                dirtype.dir = DirectionUtil.fromShortString((String)(toidx == -1 ? constraint.substring(fromidx) : constraint.substring(fromidx, toidx)));
                dirtype.type = this.getConstraintWallType(constraint);
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected int getConstraintWallType(String constraint) {
        return constraint.endsWith("_LOW") ? DirectionType.LOW : DirectionType.NORM;
    }

    protected String getDirectionalConstraint(String prefix, int dir) {
        return this.getDirectionalConstraint(prefix, dir, DirectionType.NORM);
    }

    protected String getDirectionalConstraint(String prefix, int dir, int type) {
        return String.valueOf(prefix) + DirectionUtil.toShortString((int)dir) + (type == DirectionType.LOW ? "_LOW" : "");
    }

    protected List<ObjectData> getObjectData(Rectangle rect, ObjectData[] added, ObjectData[] removed) {
        ArrayList list = Lists.newArrayList();
        for (ObjectData data : this._objectData.values()) {
            if (!rect.intersects(data.bounds) || ListUtil.contains((Object[])removed, (Object)data)) continue;
            list.add(data);
        }
        ObjectData[] objectDataArray = added;
        int n = added.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectData element = objectDataArray[n2];
            if (rect.intersects(element.bounds)) {
                list.add(element);
            }
            ++n2;
        }
        return list;
    }

    protected ObjectData createObjectData(ObjectInfo info) {
        try {
            ObjectTile tile = (ObjectTile)this._tilemgr.getTile(info.tileId);
            Rectangle bounds = new Rectangle(info.x, info.y, tile.getBaseWidth(), tile.getBaseHeight());
            bounds.translate(1 - bounds.width, 1 - bounds.height);
            return new ObjectData(bounds, tile);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Error retrieving tile for object [info=" + info + "]."), new Object[]{e});
            return null;
        }
    }

    protected static class DirectionType {
        public int dir;
        public int type;
        public static int NORM = 0;
        public static int LOW = 1;

        protected DirectionType() {
        }
    }

    protected class ObjectData {
        public Rectangle bounds;
        public ObjectTile tile;

        public ObjectData(Rectangle bounds, ObjectTile tile) {
            this.bounds = bounds;
            this.tile = tile;
        }
    }
}

