/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.viewer;

import com.samskivert.swing.util.MenuUtil;
import com.threerings.cast.CharacterManager;
import com.threerings.media.ManagedJFrame;
import com.threerings.stage.Log;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.data.StageSceneModel;
import com.threerings.stage.tools.viewer.ViewerScenePanel;
import com.threerings.stage.tools.xml.StageSceneParser;
import com.threerings.stage.util.StageContext;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotSceneModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ViewerFrame
extends ManagedJFrame {
    protected ViewerScenePanel _panel;

    public ViewerFrame(GraphicsConfiguration gc) {
        super(gc);
        this.setTitle("Scene Viewer");
        this.setDefaultCloseOperation(3);
        this.setBackground(Color.black);
        this.getContentPane().setBackground(Color.black);
        KeyStroke accel = null;
        JMenu menuSettings = new JMenu("File");
        accel = KeyStroke.getKeyStroke(79, 2);
        MenuUtil.addMenuItem((JMenu)menuSettings, (String)"Open scene...", (int)79, (KeyStroke)accel, (Object)((Object)this), (String)"openScene");
        MenuUtil.addMenuItem((JMenu)menuSettings, (String)"Decoys!", (Object)((Object)this), (String)"getJiggy");
        menuSettings.addSeparator();
        accel = KeyStroke.getKeyStroke(81, 2);
        MenuUtil.addMenuItem((JMenu)menuSettings, (String)"Quit", (int)81, (KeyStroke)accel, (Object)((Object)this), (String)"handleQuit");
        JMenuBar bar = new JMenuBar();
        bar.add(menuSettings);
        this.setJMenuBar(bar);
    }

    public void init(StageContext ctx, CharacterManager charmgr) {
        this._panel = new ViewerScenePanel(ctx, charmgr);
        this.getContentPane().add((Component)((Object)this._panel), "Center");
    }

    public void openScene(ActionEvent event) {
        String where = System.getProperty("user.dir");
        JFileChooser chooser = new JFileChooser(where);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML Files";
            }
        });
        int result = chooser.showOpenDialog((Component)((Object)this));
        if (result == 0) {
            File filescene = chooser.getSelectedFile();
            this.loadScene(filescene.getPath());
        }
    }

    public void getJiggy(ActionEvent event) {
        this._panel.createDecoys();
    }

    public void handleQuit(ActionEvent evt) {
        System.exit(0);
    }

    public void loadScene(String path) {
        String errmsg = null;
        try {
            StageSceneParser parser = new StageSceneParser();
            StageSceneModel model = (StageSceneModel)parser.parseScene(path);
            if (model == null) {
                errmsg = "No scene found in scene file '" + path + "'.";
            } else {
                SpotSceneModel ssmodel = SpotSceneModel.getSceneModel(model);
                Location defloc = null;
                Portal[] portalArray = ssmodel.portals;
                int n = ssmodel.portals.length;
                int n2 = 0;
                while (n2 < n) {
                    Portal port = portalArray[n2];
                    if (port.portalId == ssmodel.defaultEntranceId) {
                        defloc = port.getOppLocation();
                        break;
                    }
                    ++n2;
                }
                if (defloc == null) {
                    Log.log.warning((Object)("Scene has no def. entrance '" + path + "'."), new Object[0]);
                }
                this._panel.setScene(new StageScene(model, null), defloc);
            }
        }
        catch (Exception e) {
            errmsg = "Error parsing scene file '" + path + "'.";
            Log.log.warning((Object)e, new Object[0]);
        }
        if (errmsg != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), errmsg, "Load error", 0);
        }
    }
}

