/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.threerings.media.tile.ImageProvider;
import com.threerings.media.tile.SimpleCachingImageProvider;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileSetIDBroker;
import com.threerings.media.tile.tools.xml.ObjectTileSetRuleSet;
import com.threerings.media.tile.tools.xml.TileSetRuleSet;
import com.threerings.media.tile.tools.xml.XMLTileSetParser;
import com.threerings.miso.tile.tools.xml.BaseTileSetRuleSet;
import com.threerings.stage.Log;
import com.threerings.stage.tools.editor.EditorConfig;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class TestTileLoader
implements TileSetIDBroker {
    protected int _fakeID = Short.MAX_VALUE;
    protected Map<String, Integer> _idmap = Maps.newHashMap();
    protected XMLTileSetParser _parser;
    protected ImageProvider _improv = new SimpleCachingImageProvider(){

        protected BufferedImage loadImage(String path) throws IOException {
            return ImageIO.read(new File(path));
        }
    };

    public TestTileLoader() {
        this._parser = new XMLTileSetParser();
        this._parser.addRuleSet("bundle/base", (TileSetRuleSet)new BaseTileSetRuleSet());
        this._parser.addRuleSet("bundle/object", (TileSetRuleSet)new ObjectTileSetRuleSet());
    }

    public HashIntMap<TileSet> loadTestTiles() {
        String directory = EditorConfig.getTestTileDirectory();
        HashIntMap map = new HashIntMap();
        File testdir = new File(directory);
        if (!testdir.isDirectory()) {
            Log.log.warning((Object)("Test tileset directory is not actually a directory: " + directory), new Object[0]);
            return map;
        }
        this.loadTestTilesFromDir(testdir, (HashIntMap<TileSet>)map);
        return map;
    }

    protected void loadTestTilesFromDir(File directory, HashIntMap<TileSet> sets) {
        String[] xml;
        File[] subdirs;
        File[] fileArray = subdirs = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        int n = subdirs.length;
        int n2 = 0;
        while (n2 < n) {
            File subdir = fileArray[n2];
            this.loadTestTilesFromDir(subdir, sets);
            ++n2;
        }
        String[] stringArray = xml = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        int n3 = xml.length;
        n = 0;
        while (n < n3) {
            block5: {
                String element = stringArray[n];
                File xmlfile = new File(directory, element);
                HashMap tiles = Maps.newHashMap();
                try {
                    this._parser.loadTileSets(xmlfile, (Map)tiles);
                }
                catch (IOException ioe) {
                    Log.log.warning((Object)("Error while parsing " + xmlfile.getPath()), new Object[]{ioe});
                    break block5;
                }
                for (TileSet ts : tiles.values()) {
                    String path = new File(directory, ts.getImagePath()).getPath();
                    if (this._improv.getTileSetImage(path, null) == null) continue;
                    ts.setImageProvider(this._improv);
                    ts.setImagePath(path);
                    sets.put(this.getTileSetID(path), (Object)ts);
                }
            }
            ++n;
        }
    }

    public int getTileSetID(String tileSetPath) {
        Integer id = this._idmap.get(tileSetPath);
        if (id == null) {
            id = this._fakeID--;
            this._idmap.put(tileSetPath, id);
        }
        return id;
    }

    public boolean tileSetMapped(String tilesetPath) {
        return this._idmap.containsKey(tilesetPath);
    }

    public void commit() {
    }
}

