/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.stage.Log;
import com.threerings.stage.tools.editor.EditorConfig;
import com.threerings.stage.tools.editor.util.EditorDialogUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PreferencesDialog
extends JInternalFrame
implements ActionListener {
    public PreferencesDialog() {
        super("Editor Preferences", true);
        JPanel top = (JPanel)this.getContentPane();
        VGroupLayout gl = new VGroupLayout(GroupLayout.STRETCH);
        gl.setOffAxisPolicy(GroupLayout.STRETCH);
        top.setLayout((LayoutManager)gl);
        top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel sub = new JPanel((LayoutManager)new HGroupLayout(GroupLayout.STRETCH));
        sub.add((Component)new JLabel("Directory to search for test tiles:"), GroupLayout.FIXED);
        EditorDialogUtil.addButton(this, sub, EditorConfig.getTestTileDirectory(), "testtiledir");
        top.add(sub);
        sub = new JPanel((LayoutManager)new HGroupLayout());
        EditorDialogUtil.addButton(this, sub, "OK", "ok");
        top.add(sub);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("testtiledir")) {
            this.changeTestTileDir((JButton)e.getSource());
        } else if (cmd.equals("ok")) {
            EditorDialogUtil.dispose(this);
        } else {
            Log.log.warning((Object)("Unknown action command [cmd=" + cmd + "]."), new Object[0]);
        }
    }

    protected void changeTestTileDir(JButton button) {
        File f = new File(button.getText());
        JFileChooser chooser = !f.exists() ? new JFileChooser() : new JFileChooser(f);
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(f);
        int result = chooser.showDialog(this, "Select");
        if (result == 0) {
            f = chooser.getSelectedFile();
            String newdir = f.getPath();
            button.setText(newdir);
            EditorConfig.setTestTileDirectory(newdir);
        }
    }
}

