/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.util.MenuUtil;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.media.ManagedJFrame;
import com.threerings.media.tile.TileManager;
import com.threerings.miso.tile.BaseTileSet;
import com.threerings.stage.Log;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.data.StageSceneModel;
import com.threerings.stage.tools.editor.EditorConfig;
import com.threerings.stage.tools.editor.EditorModel;
import com.threerings.stage.tools.editor.EditorScenePanel;
import com.threerings.stage.tools.editor.EditorScrollBox;
import com.threerings.stage.tools.editor.EditorToolBarPanel;
import com.threerings.stage.tools.editor.PreferencesDialog;
import com.threerings.stage.tools.editor.SceneInfoPanel;
import com.threerings.stage.tools.editor.TestTileLoader;
import com.threerings.stage.tools.editor.TileInfoPanel;
import com.threerings.stage.tools.editor.util.EditorContext;
import com.threerings.stage.tools.editor.util.EditorDialogUtil;
import com.threerings.stage.tools.xml.StageSceneParser;
import com.threerings.stage.tools.xml.StageSceneWriter;
import com.threerings.whirled.data.AuxModel;
import com.threerings.whirled.tools.xml.SceneParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.SAXException;

public class EditorFrame
extends ManagedJFrame
implements EditorScenePanel.SceneModelListener {
    protected ActionListener _openListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            String cmd = event.getActionCommand();
            EditorFrame.this._main.remove(EditorFrame.this._chooser);
            EditorFrame.this._main.add((Component)((Object)EditorFrame.this._svpanel));
            SwingUtil.refresh((JComponent)EditorFrame.this._main);
            if (cmd.equals("ApproveSelection")) {
                File filescene = EditorFrame.this._chooser.getSelectedFile();
                switch (EditorFrame.this._chooser.getDialogType()) {
                    case 0: {
                        EditorFrame.this.openScene(filescene.getPath());
                        EditorConfig.config.setValue("editor.last_dir", filescene.getParent());
                        EditorConfig.config.setValue("editor.last_file", filescene.getAbsolutePath());
                        break;
                    }
                    case 1: {
                        EditorFrame.this.setFilePath(filescene.getPath());
                        EditorFrame.this.handleSave(null);
                        break;
                    }
                    default: {
                        Log.log.warning((Object)("Wha? Weird dialog type " + EditorFrame.this._chooser.getDialogType() + "."), new Object[0]);
                    }
                }
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    (this).EditorFrame.this._sceneInfoPanel.requestFocusInWindow();
                }
            });
        }
    };
    protected StageScene _scene;
    protected String _filepath;
    protected JPanel _main;
    protected JInternalFrame _dialog;
    protected JFileChooser _chooser;
    protected EditorScenePanel _svpanel;
    protected TileInfoPanel _tpanel;
    protected SceneInfoPanel _sceneInfoPanel;
    protected EditorScrollBox _scrollBox;
    protected EditorModel _model;
    protected EditorContext _ctx;
    protected SceneParser _parser = new StageSceneParser();
    protected StageSceneWriter _writer;
    protected TestTileLoader _testLoader;

    public EditorFrame(StageSceneWriter writer) {
        this._writer = writer;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditorFrame.this.handleQuit(null);
            }
        });
        this.setFilePath(null);
    }

    public void init(EditorContext ctx, String target) {
        this._ctx = ctx;
        this._model = new EditorModel((TileManager)this._ctx.getTileManager());
        if (target == null) {
            target = EditorConfig.config.getValue("editor.last_dir", System.getProperty("user.dir"));
        }
        this._chooser = target == null ? new JFileChooser() : new JFileChooser(target);
        this._chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML Files";
            }
        });
        this._chooser.addActionListener(this._openListener);
        this.createMenuBar();
        JPanel top = new JPanel(new BorderLayout());
        this._main = new JPanel(new BorderLayout());
        this._svpanel = this.createScenePanel();
        this._main.add((Component)((Object)this._svpanel), "Center");
        JPanel upper = new JPanel((LayoutManager)new HGroupLayout(GroupLayout.NONE, GroupLayout.LEFT));
        upper.add((Component)new EditorToolBarPanel((TileManager)this._ctx.getTileManager(), this._model), GroupLayout.FIXED);
        this._sceneInfoPanel = new SceneInfoPanel(this._ctx, this._model, this._svpanel);
        upper.add((Component)this._sceneInfoPanel, GroupLayout.FIXED);
        this._main.add((Component)upper, "North");
        JScrollBar horiz = new JScrollBar(0);
        horiz.setBlockIncrement(500);
        horiz.setModel(this._svpanel.getHorizModel());
        this._main.add((Component)horiz, "South");
        JScrollBar vert = new JScrollBar(1);
        vert.setBlockIncrement(500);
        vert.setModel(this._svpanel.getVertModel());
        this._main.add((Component)vert, "East");
        top.add((Component)this._main, "Center");
        JPanel west = GroupLayout.makeVStretchBox((int)5);
        this._tpanel = new TileInfoPanel(this._ctx, this._model);
        west.add(this._tpanel);
        JPanel boxPane = GroupLayout.makeHBox();
        this._scrollBox = new EditorScrollBox(this._svpanel);
        boxPane.add((Component)((Object)this._scrollBox));
        west.add((Component)boxPane, GroupLayout.FIXED);
        top.add((Component)west, "West");
        this.getContentPane().add((Component)top, "Center");
        this._svpanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    EditorFrame.this._tpanel.selectPreviousTile();
                } else {
                    EditorFrame.this._tpanel.selectNextTile();
                }
            }
        });
        String lastFile = EditorConfig.config.getValue("editor.last_file", "");
        boolean loaded = false;
        if (!lastFile.equals("")) {
            try {
                loaded = this.loadScene(lastFile);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Unable to load last scene, creating new one", new Object[]{"file", lastFile, e});
            }
        }
        if (!loaded) {
            this.newScene();
        }
    }

    protected EditorScenePanel createScenePanel() {
        return new EditorScenePanel(this._ctx, (JFrame)((Object)this), this._model, this);
    }

    public void createMenuBar() {
        JMenu menuFile = new JMenu("File");
        this.createFileMenu(menuFile);
        JMenu menuActions = new JMenu("Actions");
        this.createActionsMenu(menuActions);
        KeyStroke accel = null;
        JMenu menuSettings = new JMenu("Settings");
        menuSettings.setMnemonic(83);
        accel = KeyStroke.getKeyStroke(59, 2);
        MenuUtil.addMenuItem((JMenu)menuSettings, (String)"Preferences...", (int)80, (KeyStroke)accel, (Object)this, (String)"handlePreferences");
        JMenuBar bar = new JMenuBar();
        bar.add(menuFile);
        bar.add(menuActions);
        bar.add(menuSettings);
        this.setJMenuBar(bar);
    }

    protected void createFileMenu(JMenu menuFile) {
        KeyStroke accel = null;
        menuFile.setMnemonic(70);
        accel = KeyStroke.getKeyStroke(78, 2);
        MenuUtil.addMenuItem((JMenu)menuFile, (String)"New", (int)78, (KeyStroke)accel, (Object)this, (String)"handleNew");
        accel = KeyStroke.getKeyStroke(79, 2);
        MenuUtil.addMenuItem((JMenu)menuFile, (String)"Open", (int)79, (KeyStroke)accel, (Object)this, (String)"handleOpen");
        accel = KeyStroke.getKeyStroke(83, 2);
        MenuUtil.addMenuItem((JMenu)menuFile, (String)"Save", (int)83, (KeyStroke)accel, (Object)this, (String)"handleSave");
        MenuUtil.addMenuItem((JMenu)menuFile, (String)"Save As", (int)65, null, (Object)this, (String)"handleSaveAs");
        accel = KeyStroke.getKeyStroke(81, 2);
        MenuUtil.addMenuItem((JMenu)menuFile, (String)"Quit", (int)81, (KeyStroke)accel, (Object)this, (String)"handleQuit");
    }

    protected void createActionsMenu(JMenu menuActions) {
        KeyStroke accel = null;
        MenuUtil.addMenuItem((JMenu)menuActions, (String)"Load (reload) test tiles", (Object)this, (String)"handleTestTiles");
        menuActions.setMnemonic(65);
        accel = KeyStroke.getKeyStroke(68, 2);
        MenuUtil.addMenuItem((JMenu)menuActions, (String)"Make default base tile", (int)77, (KeyStroke)accel, (Object)this, (String)"handleSetDefBase");
        accel = KeyStroke.getKeyStroke(77, 2);
        MenuUtil.addMenuItem((JMenu)menuActions, (String)"Update mini view", (int)77, (KeyStroke)accel, (Object)this, (String)"updateMiniView");
        accel = KeyStroke.getKeyStroke(90, 2);
        MenuUtil.addMenuItem((JMenu)menuActions, (String)"Undo", (int)90, (KeyStroke)accel, (Object)this, (String)"undo");
        accel = KeyStroke.getKeyStroke(89, 2);
        MenuUtil.addMenuItem((JMenu)menuActions, (String)"Redo", (int)89, (KeyStroke)accel, (Object)this, (String)"redo");
    }

    protected void setScene(StageScene scene) {
        this._scene = scene;
        this._sceneInfoPanel.setScene(this._scene);
        this._svpanel.setScene(this._scene);
        this._svpanel.repaint();
    }

    protected void newScene() {
        try {
            StageSceneModel model = StageSceneModel.blankStageSceneModel();
            model.type = "world";
            this.setScene(new StageScene(model, null));
        }
        catch (Exception e) {
            Log.log.warning((Object)"Unable to set blank scene.", new Object[]{e});
        }
    }

    @Override
    public void setMisoSceneModel(StageMisoSceneModel model) {
        AuxModel[] models = this._scene.getSceneModel().auxModels;
        int ii = 0;
        while (ii < models.length) {
            if (models[ii] instanceof StageMisoSceneModel) {
                models[ii] = model;
            }
            ++ii;
        }
    }

    public void handleNew(ActionEvent evt) {
        this.setFilePath(null);
        this.newScene();
    }

    public void handleOpen(ActionEvent evt) {
        this._chooser.setDialogType(0);
        this._main.remove((Component)((Object)this._svpanel));
        this._main.add((Component)this._chooser, "Center");
        SwingUtil.refresh((JComponent)this._main);
    }

    public void openScene(String path) {
        String errmsg = null;
        try {
            if (!this.loadScene(path)) {
                errmsg = "No scene data found";
            }
        }
        catch (Exception e) {
            errmsg = "Parse error: " + e;
            Log.log.warning((Object)e, new Object[0]);
        }
        if (errmsg != null) {
            errmsg = "Unable to load scene from " + path + ":\n" + errmsg;
            JOptionPane.showMessageDialog((Component)((Object)this), errmsg, "Load error", 0);
        }
    }

    protected boolean loadScene(String path) throws IOException, SAXException {
        StageSceneModel model = (StageSceneModel)this._parser.parseScene(path);
        if (model == null) {
            return false;
        }
        this.setScene(new StageScene(model, null));
        this.setFilePath(path);
        return true;
    }

    public void handleSave(ActionEvent evt) {
        if (this._filepath == null) {
            this.handleSaveAs(evt);
            return;
        }
        if (!this.checkSaveOk()) {
            return;
        }
        try {
            File tmpfile = new File(String.valueOf(this._filepath) + ".tmp");
            this._writer.writeScene(tmpfile, this._scene.getSceneModel());
            File sfile = new File(this._filepath);
            if (!sfile.delete()) {
                Log.log.warning((Object)("Aiya! Not able to remove " + this._filepath + " so that we can replace it with " + tmpfile.getPath() + "."), new Object[0]);
            }
            if (!tmpfile.renameTo(sfile)) {
                Log.log.warning((Object)("Fork! Not able to rename " + tmpfile.getPath() + " to " + this._filepath + "."), new Object[0]);
            }
        }
        catch (Exception e) {
            String errmsg = "Unable to save scene to " + this._filepath + ":\n" + e;
            JOptionPane.showMessageDialog((Component)((Object)this), errmsg, "Save error", 0);
            Log.log.warning((Object)("Error writing scene [fname=" + this._filepath + "]."), new Object[]{e});
        }
    }

    protected boolean checkSaveOk() {
        String name = this._scene.getName();
        String type = this._scene.getType();
        String err = "";
        if (name.equals("") || name.indexOf("<") != -1 || name.indexOf(">") != -1) {
            err = String.valueOf(err) + "Invalid scene name.\n";
        }
        if (type.equals("")) {
            err = String.valueOf(err) + "No scene type specified.\n";
        }
        if ("".equals(err)) {
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), String.valueOf(err) + "\nPlease fix and try again.", "Won't save: scene is broken!", 0);
        return false;
    }

    public void handleSaveAs(ActionEvent evt) {
        this._chooser.setDialogType(1);
        this._main.remove((Component)((Object)this._svpanel));
        this._main.add((Component)this._chooser, "Center");
        SwingUtil.refresh((JComponent)this._main);
    }

    protected void setFilePath(String filepath) {
        this._filepath = filepath;
        this.setTitle("Narya Scene Editor: " + (this._filepath == null ? "<new>" : this._filepath));
    }

    public void handleQuit(ActionEvent evt) {
        System.exit(0);
    }

    public void handleTestTiles(ActionEvent evt) {
        if (this._testLoader == null) {
            this._testLoader = new TestTileLoader();
        }
        this._tpanel.insertTestTiles(this._testLoader.loadTestTiles());
    }

    public void updateMiniView(ActionEvent evt) {
        this._scrollBox.updateView();
    }

    public void undo(ActionEvent evt) {
        this._svpanel.undo();
    }

    public void redo(ActionEvent evt) {
        this._svpanel.redo();
    }

    public void updateTileInfo() {
        this._tpanel.updateTileTable();
    }

    public void handlePreferences(ActionEvent evt) {
        PreferencesDialog pd = new PreferencesDialog();
        EditorDialogUtil.display((JFrame)((Object)this), pd);
    }

    public void handleSetDefBase(ActionEvent evt) {
        if (this._model.getTileSet() instanceof BaseTileSet) {
            this._svpanel.updateDefaultTileSet(this._model.getTileSetId());
        } else {
            Log.log.warning((Object)("Not making non-base tileset into default " + this._model.getTileSet() + "."), new Object[0]);
        }
    }
}

