/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.threerings.media.image.ColorUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;

public class DirectionButton
extends AbstractButton {
    protected int _direction = 7;
    protected int _armed = -1;
    protected int _dia;
    protected int _cdia;
    protected int[][] _coords = new int[8][2];
    protected int _prefdia;

    public DirectionButton() {
        this(41);
    }

    public DirectionButton(int preferredDiameter) {
        this._prefdia = preferredDiameter;
        this.configSize(this._prefdia);
        this.setModel(new DefaultButtonModel());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (DirectionButton.this.isEnabled()) {
                    DirectionButton.this._armed = DirectionButton.this.getDirection(event.getX(), event.getY());
                    DirectionButton.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (DirectionButton.this._armed != -1 && DirectionButton.this.isEnabled() && DirectionButton.this._armed == DirectionButton.this.getDirection(event.getX(), event.getY()) && DirectionButton.this._direction != DirectionButton.this._armed) {
                    DirectionButton.this._direction = DirectionButton.this._armed;
                    DirectionButton.this.fireStateChanged();
                }
                DirectionButton.this._armed = -1;
                DirectionButton.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.isEnabled() ? Color.red : ColorUtil.blend((Color)Color.red, (Color)this.getBackground()));
        g.fillOval(this._coords[this._direction][0], this._coords[this._direction][1], this._cdia, this._cdia);
        if (this._armed != -1) {
            g.setColor(ColorUtil.blend((Color)Color.black, (Color)this.getBackground()));
            g.fillOval(this._coords[this._armed][0], this._coords[this._armed][1], this._cdia, this._cdia);
        }
        g.setColor(this.isEnabled() ? Color.black : ColorUtil.blend((Color)Color.black, (Color)this.getBackground()));
        g.drawOval(0, 0, this._dia, this._dia);
        int ii = 0;
        while (ii < 8) {
            g.drawOval(this._coords[ii][0], this._coords[ii][1], this._cdia, this._cdia);
            ++ii;
        }
    }

    public int getDirection() {
        return this._direction;
    }

    public void setDirection(int direction) {
        if (direction != this._direction) {
            this._direction = direction;
            this.fireStateChanged();
            this.repaint();
        }
    }

    protected int getDirection(int x, int y) {
        int ii = 0;
        while (ii < 8) {
            if (x > this._coords[ii][0] && x < this._coords[ii][0] + this._cdia && y > this._coords[ii][1] && y < this._coords[ii][1] + this._cdia) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.configSize(Math.min(d.width, d.height));
    }

    protected void configSize(int diameter) {
        this._dia = diameter - 1;
        this._cdia = this._dia / 4;
        int mid = (this._dia - this._cdia) / 2;
        int num = 8;
        int ii = 0;
        while (ii < num) {
            double rads = Math.PI * 2 * (double)ii / (double)num;
            int dir = (ii + 5) % num;
            this._coords[dir][0] = mid + (int)((double)mid * Math.cos(rads));
            this._coords[dir][1] = mid + (int)((double)mid * Math.sin(rads));
            ++ii;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this._prefdia, this._prefdia);
    }
}

