/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.HashIntMap;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.media.util.AStarPathUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.data.SparseMisoSceneModel;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.data.Permission;
import com.threerings.stage.Log;
import com.threerings.stage.data.DefaultColorUpdate;
import com.threerings.stage.data.ModifyObjectsUpdate;
import com.threerings.stage.data.StageCodes;
import com.threerings.stage.data.StageLocation;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.data.StageOccupantInfo;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.data.StageSceneMarshaller;
import com.threerings.stage.data.StageSceneModel;
import com.threerings.stage.data.StageSceneObject;
import com.threerings.stage.server.StageSceneProvider;
import com.threerings.stage.server.StageServer;
import com.threerings.stage.util.StageSceneUtil;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.spot.data.Cluster;
import com.threerings.whirled.spot.data.ClusterObject;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SceneLocation;
import com.threerings.whirled.spot.server.SpotSceneManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StageSceneManager
extends SpotSceneManager
implements StageSceneProvider {
    protected StageSceneObject _ssobj;
    protected StageScene _sscene;
    protected StageMisoSceneModel _mmodel;
    protected ArrayList<Rectangle> _footprints = Lists.newArrayList();
    protected HashIntMap<Rectangle> _loners = new HashIntMap();
    protected HashSet<Point> _plocs = Sets.newHashSet();
    protected static final int[] TARGET_SIZE = new int[]{1, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8};
    protected static final int[] X_OFF;
    protected static final int[] Y_OFF;
    protected static final int[] PORTAL_DX;
    protected static final int[] PORTAL_DY;

    static {
        int[] nArray = new int[4];
        nArray[1] = -1;
        nArray[3] = -1;
        X_OFF = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = -1;
        nArray2[3] = -1;
        Y_OFF = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = -1;
        nArray3[3] = 1;
        PORTAL_DX = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 1;
        nArray4[2] = -1;
        PORTAL_DY = nArray4;
    }

    public AStarPathUtil.TraversalPred getCanStandPred() {
        return new AStarPathUtil.TraversalPred(){
            protected StageLocation _tloc = new StageLocation();

            public boolean canTraverse(Object traverser, int x, int y) {
                this._tloc.x = MisoUtil.toFull((int)x, (int)2);
                this._tloc.y = MisoUtil.toFull((int)y, (int)2);
                return StageSceneManager.this.mayStandAtLocation((BodyObject)traverser, this._tloc);
            }
        };
    }

    public boolean addObject(ObjectInfo info, boolean killOverlap, boolean allowOverlap) {
        Rectangle foot = StageSceneUtil.getObjectFootprint(StageServer.tilemgr, info.tileId, info.x, info.y);
        if (foot == null) {
            Log.log.warning((Object)("Aiya! Unable to compute object footprint! [where=" + this.where() + ", info=" + info + "]."), new Object[0]);
            return false;
        }
        ObjectInfo[] lappers = StageSceneUtil.getIntersectedObjects(StageServer.tilemgr, (StageSceneModel)this._sscene.getSceneModel(), foot);
        if (!killOverlap && lappers.length > 0 && !allowOverlap) {
            return false;
        }
        ModifyObjectsUpdate update = new ModifyObjectsUpdate();
        update.init(this._sscene.getId(), this._sscene.getVersion(), new ObjectInfo[]{info}, (ObjectInfo[])(killOverlap ? lappers : null));
        Log.log.info((Object)("Modifying objects '" + update + "."), new Object[0]);
        this.recordUpdate(update, true);
        return true;
    }

    public void setColor(int classId, int colorId) {
        DefaultColorUpdate update = new DefaultColorUpdate();
        update.init(this._sscene.getId(), this._sscene.getVersion(), classId, colorId);
        this.recordUpdate(update, false);
    }

    public boolean isPassable(int tx, int ty) {
        return StageSceneUtil.isPassable(StageServer.tilemgr, this._mmodel.getBaseTileId(tx, ty)) && !this.checkContains(this._footprints, tx, ty);
    }

    public boolean mayStandAtLocation(BodyObject source, StageLocation loc) {
        return this.validateLocation(source, loc, false);
    }

    @Override
    public void addObject(ClientObject caller, ObjectInfo info, InvocationService.ConfirmListener listener) throws InvocationException {
        InvocationException.requireAccess((ClientObject)caller, (Permission)StageCodes.MODIFY_SCENE_ACCESS, (Object)this._sscene);
        if (this.addObject(info, false, true)) {
            listener.requestProcessed();
        } else {
            listener.requestFailed(StageCodes.ERR_NO_OVERLAP);
        }
    }

    @Override
    public void removeObjects(ClientObject caller, ObjectInfo[] info, InvocationService.ConfirmListener listener) throws InvocationException {
        InvocationException.requireAccess((ClientObject)caller, (Permission)StageCodes.MODIFY_SCENE_ACCESS, (Object)this._sscene);
        ModifyObjectsUpdate update = new ModifyObjectsUpdate();
        update.init(this._sscene.getId(), this._sscene.getVersion(), null, info);
        Log.log.info((Object)("Modifying objects '" + update + "."), new Object[0]);
        this.recordUpdate(update, true);
        listener.requestProcessed();
    }

    @Override
    protected void gotSceneData(Object extras) {
        super.gotSceneData(extras);
        this._sscene = (StageScene)this._scene;
        this._mmodel = StageMisoSceneModel.getSceneModel(this._scene.getSceneModel());
        this.computeFootprints();
    }

    protected void recordUpdate(SceneUpdate update, boolean tilesModified) {
        this.recordUpdate(update);
        if (tilesModified) {
            this.sceneTilesModified();
        }
    }

    protected void sceneTilesModified() {
        this.computeFootprints();
    }

    @Override
    protected void didStartup() {
        super.didStartup();
        this._ssobj = (StageSceneObject)this._plobj;
        this._ssobj.setStageSceneService((StageSceneMarshaller)this.addProvider(this, StageSceneMarshaller.class));
    }

    protected PlaceObject createPlaceObject() {
        return new StageSceneObject();
    }

    @Override
    protected void bodyLeft(int bodyOid) {
        super.bodyLeft(bodyOid);
        this._loners.remove(bodyOid);
    }

    @Override
    protected void updateLocation(BodyObject source, Location loc) {
        super.updateLocation(source, loc);
        StageLocation sloc = (StageLocation)loc;
        int tx = MisoUtil.fullToTile((int)sloc.x);
        int ty = MisoUtil.fullToTile((int)sloc.y);
        this._loners.put(source.getOid(), (Object)new Rectangle(tx, ty, 1, 1));
    }

    protected void computeFootprints() {
        this._footprints.clear();
        this._mmodel.visitObjects(new SparseMisoSceneModel.ObjectVisitor(){

            public void visit(ObjectInfo info) {
                Rectangle foot = StageSceneUtil.getObjectFootprint(StageServer.tilemgr, info.tileId, info.x, info.y);
                StageSceneManager.this._footprints.add(foot);
            }
        });
        this._plocs.clear();
        Iterator<Portal> iter = this._sscene.getPortals();
        while (iter.hasNext()) {
            Portal port = iter.next();
            StageLocation loc = (StageLocation)port.loc;
            this._plocs.add(new Point(MisoUtil.fullToTile((int)loc.x), MisoUtil.fullToTile((int)loc.y)));
        }
    }

    protected boolean validateLocation(BodyObject source, StageLocation loc, boolean allowPortals) {
        int ty;
        int tx = MisoUtil.fullToTile((int)loc.x);
        if (!StageSceneUtil.isPassable(StageServer.tilemgr, this._mmodel.getBaseTileId(tx, ty = MisoUtil.fullToTile((int)loc.y)))) {
            return false;
        }
        if (allowPortals && this._plocs.contains(new Point(tx, ty))) {
            return true;
        }
        SceneLocation cloc = (SceneLocation)this._ssobj.occupantLocs.get((Comparable)Integer.valueOf(source.getOid()));
        if (cloc != null) {
            StageLocation sloc = (StageLocation)cloc.loc;
            if (MisoUtil.fullToTile((int)sloc.x) == tx && MisoUtil.fullToTile((int)sloc.y) == ty) {
                return true;
            }
        }
        return !this.checkContains((Iterable<? extends Rectangle>)this._ssobj.clusters, tx, ty) && !this.checkContains(this._footprints, tx, ty) && !this.checkContains(this._loners.values(), tx, ty);
    }

    protected boolean checkContains(Iterable<? extends Rectangle> rects, int tx, int ty) {
        for (Rectangle rectangle : rects) {
            if (!rectangle.contains(tx, ty)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected SceneLocation computeEnteringLocation(BodyObject body, Portal from, Portal entry) {
        if (entry == null) {
            Log.log.warning((Object)("Requested to compute entering location for non-existent portal [where=" + this.where() + ", who=" + body.who() + "]."), new Object[0]);
            entry = this._sscene.getDefaultEntrance();
        }
        return this.computeEnteringLocation(body, entry, 1);
    }

    protected SceneLocation computeEnteringLocation(BodyObject body, Portal entry, int minDistance) {
        return this.computeEnteringLocation(body, (StageLocation)entry.getOppLocation(), minDistance);
    }

    protected SceneLocation computeEnteringLocation(BodyObject body, StageLocation base, int minDistance) {
        MisoSceneMetrics metrics = StageSceneUtil.getMetrics();
        StageLocation sloc = base.clone();
        int tx = MisoUtil.fullToTile((int)sloc.x);
        int ty = MisoUtil.fullToTile((int)sloc.y);
        int oidx = sloc.orient / 2;
        int lidx = (oidx + 3) % 4;
        int ridx = (oidx + 1) % 4;
        int MAX_FAN = 4;
        int fan = 1;
        block0: while (fan < 4) {
            tx += PORTAL_DX[oidx];
            ty += PORTAL_DY[oidx];
            if (fan >= minDistance) {
                if (this.checkEntry(metrics, body, tx, ty, sloc)) break;
                int lx = tx;
                int ly = ty;
                int ff = 0;
                while (ff < fan) {
                    if (this.checkEntry(metrics, body, lx += PORTAL_DX[lidx], ly += PORTAL_DY[lidx], sloc)) break block0;
                    ++ff;
                }
                int rx = tx;
                int ry = ty;
                ff = 0;
                while (ff < fan) {
                    if (this.checkEntry(metrics, body, rx += PORTAL_DX[ridx], ry += PORTAL_DY[ridx], sloc)) break block0;
                    ++ff;
                }
                if (fan == 3) {
                    sloc = base;
                }
            }
            ++fan;
        }
        tx = MisoUtil.fullToTile((int)sloc.x);
        ty = MisoUtil.fullToTile((int)sloc.y);
        this._loners.put(body.getOid(), (Object)new Rectangle(tx, ty, 1, 1));
        return new SceneLocation(sloc, body.getOid());
    }

    protected boolean checkEntry(MisoSceneMetrics metrics, BodyObject body, int tx, int ty, StageLocation loc) {
        loc.x = MisoUtil.toFull((int)tx, (int)(metrics.finegran / 2));
        loc.y = MisoUtil.toFull((int)ty, (int)(metrics.finegran / 2));
        return this.validateLocation(body, loc, false);
    }

    @Override
    protected boolean validateLocation(BodyObject source, Location loc) {
        return this.validateLocation(source, (StageLocation)loc, true);
    }

    @Override
    protected boolean canAddBody(SpotSceneManager.ClusterRecord clrec, BodyObject body) {
        if (clrec.size() >= TARGET_SIZE.length - 2) {
            return false;
        }
        Cluster cl = clrec.getCluster();
        if (cl.width == 0) {
            cl.width = 2;
            cl.height = 2;
            return true;
        }
        int target = TARGET_SIZE[clrec.size() + 1];
        if (cl.width >= target) {
            return true;
        }
        int expand = target - cl.width;
        Rectangle rect = null;
        int ii = 0;
        while (ii < X_OFF.length) {
            rect = new Rectangle(cl.x + expand * X_OFF[ii], cl.y + expand * Y_OFF[ii], cl.width + expand, cl.height + expand);
            if (!this.checkIntersects((Iterable<? extends Rectangle>)this._ssobj.clusters, rect, cl) && !this.checkIntersects(this._footprints, rect, cl) && !this.checkPortals(rect) && !this.checkViolatesPassability(rect)) break;
            rect = null;
            ++ii;
        }
        if (rect == null) {
            return false;
        }
        Iterator iterator = this._loners.keySet().iterator();
        while (iterator.hasNext()) {
            Rectangle trect;
            int bodyOid = (Integer)iterator.next();
            if (bodyOid == body.getOid() || (trect = (Rectangle)this._loners.get(bodyOid)).equals(cl) || !trect.intersects(rect)) continue;
            ClusterObject clobj = clrec.getClusterObject();
            if (clobj != null && clobj.occupants.contains(bodyOid)) {
                Log.log.warning((Object)("Ignoring stale occupant [where=" + this.where() + ", cluster=" + cl + ", occ=" + bodyOid + "]."), new Object[0]);
                continue;
            }
            final BodyObject bobj = (BodyObject)this._omgr.getObject(bodyOid);
            if (bobj == null) {
                Log.log.warning((Object)("Can't subsume disappeared body [where=" + this.where() + ", cluster=" + cl + ", boid=" + bodyOid + "]."), new Object[0]);
                continue;
            }
            final SpotSceneManager.ClusterRecord fclrec = clrec;
            this._omgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    try {
                        Log.log.info((Object)("Subsuming " + bobj.who() + " into " + fclrec.getCluster() + "."), new Object[0]);
                        fclrec.addBody(bobj);
                    }
                    catch (InvocationException ie) {
                        Log.log.info((Object)("Unable to subsume neighbor [cluster=" + fclrec.getCluster() + ", neighbor=" + bobj.who() + ", cause=" + ie.getMessage() + "]."), new Object[0]);
                    }
                }
            });
        }
        cl.setBounds(rect);
        return true;
    }

    protected boolean checkIntersects(Iterable<? extends Rectangle> rects, Rectangle rect, Rectangle ignore) {
        for (Rectangle rectangle : rects) {
            if (ignore != null && rectangle.equals(ignore) || !rectangle.intersects(rect)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkPortals(Rectangle rect) {
        for (Point ppoint : this._plocs) {
            if (!rect.contains(ppoint)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkViolatesPassability(Rectangle rect) {
        int xx = rect.x - 1;
        int ex = rect.x + rect.width + 1;
        while (xx < ex) {
            int yy = rect.y - 1;
            int ey = rect.y + rect.height + 1;
            while (yy < ey) {
                int btid = this._mmodel.getBaseTileId(xx, yy);
                if ((btid != 0 || xx != rect.x - 1 && xx != rect.x + rect.width && yy != rect.y - 1 && yy != rect.y + rect.height) && !StageSceneUtil.isPassable(StageServer.tilemgr, btid)) {
                    return true;
                }
                ++yy;
            }
            ++xx;
        }
        return false;
    }

    @Override
    protected void bodyAdded(SpotSceneManager.ClusterRecord clrec, BodyObject body) {
        super.bodyAdded(clrec, body);
        int bodyOid = body.getOid();
        this._loners.remove(bodyOid);
        Cluster cl = clrec.getCluster();
        if (clrec.size() == 1) {
            cl.width = 1;
            cl.height = 1;
            SceneLocation loc = this.locationForBody(bodyOid);
            if (loc == null) {
                Log.log.warning((Object)("Foreign body added to cluster [clrec=" + (Object)((Object)clrec) + ", body=" + body.who() + "]."), new Object[0]);
                cl.x = 10;
                cl.y = 10;
            } else {
                StageLocation sloc = (StageLocation)loc.loc;
                cl.x = MisoUtil.fullToTile((int)sloc.x);
                cl.y = MisoUtil.fullToTile((int)sloc.y);
            }
            return;
        }
        List<SceneLocation> locs = StageSceneUtil.getClusterLocs(cl);
        for (Integer integer : clrec.keySet()) {
            int tbodyOid = integer;
            if (tbodyOid == bodyOid) continue;
            this.positionBody(cl, tbodyOid, locs);
        }
        this.positionBody(cl, bodyOid, locs);
    }

    protected void positionBody(Cluster cl, int bodyOid, List<SceneLocation> locs) {
        SceneLocation sloc = (SceneLocation)this._ssobj.occupantLocs.get((Comparable)Integer.valueOf(bodyOid));
        if (sloc == null) {
            BodyObject user = (BodyObject)this._omgr.getObject(bodyOid);
            String who = user == null ? "" + bodyOid : user.who();
            Log.log.warning((Object)("Can't position locationless user [where=" + this.where() + ", cluster=" + cl + ", boid=" + who + "]."), new Object[0]);
            return;
        }
        SceneLocation cloc = StageSceneManager.getClosestLoc(locs, sloc);
        if (cloc != null && !cloc.loc.equivalent(sloc.loc)) {
            cloc.bodyOid = bodyOid;
            this._ssobj.updateOccupantLocs(cloc);
        }
    }

    @Override
    protected void bodyRemoved(SpotSceneManager.ClusterRecord clrec, BodyObject body) {
        super.bodyRemoved(clrec, body);
        if (clrec.size() < 1) {
            return;
        }
        int target = TARGET_SIZE[clrec.size()];
        Cluster cl = clrec.getCluster();
        if (cl.width <= target + (clrec.size() > 1 ? 1 : 0)) {
            return;
        }
        cl.width = target;
        cl.height = target;
        List<SceneLocation> locs = StageSceneUtil.getClusterLocs(cl);
        for (Integer integer : clrec.keySet()) {
            int bodyOid = integer;
            if (bodyOid == body.getOid()) continue;
            this.positionBody(cl, bodyOid, locs);
        }
    }

    @Override
    protected void checkCanCluster(BodyObject initiator, BodyObject target) throws InvocationException {
        StageOccupantInfo info = (StageOccupantInfo)this._ssobj.occupantInfo.get((Comparable)Integer.valueOf(target.getOid()));
        if (info == null) {
            Log.log.warning((Object)("Have no occinfo for cluster target [where=" + this.where() + ", init=" + initiator.who() + ", target=" + target.who() + "]."), new Object[0]);
            throw new InvocationException("m.internal_error");
        }
        if (!info.isClusterable()) {
            throw new InvocationException(StageCodes.ERR_CANNOT_CLUSTER);
        }
    }

    protected static SceneLocation getClosestLoc(List<SceneLocation> locs, SceneLocation optimalLocation) {
        StageLocation loc = (StageLocation)optimalLocation.loc;
        SceneLocation cloc = null;
        float cdist = 2.1474836E9f;
        int cidx = -1;
        int ii = 0;
        int ll = locs.size();
        while (ii < ll) {
            SceneLocation tloc = locs.get(ii);
            StageLocation sl = (StageLocation)tloc.loc;
            float tdist = MathUtil.distance((int)loc.x, (int)loc.y, (int)sl.x, (int)sl.y);
            if (tdist < cdist) {
                cloc = tloc;
                cdist = tdist;
                cidx = ii;
            }
            ++ii;
        }
        if (cidx != -1) {
            locs.remove(cidx);
        }
        return cloc;
    }
}

