/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.client;

import com.samskivert.util.IntListUtil;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.media.FrameParticipant;
import com.threerings.media.animation.Animation;
import com.threerings.media.animation.AnimationAdapter;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.client.PuzzleController;
import com.threerings.puzzle.client.PuzzleControllerDelegate;
import com.threerings.puzzle.client.PuzzlePanel;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.data.BoardSummary;
import com.threerings.puzzle.drop.client.DropBlockSprite;
import com.threerings.puzzle.drop.client.DropBoardView;
import com.threerings.puzzle.drop.client.DropPanel;
import com.threerings.puzzle.drop.client.DropSprite;
import com.threerings.puzzle.drop.client.DropSpriteObserver;
import com.threerings.puzzle.drop.data.DropBoard;
import com.threerings.puzzle.drop.data.DropCodes;
import com.threerings.puzzle.drop.data.DropConfig;
import com.threerings.puzzle.drop.data.DropLogic;
import com.threerings.puzzle.drop.data.DropPieceCodes;
import com.threerings.puzzle.drop.util.PieceDropLogic;
import com.threerings.puzzle.drop.util.PieceDropper;
import com.threerings.puzzle.util.PuzzleContext;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

public abstract class DropControllerDelegate
extends PuzzleControllerDelegate
implements DropCodes,
DropPieceCodes,
FrameParticipant {
    public static final String MOVE_BLOCK_LEFT = "move_block_left";
    public static final String MOVE_BLOCK_RIGHT = "move_block_right";
    public static final String ROTATE_BLOCK_CCW = "rotate_block_ccw";
    public static final String ROTATE_BLOCK_CW = "rotate_block_cw";
    public static final String START_DROP_BLOCK = "start_drop_block";
    public static final String END_DROP_BLOCK = "end_drop_block";
    public static final String RAISE_ROW = "raise_row";
    protected PuzzleContext _ctx;
    protected PuzzleController _ctrl;
    protected DropPanel _dpanel;
    protected DropBoardView _dview;
    protected DropBoard _dboard;
    protected boolean _usedrop;
    protected boolean _userise;
    protected boolean _stable;
    protected int _bwid;
    protected int _bhei;
    protected int _risedist;
    protected float _risevel;
    protected DropBlockSprite _blocksprite;
    protected PieceDropper _dropper;
    protected long _rpstamp;
    protected long _risestamp;
    protected long _risesent;
    protected long _zipstamp;
    protected int _bounceInterval;
    protected long _bounceStamp;
    protected int _bounceRow;
    protected long _blockStamp;
    protected boolean _fastDrop;
    protected AnimationAdapter _evolveObserver = new AnimationAdapter(){

        public void animationCompleted(Animation anim, long when) {
            DropControllerDelegate.this.animationDidFinish(anim);
        }
    };
    protected DropSpriteObserver _dropMovedHandler = new DropSpriteObserver(){

        @Override
        public void pieceMoved(DropSprite sprite, long when, int col, int row) {
            DropControllerDelegate.this.handleDropSpriteMoved(sprite, when, col, row);
        }
    };
    protected DropBoard.PieceOperation _updateBoardOp = new DropBoard.PieceOperation(){

        @Override
        public boolean execute(DropBoard board, int col, int row) {
            DropControllerDelegate.this._dview.updatePiece(col, row);
            return true;
        }
    };
    protected static final float DEFAULT_RISE_VELOCITY = 0.1f;
    protected static final int DEFAULT_RISE_DISTANCE = 20;
    protected static final long RISE_INTERVAL = 50L;
    protected static final float BOUNCE_FRACTION = 0.125f;

    public DropControllerDelegate(PuzzleController ctrl, DropLogic logic) {
        super(ctrl);
        this._ctrl = ctrl;
        this._usedrop = logic.useBlockDropping();
        this._userise = logic.useBoardRising();
        if (this._userise) {
            this._risevel = this.getRiseVelocity();
            this._risedist = this.getRiseDistance();
        }
    }

    public void init(CrowdContext ctx, PlaceConfig config) {
        super.init(ctx, config);
        PuzzlePanel panel = (PuzzlePanel)this._ctrl.getPlaceView();
        this._ctx = (PuzzleContext)ctx;
        this._dview = (DropBoardView)panel.getBoardView();
        this._dpanel = (DropPanel)((Object)panel);
        this._dboard = (DropBoard)this._ctrl.getBoard();
        DropConfig dconfig = (DropConfig)config;
        this._bwid = dconfig.getBoardWidth();
        this._bhei = dconfig.getBoardHeight();
        PieceDropLogic pdl = this.getPieceDropLogic();
        if (pdl != null) {
            this._dropper = this.getPieceDropper(pdl);
        }
    }

    protected float getRiseVelocity() {
        return 0.1f;
    }

    protected int getRiseDistance() {
        return 20;
    }

    @Override
    protected void startAction() {
        super.startAction();
        this._ctx.getFrameManager().registerFrameParticipant((FrameParticipant)this);
        if (this._blocksprite != null) {
            long delta = this._dview.getTimeStamp() - this._blockStamp;
            Log.log.info((Object)"Restarting drop sprite", new Object[]{"delta", delta});
            this._blocksprite.fastForward(delta);
            this._blockStamp = 0L;
            this._dview.addSprite(this._blocksprite);
            if (this._blocksprite.isBouncing()) {
                Log.log.info((Object)"Ended on a bounce, landing the block and starting things up.", new Object[0]);
                this.checkBlockLanded("bounced", true, true);
            }
        }
        this.unstabilizeBoard();
    }

    @Override
    protected boolean canClearAction() {
        if (!this._stable) {
            Log.log.info((Object)"Rejecting canClear() request because not stable.", new Object[0]);
        }
        return this._stable && super.canClearAction();
    }

    @Override
    protected void clearAction() {
        super.clearAction();
        this._bounceStamp = 0L;
        this._bounceRow = Integer.MIN_VALUE;
        if (this._blocksprite != null) {
            this._dview.removeSprite(this._blocksprite);
            this._blockStamp = this._dview.getTimeStamp();
        }
        this._rpstamp = 0L;
        this._zipstamp = 0L;
        this._fastDrop = false;
        this._ctx.getFrameManager().removeFrameParticipant((FrameParticipant)this);
    }

    @Override
    public void gameDidEnd() {
        super.gameDidEnd();
        this._blocksprite = null;
        this._risestamp = 0L;
    }

    public boolean handleAction(ActionEvent action) {
        if (this.handleBlockAction(action)) {
            return true;
        }
        String cmd = action.getActionCommand();
        if (cmd.equals(START_DROP_BLOCK)) {
            this.handleDropBlock(true);
        } else if (cmd.equals(END_DROP_BLOCK)) {
            this.handleDropBlock(false);
        } else {
            return super.handleAction(action);
        }
        return true;
    }

    @Override
    public void setBoard(Board board) {
        super.setBoard(board);
        this._dboard = (DropBoard)board;
        this.updateSelfSummary();
    }

    protected boolean handleBlockAction(ActionEvent action) {
        String source;
        String cmd = action.getActionCommand();
        boolean handled = false;
        if (cmd.equals(MOVE_BLOCK_LEFT)) {
            this.handleMoveBlock(0);
            handled = true;
        } else if (cmd.equals(MOVE_BLOCK_RIGHT)) {
            this.handleMoveBlock(1);
            handled = true;
        } else if (cmd.equals(ROTATE_BLOCK_CCW)) {
            this.handleRotateBlock(0);
            handled = true;
        } else if (cmd.equals(ROTATE_BLOCK_CW)) {
            this.handleRotateBlock(1);
            handled = true;
        }
        if (handled && this._blocksprite != null && this.checkBlockLanded(source = "fiddled [cmd=" + cmd + "]", false, false)) {
            this.startBounceTimer(source);
        }
        return handled;
    }

    protected void handleMoveBlock(int dir) {
        float pctdone;
        if (this._blocksprite == null) {
            return;
        }
        Rectangle bb = this._blocksprite.getBoardBounds();
        int row = this._blocksprite.getRow();
        int col = this._blocksprite.getColumn();
        int dx = dir == 0 ? -1 : 1;
        Point pos = this._dboard.getForgivingMove(bb.x, bb.y, bb.width, bb.height, dx, 0, pctdone = row >= this._bhei - 1 ? 0.0f : this._blocksprite.getPercentDone(this._dview.getTimeStamp()));
        if (pos != null) {
            int frow = row + (pos.y - bb.y);
            int fcol = col + (pos.x - bb.x);
            this._blocksprite.setBoardLocation(frow, fcol);
        }
    }

    protected void handleRotateBlock(int dir) {
        if (this._blocksprite == null) {
            return;
        }
        int[] rows = this._blocksprite.getRows();
        int[] cols = this._blocksprite.getColumns();
        float pctdone = rows[0] >= this._bhei - 1 ? 0.0f : this._blocksprite.getPercentDone(this._dview.getTimeStamp());
        int[] info = this._dboard.getForgivingRotation(rows, cols, this._blocksprite.getOrientation(), dir, this.getRotationType(), pctdone, this._blocksprite.canPopup());
        if (info != null) {
            this._dview.rotateDropBlock(this._blocksprite, info[0]);
            this._blocksprite.setBoardLocation(info[2], info[1]);
            if (info[3] != 0) {
                this._blocksprite.didPopup();
            }
            this.blockDidRotate(dir);
        }
    }

    protected void blockDidRotate(int dir) {
    }

    protected int getRotationType() {
        return 0;
    }

    protected void handleDropBlock(boolean fast) {
        this._fastDrop = fast;
        if (this._blocksprite != null && this._bounceStamp == 0L) {
            this._blocksprite.setVelocity(this.getPieceVelocity(fast));
        }
    }

    protected abstract float getPieceVelocity(boolean var1);

    protected void dropNextBlock() {
        if (this._blocksprite != null || !this._ctrl.hasAction()) {
            Log.log.info((Object)"Not dropping block", new Object[]{"bs", this._blocksprite != null, "action", this._ctrl.hasAction()});
            return;
        }
        if (this.checkDropEndsGame()) {
            return;
        }
        int pidx = this._ctrl.getPlayerIndex();
        if (pidx != -1 && !this._ctrl.isGameOver() && this._puzobj.isActivePlayer(pidx)) {
            this._blocksprite = this.createNextBlock();
            if (this._blocksprite != null) {
                this._fastDrop = false;
                this._blocksprite.setVelocity(this.getPieceVelocity(this._fastDrop));
                this._blocksprite.addSpriteObserver(this._dropMovedHandler);
                this._dview.addSprite(this._blocksprite);
                this._dpanel.setNextBlock(this.peekNextPieces());
                if (this.checkBlockLanded("next-block", false, true)) {
                    this.startBounceTimer("next-block");
                }
            }
            this._bounceRow = Integer.MIN_VALUE;
        }
    }

    protected boolean checkDropEndsGame() {
        return false;
    }

    protected DropBlockSprite createNextBlock() {
        return null;
    }

    protected int[] peekNextPieces() {
        return null;
    }

    protected void handleDropSpriteMoved(DropSprite sprite, long when, int col, int row) {
        if (sprite instanceof DropBlockSprite) {
            if (this.checkBlockLanded("piece-moved", false, true)) {
                this.startBounceTimer("piece-moved");
            }
            sprite.drop();
            return;
        }
        if (sprite.getDistance() > 0) {
            sprite.drop();
        } else {
            this._dview.removeSprite(sprite);
            this.applyDropSprite(sprite, col, row);
            this.unstabilizeBoard();
        }
    }

    protected void applyDropSprite(DropSprite sprite, int col, int row) {
        int[] pieces = sprite.getPieces();
        this._dboard.setSegment(1, col, row, pieces);
        int dy = 0;
        while (dy < pieces.length) {
            if (row - dy >= 0) {
                this._dview.createPiece(pieces[dy], col, row - dy);
            }
            ++dy;
        }
    }

    protected boolean canEvolveBoard() {
        return this._dview.getActionCount() == 0;
    }

    protected abstract boolean evolveBoard();

    protected void unstabilizeBoard() {
        this._stable = false;
    }

    protected void boardDidStabilize() {
        this.updateSelfSummary();
        this.dropNextBlock();
    }

    public void updateSelfSummary() {
        int pidx = this._ctrl.getPlayerIndex();
        if (pidx != -1 && this._puzobj != null && this._puzobj.summaries != null) {
            BoardSummary bsum = this._puzobj.summaries[pidx];
            bsum.setBoard(this._dboard);
            bsum.summarize();
            this._dpanel.setSummary(pidx, bsum);
        }
    }

    protected void animationDidFinish(Animation anim) {
        this.unstabilizeBoard();
    }

    protected boolean checkBlockLanded(String source, boolean commit, boolean atTop) {
        float pctdone;
        if (this._blocksprite == null) {
            return true;
        }
        int[] rows = this._blocksprite.getRows();
        int[] cols = this._blocksprite.getColumns();
        float f = pctdone = atTop ? 0.0f : this._blocksprite.getPercentDone(this._dview.getTimeStamp());
        if (this._dboard.isValidDrop(rows, cols, pctdone)) {
            if (commit) {
                Log.log.info((Object)"Not valid drop", new Object[]{"source", source, "commit", commit, "atTop", atTop, "pctdone", Float.valueOf(pctdone)});
            }
            return false;
        }
        if (commit) {
            this.blockWillLand();
            int[] pieces = this._blocksprite.getPieces();
            boolean error = false;
            int ii = 0;
            while (ii < pieces.length) {
                if (rows[ii] >= 0) {
                    int col = cols[ii];
                    int row = rows[ii];
                    if (col < 0 || col >= this._bwid || row >= this._bhei) {
                        Log.log.warning((Object)"Placing drop block piece outside board bounds!?", new Object[]{"x", col, "y", row, "pidx", ii, "blocksprite", this._blocksprite});
                        error = true;
                    } else {
                        int cpiece = this._dboard.getPiece(col, row);
                        if (cpiece != -1) {
                            Log.log.warning((Object)"Placing drop block piece onto occupied board position!?", new Object[]{"x", col, "y", row, "pidx", ii, "blocksprite", this._blocksprite});
                            error = true;
                        }
                    }
                    if (!error) {
                        this._dboard.setPiece(col, row, pieces[ii]);
                        this._dview.createPiece(pieces[ii], col, row);
                    }
                }
                ++ii;
            }
            this._dview.removeSprite(this._blocksprite);
            this._blocksprite = null;
            this.blockDidLand();
        }
        return true;
    }

    protected void blockWillLand() {
    }

    protected void blockDidLand() {
    }

    protected void startBounceTimer(String source) {
        int bounceRow = IntListUtil.getMaxValue((int[])this._blocksprite.getRows());
        if (this._bounceStamp == 0L && this._bounceRow == bounceRow) {
            if (this.checkBlockLanded("double-bounced", true, true)) {
                this.unstabilizeBoard();
            }
            return;
        }
        if (this._bounceStamp == 0L) {
            this._blocksprite.setVelocity(this.getPieceVelocity(false));
            this._bounceInterval = (int)((float)this._dview.getPieceHeight() * 0.125f / this.getPieceVelocity(false));
            this._bounceStamp = this._dview.getTimeStamp();
            this._bounceRow = bounceRow;
            this._blocksprite.setBouncing(true);
        }
    }

    protected void bounceTimerExpired() {
        if (this._bounceStamp != 0L) {
            if (this.checkBlockLanded("bounced", true, true)) {
                this.unstabilizeBoard();
            } else if (this._blocksprite != null) {
                this._blocksprite.setBouncing(false);
            }
            this._bounceStamp = 0L;
        }
    }

    protected boolean dropPieces() {
        PieceDropper.DropObserver drobs = new PieceDropper.DropObserver(){

            @Override
            public void pieceDropped(int piece, int sx, int sy, int dx, int dy) {
                float vel = DropControllerDelegate.this.getPieceVelocity(true) * 1.5f;
                long duration = (long)((float)(DropControllerDelegate.this._dview.getPieceHeight() * Math.abs(dy - sy)) / vel);
                if (sy < 0) {
                    DropControllerDelegate.this._dview.createPiece(piece, sx, sy, dx, dy, duration);
                } else {
                    DropControllerDelegate.this._dview.movePiece(sx, sy, dx, dy, duration);
                }
            }
        };
        return this._dropper.dropPieces(this._dboard, drobs) > 0;
    }

    protected PieceDropLogic getPieceDropLogic() {
        return null;
    }

    protected PieceDropper getPieceDropper(PieceDropLogic logic) {
        return new PieceDropper(logic);
    }

    public void tick(long tickStamp) {
        if (this._bounceStamp != 0L && tickStamp - this._bounceStamp >= (long)this._bounceInterval) {
            this.bounceTimerExpired();
        }
        if (this._stable || !this.canEvolveBoard()) {
            return;
        }
        boolean evolving = this.evolveBoard();
        boolean debug = false;
        if (debug) {
            Log.log.info((Object)"Evolved board", new Object[]{"evolving", evolving});
        }
        if (!evolving) {
            this._stable = true;
            if (debug) {
                Log.log.info((Object)"Board did stabilize", new Object[0]);
            }
            this.boardDidStabilize();
            if (!this._ctrl.hasAction()) {
                if (debug) {
                    Log.log.info((Object)"Maybe clearing action.", new Object[0]);
                }
                this.maybeClearAction();
            }
        }
    }

    public Component getComponent() {
        return null;
    }

    public boolean needsPaint() {
        return false;
    }

    public void setRisingPaused(boolean paused) {
        if (paused && this._rpstamp == 0L) {
            this._rpstamp = this._dview.getTimeStamp();
        } else if (!paused && this._rpstamp != 0L) {
            long delta = this._dview.getTimeStamp() - this._rpstamp;
            this._risestamp += delta;
            if (this._zipstamp != 0L) {
                this._zipstamp += delta;
            }
            this._rpstamp = 0L;
        }
    }

    public void zipToNextRow() {
        if (this._zipstamp == 0L) {
            this._zipstamp = this._rpstamp != 0L ? this._rpstamp : this._dview.getTimeStamp();
        }
    }

    protected boolean checkCanRise() {
        return !this._dboard.rowContainsPieces(0, -1);
    }

    protected void boardWillRise() {
    }

    protected void boardDidRise() {
    }
}

