/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.client;

import com.threerings.media.image.Mirage;
import com.threerings.media.sprite.ImageSprite;
import com.threerings.media.sprite.PathAdapter;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.util.LinePath;
import com.threerings.media.util.Path;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.media.ScoreAnimation;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.client.PuzzleBoardView;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.drop.client.DropBlockSprite;
import com.threerings.puzzle.drop.client.DropSprite;
import com.threerings.puzzle.drop.data.DropBoard;
import com.threerings.puzzle.drop.data.DropConfig;
import com.threerings.puzzle.drop.data.DropPieceCodes;
import com.threerings.puzzle.util.PuzzleContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;

public abstract class DropBoardView
extends PuzzleBoardView
implements DropPieceCodes {
    public static final Color SCORE_COLOR = Color.white;
    public static final Color CHAIN_COLOR = Color.yellow;
    protected DropBoard _dboard;
    protected Sprite[] _pieces;
    protected boolean[] _moving;
    protected int _pwid;
    protected int _phei;
    protected int _roff;
    protected int _bwid;
    protected int _bhei;

    public DropBoardView(PuzzleContext ctx, int pwid, int phei) {
        super(ctx);
        this._pwid = pwid;
        this._phei = phei;
        this._scoreDist = 2 * this._phei;
    }

    @Override
    public void init(GameConfig config) {
        DropConfig dconfig = (DropConfig)((Object)config);
        this._bwid = dconfig.getBoardWidth();
        this._bhei = dconfig.getBoardHeight();
        super.init(config);
    }

    public int getPieceWidth() {
        return this._pwid;
    }

    public int getPieceHeight() {
        return this._phei;
    }

    public void getPiecePosition(int col, int row, Point pos) {
        pos.setLocation(col * this._pwid, row * this._phei - this._roff);
    }

    public Dimension getPieceSegmentSize(int col, int row, int orient, int len) {
        if (orient == 3 || orient == 7) {
            return new Dimension(this._pwid, len * this._phei);
        }
        return new Dimension(len * this._pwid, this._phei);
    }

    public void createPiece(int piece, int sx, int sy) {
        if (!this.inBounds(sx, sy)) {
            Log.log.warning((Object)"Requested to create piece in invalid location", new Object[]{"sx", sx, "sy", sy, new Exception()});
            return;
        }
        this.createPiece(piece, sx, sy, sx, sy, 0L);
    }

    public void updatePiece(int sx, int sy) {
        this.updatePiece(this._dboard.getPiece(sx, sy), sx, sy);
    }

    public void updatePiece(int piece, int sx, int sy) {
        if (!this.inBounds(sx, sy)) {
            Log.log.warning((Object)"Requested to update piece in invalid location", new Object[]{"sx", sx, "sy", sy, new Exception()});
            return;
        }
        int spos = sy * this._bwid + sx;
        if (this._pieces[spos] != null) {
            ((ImageSprite)this._pieces[spos]).setMirage(this.getPieceImage(piece, sx, sy, 3));
        } else {
            this.createPiece(piece, sx, sy);
        }
    }

    public void createPiece(int piece, int sx, int sy, int tx, int ty, long duration) {
        if (!this.inBounds(tx, ty)) {
            Log.log.warning((Object)"Requested to create and move piece to invalid location", new Object[]{"tx", tx, "ty", ty, new Exception()});
            return;
        }
        Sprite sprite = this.createPieceSprite(piece, sx, sy);
        if (sprite != null) {
            Point start = new Point();
            this.getPiecePosition(sx, sy, start);
            sprite.setLocation(start.x, start.y);
            this.addSprite(sprite);
            this.movePiece(sprite, sx, sy, tx, ty, duration);
        }
    }

    public Sprite movePiece(int sx, int sy, int tx, int ty, long duration) {
        int spos = sy * this._bwid + sx;
        Sprite piece = this._pieces[spos];
        if (piece == null) {
            Log.log.warning((Object)"Missing source sprite for drop", new Object[]{"sx", sx, "sy", sy, "tx", tx, "ty", ty});
            return null;
        }
        this._pieces[spos] = null;
        this.movePiece(piece, sx, sy, tx, ty, duration);
        return piece;
    }

    protected void movePiece(Sprite piece, final int sx, final int sy, final int tx, final int ty, long duration) {
        final Exception where = new Exception();
        Point start = new Point();
        this.getPiecePosition(sx, sy, start);
        if (sx == tx && sy == ty) {
            int tpos = ty * this._bwid + tx;
            if (this._pieces[tpos] != null) {
                Log.log.warning((Object)"Zoiks! Asked to add a piece where we already have one", new Object[]{"sx", sx, "sy", sy, "tx", tx, "ty", ty, where});
            }
            this._pieces[tpos] = piece;
            piece.setLocation(start.x, start.y);
            return;
        }
        final int tpos = ty * this._bwid + tx;
        this._moving[tpos] = true;
        Point end = new Point();
        this.getPiecePosition(tx, ty, end);
        piece.addSpriteObserver((Object)new PathAdapter(){

            public void pathCompleted(Sprite sprite, Path path, long when) {
                sprite.removeSpriteObserver((Object)this);
                if (DropBoardView.this._pieces[tpos] != null) {
                    Log.log.warning((Object)"Oh god, we're dropping onto another piece", new Object[]{"sx", sx, "sy", sy, "tx", String.valueOf(tx) + "ty", ty, where});
                    return;
                }
                DropBoardView.this._pieces[tpos] = sprite;
                if (DropBoardView.this._actionSprites.remove(sprite)) {
                    DropBoardView.this.maybeFireCleared();
                }
                DropBoardView.this.pieceArrived(when, sprite, tx, ty);
            }
        });
        this._actionSprites.add(piece);
        piece.move((Path)new LinePath(start, end, duration));
    }

    protected void pieceArrived(long tickStamp, Sprite sprite, int px, int py) {
        this._moving[py * this._bwid + px] = false;
    }

    protected boolean isMoving(int px, int py) {
        return this._moving[py * this._bwid + px];
    }

    public Mirage getPieceImage(int piece) {
        return this.getPieceImage(piece, 0, 0, 3);
    }

    public abstract Mirage getPieceImage(int var1, int var2, int var3, int var4);

    @Override
    public void setBoard(Board board) {
        Iterator iter = this._actionSprites.iterator();
        while (iter.hasNext()) {
            Sprite s = (Sprite)iter.next();
            if (!(s instanceof DropSprite)) continue;
            iter.remove();
            this.removeSprite(s);
        }
        int pcount = this._pieces == null ? 0 : this._pieces.length;
        int ii = 0;
        while (ii < pcount) {
            if (this._pieces[ii] != null) {
                this.removeSprite(this._pieces[ii]);
            }
            ++ii;
        }
        super.setBoard(board);
        this._dboard = (DropBoard)board;
        Point spos = new Point();
        int width = this._dboard.getWidth();
        int height = this._dboard.getHeight();
        this._pieces = new Sprite[width * height];
        int yy = 0;
        while (yy < height) {
            int xx = 0;
            while (xx < width) {
                Sprite piece = this.createPieceSprite(this._dboard.getPiece(xx, yy), xx, yy);
                if (piece != null) {
                    int ppos = yy * width + xx;
                    this.getPiecePosition(xx, yy, spos);
                    piece.setLocation(spos.x, spos.y);
                    this.addSprite(piece);
                    this._pieces[ppos] = piece;
                }
                ++xx;
            }
            ++yy;
        }
        this._moving = new boolean[width * height];
    }

    public Sprite getPieceSprite(int xx, int yy) {
        return this._pieces[yy * this._dboard.getWidth() + xx];
    }

    public void clearPieceSprite(int xx, int yy) {
        int ppos = yy * this._dboard.getWidth() + xx;
        if (this._pieces[ppos] != null) {
            this.removeSprite(this._pieces[ppos]);
            this._pieces[ppos] = null;
        }
    }

    public void clearPiece(int xx, int yy) {
        this._dboard.setPiece(xx, yy, -1);
        this.clearPieceSprite(xx, yy);
    }

    public DropSprite createPieces(int col, int row, int[] pieces, int dist) {
        return new DropSprite(this, col, row, pieces, dist);
    }

    public void dirtySegment(int dir, int col, int row, int len) {
        int x = this._pwid * col;
        int y = this._phei * row - this._roff;
        int wid = dir == 1 ? this._pwid : len * this._pwid;
        int hei = dir == 1 ? this._phei * len : this._phei;
        this._remgr.invalidateRegion(x, y, wid, hei);
    }

    public ScoreAnimation createScoreAnimation(String score, Color color, Font font) {
        return this.createScoreAnimation(score, color, font, 0, this._bhei - 1, this._bwid, this._bhei);
    }

    public ScoreAnimation createScoreAnimation(String score, Color color, Font font, int x, int y, int width, int height) {
        ScoreAnimation anim = this.createScoreAnimation(score, color, font, x, y);
        Dimension lsize = anim.getLabel().getSize();
        Point pos = new Point();
        this.centerRectInBoardRect(x, y, width, height, lsize.width, lsize.height, pos);
        anim.setLocation(pos.x, pos.y);
        return anim;
    }

    protected Sprite createPieceSprite(int piece, int px, int py) {
        if (piece == -1) {
            return null;
        }
        ImageSprite sprite = new ImageSprite(this.getPieceImage(piece, px, py, 3));
        sprite.setRenderOrder(-1);
        return sprite;
    }

    protected void centerRectInBoardRect(int bx, int by, int bwid, int bhei, int rwid, int rhei, Point pos) {
        this.getPiecePosition(bx, by + 1, pos);
        pos.x += (bwid * this._pwid - rwid) / 2;
        pos.y -= (bhei * this._phei - rhei) / 2 + rhei;
        pos.x = Math.max(Math.min(pos.x, this._bounds.width - rwid), 0);
    }

    public void rotateDropBlock(DropBlockSprite sprite, int orient) {
    }

    @Override
    public void paintBetween(Graphics2D gfx, Rectangle dirtyRect) {
        gfx.translate(0, -this._roff);
        this.renderBoard(gfx, dirtyRect);
        this.renderRisingPieces(gfx, dirtyRect);
        gfx.translate(0, this._roff);
    }

    public Dimension getPreferredSize() {
        int wid = this._bwid * this._pwid;
        int hei = this._bhei * this._phei;
        return new Dimension(wid, hei);
    }

    public boolean inBounds(int col, int row) {
        return col >= 0 && row >= 0 && col < this.getWidth() && row < this.getHeight();
    }

    protected void renderRisingPieces(Graphics2D gfx, Rectangle dirtyRect) {
    }

    protected void setRiseOffset(int y) {
        if (y != this._roff) {
            this._roff = y;
            this._remgr.invalidateRegion(this._bounds);
        }
    }
}

