/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.tourney.server;

import com.google.inject.Inject;
import com.samskivert.util.Interval;
import com.samskivert.util.ResultListener;
import com.samskivert.util.RunQueue;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.parlor.tourney.data.Participant;
import com.threerings.parlor.tourney.data.TourneyCodes;
import com.threerings.parlor.tourney.data.TourneyConfig;
import com.threerings.parlor.tourney.data.TourneyMarshaller;
import com.threerings.parlor.tourney.data.TourneyObject;
import com.threerings.parlor.tourney.server.TourneyProvider;
import com.threerings.parlor.tourney.server.TourniesManager;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.util.Name;

public abstract class TourneyManager
implements TourneyProvider,
TourneyCodes {
    protected TourneyConfig _config;
    protected TourneyObject _trobj;
    protected long _startTime;
    protected Comparable<?> _key;
    @Inject
    protected RootDObjectManager _omgr;
    @Inject
    protected InvocationManager _invmgr;
    @Inject
    protected BodyLocator _locator;
    @Inject
    protected TourniesManager _tmgr;
    protected static long MINUTE = 60000L;

    public int init(TourneyConfig config, Comparable<?> key) {
        this._config = config;
        this._key = key;
        this._trobj = (TourneyObject)this._omgr.registerObject((DObject)new TourneyObject());
        this._trobj.setTourneyService((TourneyMarshaller)this._invmgr.registerProvider((InvocationProvider)this, TourneyMarshaller.class));
        this._trobj.config = config;
        if (config.logic != null) {
            this._trobj.state = 3;
        } else {
            this._trobj.startsIn = config.startsIn;
            this._startTime = System.currentTimeMillis() + MINUTE * (long)this._config.startsIn;
        }
        return this._trobj.getOid();
    }

    @Override
    public void cancel(ClientObject caller, InvocationService.ConfirmListener listener) throws InvocationException {
        if (this._trobj.state != 0) {
            throw new InvocationException("m.already_in_progress");
        }
        if (this._trobj.participants.size() != 0) {
            throw new InvocationException("m.has_players");
        }
        this.cancelTourney("m.cancelled");
    }

    @Override
    public void join(ClientObject caller, final InvocationService.ConfirmListener listener) throws InvocationException {
        BodyObject body = (BodyObject)caller;
        if (this._trobj.state != 0) {
            throw new InvocationException("m.too_late");
        }
        final Participant part = this.makeParticipant(body);
        if (this._trobj.participants.contains((DSet.Entry)part)) {
            throw new InvocationException("m.already_in_tourney");
        }
        this.joinTourney(body);
        if (this._trobj.config.entryFee != null) {
            if (!this._trobj.config.entryFee.hasFee(body)) {
                listener.requestFailed("FAILED_ENTRY_FEE");
                return;
            }
            this._trobj.addToParticipants(part);
            ResultListener<Void> rl = new ResultListener<Void>(){

                public void requestCompleted(Void result) {
                    listener.requestProcessed();
                }

                public void requestFailed(Exception cause) {
                    TourneyManager.this._trobj.removeFromParticipants(part.getKey());
                    listener.requestFailed("FAILED_ENTRY_FEE");
                }
            };
            this._trobj.config.entryFee.reserveFee(body, rl);
        } else {
            this._trobj.addToParticipants(part);
            listener.requestProcessed();
        }
    }

    @Override
    public void leave(ClientObject caller, InvocationService.ConfirmListener listener) throws InvocationException {
        BodyObject body = (BodyObject)caller;
        if (this._trobj.state != 0) {
            throw new InvocationException("m.too_late_leave");
        }
        Name key = body.username;
        if (!this._trobj.participants.containsKey((Comparable)key)) {
            throw new InvocationException("m.not_in_tourney");
        }
        this._trobj.removeFromParticipants((Comparable<?>)key);
        if (this._trobj.config.entryFee != null) {
            this._trobj.config.entryFee.returnFee(body);
        }
        listener.requestProcessed();
    }

    public void cancelTourney(String cause) {
        if (this.isFinished()) {
            return;
        }
        this._trobj.setState(2);
        this.notifyAllParticipants(cause);
        if (this._trobj.config.entryFee != null) {
            for (Participant part : this._trobj.participants) {
                BodyObject body = this._locator.lookupBody(part.username);
                if (body == null) continue;
                this._trobj.config.entryFee.returnFee(body);
            }
        }
        this.releaseTourney();
    }

    public boolean isFinished() {
        return this._trobj == null ? false : this._trobj.state == 4 || this._trobj.state == 2;
    }

    public boolean isPending() {
        return this._trobj == null ? false : this._trobj.state == 0;
    }

    public boolean isRunning() {
        return this._trobj == null ? false : this._trobj.state == 1;
    }

    public boolean isPaused() {
        return this._trobj == null ? false : this._trobj.state == 3;
    }

    public boolean shouldStart(long now) {
        return this._trobj == null ? false : this._startTime <= now;
    }

    protected Participant makeParticipant(BodyObject body) {
        Participant part = new Participant();
        part.username = body.username;
        return part;
    }

    public abstract void notifyAllParticipants(String var1);

    protected void releaseTourney() {
        this._tmgr.releaseTourney(this._key);
        if (this._trobj.tourneyService != null) {
            this._invmgr.clearDispatcher((InvocationMarshaller)this._trobj.tourneyService);
            this._trobj.tourneyService = null;
        }
        new Interval((RunQueue)this._omgr){

            public void expired() {
                TourneyManager.this._omgr.destroyObject(TourneyManager.this._trobj.getOid());
            }
        }.schedule(MINUTE * 2L);
    }

    protected abstract void joinTourney(BodyObject var1) throws InvocationException;
}

