/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.rating.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.samskivert.jdbc.RepositoryUnit;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.Invoker;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.parlor.game.server.GameManager;
import com.threerings.parlor.game.server.GameManagerDelegate;
import com.threerings.parlor.rating.data.RatingCodes;
import com.threerings.parlor.rating.server.Rating;
import com.threerings.parlor.rating.server.persist.RatingRecord;
import com.threerings.parlor.rating.server.persist.RatingRepository;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.presents.data.ClientObject;
import com.threerings.util.Name;
import com.threerings.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class RatingDelegate
extends GameManagerDelegate
implements RatingCodes {
    protected GameManager _gmgr;
    protected GameObject _gobj;
    protected int[] _playerIds;
    protected IntMap<PlayerRating> _ratings = IntMaps.newHashIntMap();
    protected long _startStamp;
    @Inject
    protected RatingRepository _repo;
    @Inject
    @MainInvoker
    protected Invoker _invoker;

    @Override
    public void didInit(PlaceConfig config) {
        super.didInit(config);
        this._gmgr = (GameManager)this._plmgr;
    }

    public void didStartup(PlaceObject plobj) {
        super.didStartup(plobj);
        this._gobj = (GameObject)plobj;
    }

    public void bodyEntered(int bodyOid) {
        PlayerRating rating;
        super.bodyEntered(bodyOid);
        BodyObject occupant = (BodyObject)this._omgr.getObject(bodyOid);
        if (this.shouldRateGame() && this._gobj.isInPlay() && this.isPlayer((ClientObject)occupant) && (rating = this.maybeCreateRating(occupant)) != null) {
            this.loadRatings(Collections.singleton(rating));
        }
    }

    public void bodyLeft(int bodyOid) {
        super.bodyLeft(bodyOid);
        for (PlayerRating rating : this._ratings.values()) {
            if (rating.playerOid != bodyOid || !rating.modified) continue;
            this.saveRatings(Collections.singleton(rating.cloneForSave()));
            break;
        }
    }

    @Override
    public void gameWillStart() {
        super.gameWillStart();
        if (!this.shouldRateGame()) {
            return;
        }
        this._startStamp = System.currentTimeMillis();
        this._playerIds = new int[this._gmgr.getPlayerSlots()];
        ArrayList toLoad = Lists.newArrayList();
        int ii = 0;
        int ll = this._gobj.occupants.size();
        while (ii < ll) {
            PlayerRating rating;
            BodyObject bobj = (BodyObject)this._omgr.getObject(this._gobj.occupants.get(ii));
            int pidx = this._gmgr.getPlayerIndex(bobj.getVisibleName());
            if (pidx != -1) {
                this._playerIds[pidx] = this._gmgr.getPlayerPersistentId(bobj);
            }
            if ((rating = this.maybeCreateRating(bobj)) != null) {
                toLoad.add(rating);
            }
            ++ii;
        }
        this.loadRatings(toLoad);
    }

    @Override
    public void gameDidEnd() {
        super.gameDidEnd();
        if (!this.shouldRateGame()) {
            return;
        }
        int gameSecs = TimeUtil.elapsedSeconds((long)this._startStamp, (long)System.currentTimeMillis());
        if (gameSecs < this.minimumRatedDuration()) {
            return;
        }
        this.updateRatings();
        ArrayList flushes = Lists.newArrayList();
        for (PlayerRating rating : this._ratings.values()) {
            if (!rating.modified || this._gobj.occupants.contains(rating.playerOid)) continue;
            flushes.add(rating.cloneForSave());
        }
        this.saveRatings(flushes);
    }

    protected PlayerRating maybeCreateRating(BodyObject bobj) {
        int playerId = this._gmgr.getPlayerPersistentId(bobj);
        if (playerId == 0) {
            return null;
        }
        PlayerRating orating = (PlayerRating)this._ratings.get(playerId);
        if (orating != null && orating.playerOid == bobj.getOid()) {
            return null;
        }
        return new PlayerRating(bobj, playerId);
    }

    protected void loadRatings(final Collection<PlayerRating> ratings) {
        if (ratings.size() == 0) {
            return;
        }
        final int gameId = this.getGameId();
        this._invoker.postUnit((Invoker.Unit)new RepositoryUnit("loadRatings(" + gameId + ")"){

            public void invokePersist() throws Exception {
                HashIntMap map = IntMaps.newHashIntMap();
                for (PlayerRating rating : ratings) {
                    map.put(rating.playerId, (Object)rating);
                }
                Integer[] playerIds = map.keySet().toArray(new Integer[map.size()]);
                for (RatingRecord record : RatingDelegate.this._repo.getRatings(gameId, playerIds)) {
                    PlayerRating rating = (PlayerRating)map.get(record.playerId);
                    if (rating == null) continue;
                    rating.rating = record.rating;
                    rating.experience = record.experience;
                }
            }

            public void handleSuccess() {
                for (PlayerRating rating : ratings) {
                    RatingDelegate.this._ratings.put(rating.playerId, (Object)rating);
                }
            }
        });
    }

    protected void saveRatings(final Collection<PlayerRating> ratings) {
        if (ratings.size() == 0) {
            return;
        }
        final int gameId = this.getGameId();
        this._invoker.postUnit((Invoker.Unit)new RepositoryUnit("saveRatings(" + gameId + ")"){

            public void invokePersist() throws Exception {
                for (PlayerRating rating : ratings) {
                    RatingDelegate.this._repo.setRating(gameId, rating.playerId, rating.rating, rating.experience);
                }
            }

            public void handleSuccess() {
                for (PlayerRating rating : ratings) {
                    RatingDelegate.this.updateRatingInMemory(gameId, rating);
                }
            }
        });
    }

    protected void updateRatings() {
        if (this._gobj.getWinnerCount() == 0 || this._playerIds.length == 0) {
            return;
        }
        Rating[] ratings = new PlayerRating[this._ratings.size()];
        int ii = 0;
        while (ii < ratings.length) {
            ratings[ii] = (PlayerRating)this._ratings.get(this._playerIds[ii]);
            ++ii;
        }
        int[] nratings = new int[this._playerIds.length];
        int ii2 = 0;
        while (ii2 < nratings.length) {
            float W = this._gobj.isDraw() ? 0.5f : (this._gobj.isWinner(ii2) ? 1.0f : 0.0f);
            nratings[ii2] = Rating.computeRating(ratings, ii2, W);
            ++ii2;
        }
        ii2 = 0;
        while (ii2 < nratings.length) {
            PlayerRating rating = ratings[ii2];
            if (rating != null && nratings[ii2] > 0) {
                rating.rating = nratings[ii2];
                rating.experience = rating.experience + 1;
                rating.modified = true;
            }
            ++ii2;
        }
    }

    protected int getGameId() {
        return this._gmgr.getGameConfig().getGameId();
    }

    protected boolean shouldRateGame() {
        return this._gmgr.getGameConfig().rated;
    }

    protected abstract int minimumRatedDuration();

    protected abstract void updateRatingInMemory(int var1, PlayerRating var2);

    protected static class PlayerRating
    extends Rating
    implements Cloneable {
        public int playerOid;
        public Name playerName;
        public int playerId;
        public boolean modified;

        public PlayerRating(BodyObject player, int playerId) {
            this.playerOid = player.getOid();
            this.playerName = player.getVisibleName();
            this.playerId = playerId;
        }

        public PlayerRating cloneForSave() {
            try {
                PlayerRating rating = (PlayerRating)this.clone();
                this.modified = false;
                return rating;
            }
            catch (CloneNotSupportedException cnse) {
                throw new AssertionError((Object)cnse);
            }
        }
    }
}

