/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.game.server;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.IntListUtil;
import com.samskivert.util.Interval;
import com.samskivert.util.RepeatCallTracker;
import com.samskivert.util.RunQueue;
import com.samskivert.util.Tuple;
import com.threerings.crowd.chat.server.SpeakUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.server.PlaceManager;
import com.threerings.crowd.server.PlaceManagerDelegate;
import com.threerings.parlor.Log;
import com.threerings.parlor.data.ParlorCodes;
import com.threerings.parlor.game.data.GameAI;
import com.threerings.parlor.game.data.GameCodes;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.parlor.game.data.UserIdentifier;
import com.threerings.parlor.game.server.GameManagerDelegate;
import com.threerings.parlor.server.ParlorSender;
import com.threerings.parlor.server.PlayManager;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.NamedAttributeListener;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;
import java.util.Arrays;
import java.util.List;

public class GameManager
extends PlaceManager
implements ParlorCodes,
GameCodes,
PlayManager {
    protected NamedAttributeListener _stateListener = new NamedAttributeListener("state"){

        public void namedAttributeChanged(AttributeChangedEvent event) {
            GameManager.this._committedState = event.getIntValue();
            GameManager.this.stateDidChange(GameManager.this._committedState, (Integer)event.getOldValue());
        }
    };
    protected GameConfig _gameconfig;
    protected GameObject _gameobj;
    protected int _playerCount;
    protected int[] _playerOids;
    protected ArrayIntSet _pendingOids = new ArrayIntSet();
    protected GameAI[] _AIs;
    protected List<Tuple<String, String>> _startmsgs;
    protected int _committedState;
    protected RepeatCallTracker _gameEndTracker = new RepeatCallTracker();
    protected Interval _noShowInterval;
    protected boolean _postponedStart = false;
    protected Interval _tickInterval;
    protected Interval _aiTicker;
    protected static final long DEFAULT_NOSHOW_DELAY = 30000L;
    protected static final long TICK_DELAY = 5000L;
    protected static final long AI_TICK_DELAY = 3333L;

    public GameConfig getGameConfig() {
        return this._gameconfig;
    }

    public int getGameId() {
        return this.getGameConfig().getGameId();
    }

    public int getMatchType() {
        return this._gameconfig.getMatchType();
    }

    public int addPlayer(Name player) {
        int pidx = -1;
        int ii = 0;
        while (ii < this.getPlayerSlots()) {
            if (!this._gameobj.isOccupiedPlayer(ii)) {
                pidx = ii;
                break;
            }
            ++ii;
        }
        if (pidx == -1) {
            Log.log.warning((Object)"Couldn't find free player index for player", new Object[]{"game", this.where(), "player", player, "players", this._gameobj.players});
            return -1;
        }
        return !this.addPlayerAt(player, pidx) ? -1 : pidx;
    }

    public boolean addPlayerAt(Name player, int pidx) {
        if (pidx < 0 || pidx >= this.getPlayerSlots()) {
            Log.log.warning((Object)"Attempt to add player at an invalid index", new Object[]{"game", this.where(), "player", player, "pidx", pidx});
            return false;
        }
        if (this._gameobj.players[pidx] != null) {
            Log.log.warning((Object)"Attempt to add player at occupied index", new Object[]{"game", this.where(), "player", player, "pidx", pidx});
            return false;
        }
        if (this._gameobj.getPlayerIndex(player) != -1) {
            Log.log.warning((Object)"Attempt to add player to game that they're already playing", new Object[]{"game", this.where(), "player", player});
            return false;
        }
        BodyObject bobj = this._locator.lookupBody(player);
        if (bobj == null) {
            Log.log.warning((Object)"Unable to get body object while adding player", new Object[]{"game", this.where(), "player", player});
            return false;
        }
        this._gameobj.setPlayersAt(player, pidx);
        ++this._playerCount;
        this._playerOids[pidx] = bobj.getOid();
        this.playerWasAdded(player, pidx);
        return true;
    }

    public boolean removePlayer(Name player) {
        int pidx = this._gameobj.getPlayerIndex(player);
        if (pidx == -1) {
            Log.log.warning((Object)"Attempt to remove non-player from players list", new Object[]{"game", this.where(), "player", player, "players", this._gameobj.players});
            return false;
        }
        this._gameobj.setPlayersAt(null, pidx);
        this._playerOids[pidx] = 0;
        if (this._AIs != null) {
            this._AIs[pidx] = null;
        }
        --this._playerCount;
        this.playerWasRemoved(player, pidx);
        return true;
    }

    public void replacePlayer(final int pidx, final Name player) {
        final Name oplayer = this._gameobj.players[pidx];
        this._gameobj.setPlayersAt(player, pidx);
        this.playerWasReplaced(pidx, oplayer, player);
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).playerWasReplaced(pidx, oplayer, player);
            }
        });
    }

    public BodyObject getPlayer(int playerIdx) {
        int ploid = this._playerOids[playerIdx];
        if (ploid > 0) {
            return (BodyObject)this._omgr.getObject(ploid);
        }
        Name name = this.getPlayerName(playerIdx);
        return name == null ? null : this._locator.lookupBody(name);
    }

    public void setAI(final int pidx, final GameAI ai) {
        if (this._AIs == null) {
            this._AIs = new GameAI[this.getPlayerSlots()];
        }
        this._AIs[pidx] = ai;
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).setAI(pidx, ai);
            }
        });
    }

    public Name getPlayerName(int index) {
        return this._gameobj == null ? null : this._gameobj.players[index];
    }

    public Name getPlayerDisplayName(int index) {
        return this.getPlayerName(index);
    }

    public int getPlayerIndex(Name username) {
        return this._gameobj == null ? -1 : this._gameobj.getPlayerIndex(username);
    }

    public int getPresentPlayerIndex(int bodyOid) {
        return this._playerOids == null ? -1 : IntListUtil.indexOf((int[])this._playerOids, (int)bodyOid);
    }

    public int getPlayerOid(int index) {
        return this._playerOids == null ? -1 : this._playerOids[index];
    }

    public int getPlayerPersistentId(Name name) {
        return UserIdentifier.getUserId(name);
    }

    public int getPlayerPersistentId(BodyObject body) {
        return this.getPlayerPersistentId(body.getVisibleName());
    }

    public int getPlayerCount() {
        return this._playerCount;
    }

    public int getPlayerSlots() {
        return this._gameconfig.players.length;
    }

    public boolean isAI(int pidx) {
        return this._AIs != null && this._AIs[pidx] != null;
    }

    public boolean isActivePlayer(int pidx) {
        return this._gameobj.isActivePlayer(pidx) && (this.getPlayerOid(pidx) > 0 || this.isAI(pidx));
    }

    public int getSessionId() {
        return this._gameobj.sessionId;
    }

    public void systemMessage(String msgbundle, String msg) {
        this.systemMessage(msgbundle, msg, false);
    }

    public void systemMessage(String msgbundle, String msg, boolean waitForStart) {
        if (waitForStart && (this._gameobj == null || this._gameobj.state == 0)) {
            if (this._startmsgs == null) {
                this._startmsgs = Lists.newArrayList();
            }
            this._startmsgs.add((Tuple<String, String>)Tuple.newTuple((Object)msgbundle, (Object)msg));
            return;
        }
        SpeakUtil.sendInfo((DObject)this._gameobj, (String)msgbundle, (String)msg);
    }

    public boolean startGame() {
        if (this._gameobj.state == 1) {
            Log.log.warning((Object)"Requested to start an already in-play game", new Object[]{"game", this.where(), new Exception()});
            return false;
        }
        this._gameEndTracker.clear();
        if (!this.allPlayersReady()) {
            Log.log.warning((Object)"Requested to start a game that is still awaiting players", new Object[]{"game", this.where(), "pnames", this._gameobj.players, "poids", this._playerOids});
            return false;
        }
        if (this._committedState == 1) {
            if (this._postponedStart) {
                Log.log.warning((Object)"Tried to postpone the start of a still-ending game multiple times", new Object[]{"game", this.where()});
                this._postponedStart = false;
                return false;
            }
            Log.log.info((Object)"Postponing start of still-ending game", new Object[]{"game", this.where()});
            this._postponedStart = true;
            final Exception firstCall = new Exception();
            this._omgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    boolean result = GameManager.this.startGame();
                    if (!result && !GameManager.this._postponedStart) {
                        Log.log.warning((Object)"First call to startGame", new Object[]{"game", GameManager.this.where(), firstCall});
                    }
                }
            });
            return true;
        }
        this._postponedStart = false;
        this.gameWillStart();
        this._gameobj.setState(1);
        return true;
    }

    public void endPlayerGame(int pidx) {
        this._gameobj.startTransaction();
        try {
            if (this._gameobj.playerStatus != null) {
                this._gameobj.setPlayerStatusAt(1, pidx);
            }
            this.playerGameDidEnd(pidx);
        }
        finally {
            this._gameobj.commitTransaction();
        }
        if (this.shouldEndGame()) {
            this.endGame();
        } else {
            this.reportPlayerKnockedOut(pidx);
        }
    }

    public void endGame() {
        if (this._gameEndTracker.checkCall("Requested to end already ended game [game=" + this.where() + "].")) {
            return;
        }
        if (!this._gameobj.isInPlay()) {
            Log.log.info((Object)"Refusing to end game that was not in play", new Object[]{"game", this.where()});
            return;
        }
        this._gameobj.startTransaction();
        try {
            this.gameWillEnd();
            boolean[] winners = new boolean[this.getPlayerSlots()];
            this.assignWinners(winners);
            this._gameobj.setWinners(winners);
            this._gameobj.setState(2);
        }
        finally {
            this._gameobj.commitTransaction();
        }
    }

    public boolean cancelGame() {
        if (this._gameobj.state != 2 && this._gameobj.state != 3) {
            this._gameobj.setState(3);
            return true;
        }
        return false;
    }

    public boolean shouldConcludeGame() {
        return this._gameobj.state == 2;
    }

    public void resetGame() {
        this.gameWillReset();
        this.gameWillStart();
        this._gameobj.setState(1);
    }

    public void occupantInRoom(BodyObject caller) {
        int pidx = this._gameobj.getPlayerIndex(caller.getVisibleName());
        if (pidx == -1) {
            return;
        }
        this._playerOids[pidx] = caller.getOid();
        this._pendingOids.add(caller.getOid());
    }

    public void playerReady(BodyObject caller) {
        this.occupantInRoom(caller);
        this._pendingOids.remove(caller.getOid());
        if (this.allPlayersReady()) {
            this.playersAllHere();
        }
    }

    public boolean allPlayersReady() {
        int ii = 0;
        while (ii < this.getPlayerSlots()) {
            if (!this.playerIsReady(ii)) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public boolean playerIsReady(int pidx) {
        return !this._gameobj.isOccupiedPlayer(pidx) || this._playerOids[pidx] != 0 && !this._pendingOids.contains(this._playerOids[pidx]) || this.isAI(pidx);
    }

    @Override
    public boolean isPlayer(ClientObject client) {
        BodyObject body;
        if (client != null && client instanceof BodyObject && this._gameobj.occupants.contains((body = (BodyObject)client).getOid())) {
            if (this.getGameConfig().getMatchType() == 2) {
                return true;
            }
            return this._gameobj.getPlayerIndex(body.getVisibleName()) >= 0;
        }
        return false;
    }

    @Override
    public boolean isAgent(ClientObject client) {
        return false;
    }

    @Override
    public BodyObject checkWritePermission(ClientObject client, int playerId) {
        DObject player = this._omgr.getObject(playerId);
        return player instanceof BodyObject ? (BodyObject)player : null;
    }

    protected boolean needsNoShowTimer() {
        return this.getMatchType() == 0;
    }

    protected long getNoShowTime() {
        return 30000L;
    }

    protected boolean needsAITick() {
        return false;
    }

    protected void playerWasAdded(Name player, int pidx) {
    }

    protected void playerWasRemoved(Name player, int pidx) {
    }

    protected void playerWasReplaced(int pidx, Name oldPlayer, Name newPlayer) {
    }

    protected void reportPlayerKnockedOut(int pidx) {
        BodyObject user = this.getPlayer(pidx);
        if (user == null) {
            return;
        }
        DObject place = this._omgr.getObject(user.getPlaceOid());
        if (place != null) {
            place.postMessage("playerKnocked", new Object[]{new int[]{user.getOid()}});
        }
    }

    protected void didInit() {
        super.didInit();
        this._gameconfig = (GameConfig)this._config;
        this._tickInterval = this._omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                GameManager.this.tick(System.currentTimeMillis());
            }
        });
        this._tickInterval.schedule(5000L, true);
        int ii = 0;
        while (ii < this._gameconfig.ais.length) {
            if (this._gameconfig.ais[ii] != null) {
                this.setAI(ii, this._gameconfig.ais[ii]);
            }
            ++ii;
        }
    }

    protected void didStartup() {
        this._gameobj = (GameObject)this._plobj;
        this._gameobj.addListener((ChangeListener)this._stateListener);
        this._gameobj.setPlayers(this._gameconfig.players);
        this._gameobj.setPlayerStatus(new int[this.getPlayerSlots()]);
        this._playerCount = this._gameobj.getPlayerCount();
        this._playerOids = new int[this.getPlayerSlots()];
        super.didStartup();
        int ii = 0;
        while (ii < this.getPlayerSlots()) {
            if (this._gameobj.isOccupiedPlayer(ii) && !this.isAI(ii)) {
                BodyObject bobj = this._locator.lookupBody(this._gameobj.players[ii]);
                if (bobj == null) {
                    Log.log.warning((Object)"Unable to deliver game ready to non-existent player", new Object[]{"game", this.where(), "player", this._gameobj.players[ii]});
                } else {
                    ParlorSender.gameIsReady((ClientObject)bobj, this._gameobj.getOid());
                }
            }
            ++ii;
        }
        if (this.needsNoShowTimer()) {
            this._noShowInterval = new Interval((RunQueue)this._omgr){

                public void expired() {
                    GameManager.this.checkForNoShows();
                }
            };
            this._noShowInterval.schedule(this.getNoShowTime());
        }
    }

    protected void didShutdown() {
        super.didShutdown();
        this._tickInterval.cancel();
        this._tickInterval = null;
        if (this._gameobj != null) {
            this._gameobj.removeListener((ChangeListener)this._stateListener);
        }
    }

    protected void bodyLeft(int bodyOid) {
        int pidx = IntListUtil.indexOf((int[])this._playerOids, (int)bodyOid);
        if (pidx != -1 && this._gameobj.isInPlay() && this._gameobj.isActivePlayer(pidx)) {
            this.endPlayerGame(pidx);
        } else if (pidx != -1 && this._gameobj.state == 0) {
            this._playerOids[pidx] = 0;
        }
        super.bodyLeft(bodyOid);
    }

    protected void placeBecameEmpty() {
        super.placeBecameEmpty();
        if (this._gameobj.state != 0 && this._gameobj.state != 2 && this._gameobj.state != 3) {
            this._gameobj.setState(2);
            this.shutdown();
            return;
        }
        if (this.cancelGame()) {
            return;
        }
        this.shutdown();
    }

    protected void playersAllHere() {
        if (this.getMatchType() == 0 && this._gameobj.state == 0) {
            this.startGame();
        }
    }

    protected void checkShutdownInterval() {
        if (this._gameobj.state == 0) {
            super.checkShutdownInterval();
        }
    }

    protected void checkForNoShows() {
        if (this._gameobj.state != 0) {
            return;
        }
        if (this._plobj.occupants.size() == 0) {
            Log.log.info((Object)"Cancelling total no-show", new Object[]{"game", this.where(), "players", this._gameobj.players, "poids", this._playerOids});
            this.placeBecameEmpty();
        } else {
            int ii = 0;
            while (ii < this.getPlayerSlots()) {
                if (!this.playerIsReady(ii)) {
                    this.handlePartialNoShow();
                    return;
                }
                ++ii;
            }
        }
    }

    protected void handlePartialNoShow() {
        int humansHere = 0;
        int ii = 0;
        while (ii < this._playerOids.length) {
            if (this._playerOids[ii] == 0) {
                this._playerOids[ii] = -1;
            } else if (!this.isAI(ii)) {
                ++humansHere;
            }
            ++ii;
        }
        if (humansHere == 0 && !this.startWithoutHumans()) {
            Log.log.info((Object)"Canceling no-show game", new Object[]{"game", this.where(), "players", this._playerOids});
            this.cancelGame();
        } else {
            Log.log.info((Object)"Forcing start of partial no-show game", new Object[]{"game", this.where(), "players", this._playerOids});
            this.playersAllHere();
        }
    }

    protected boolean startWithoutHumans() {
        return false;
    }

    protected void gameWillStart() {
        this._gameobj.setSessionId(this._gameobj.sessionId + 1);
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).gameWillStart();
            }
        });
    }

    protected void stateDidChange(int state, int oldState) {
        switch (state) {
            case 1: {
                this.gameDidStart();
                break;
            }
            case 2: {
                this._gameobj.state = oldState;
                boolean wasInPlay = this._gameobj.isInPlay();
                this._gameobj.state = state;
                if (!wasInPlay) break;
                this.gameDidEnd();
                break;
            }
            case 3: {
                this.gameWasCancelled();
                if (this._plobj.occupants.size() != 0) break;
                this.shutdown();
            }
        }
    }

    protected void gameDidStart() {
        if (this._noShowInterval != null) {
            this._noShowInterval.cancel();
        }
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).gameDidStart();
            }
        });
        if (this._startmsgs != null) {
            for (Tuple<String, String> mtup : this._startmsgs) {
                this.systemMessage((String)mtup.left, (String)mtup.right);
            }
            this._startmsgs = null;
        }
        if (this._AIs != null && this.needsAITick()) {
            this.startAITicker();
        }
        int ii = 0;
        while (ii < this._playerOids.length) {
            if (this._playerOids[ii] == -1) {
                Log.log.info((Object)"Booting no-show player", new Object[]{"game", this.where(), "player", this.getPlayerName(ii)});
                this._playerOids[ii] = 0;
                this.endPlayerGame(ii);
            }
            ++ii;
        }
    }

    protected void startAITicker() {
        if (this._aiTicker == null) {
            this._aiTicker = this._omgr.newInterval(new Runnable(){

                @Override
                public void run() {
                    GameManager.this.tickAIs();
                }
            });
            this._aiTicker.schedule(3333L, true);
        }
    }

    protected void stopAITicker() {
        if (this._aiTicker != null) {
            this._aiTicker.cancel();
            this._aiTicker = null;
        }
    }

    protected void tickAIs() {
        int ii = 0;
        while (ii < this._AIs.length) {
            if (this._AIs[ii] != null) {
                this.tickAI(ii, this._AIs[ii]);
            }
            ++ii;
        }
    }

    protected void tickAI(final int pidx, final GameAI ai) {
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).tickAI(pidx, ai);
            }
        });
    }

    protected void announcePlayerGameOver(int pidx) {
        this.systemMessage("game.general", MessageBundle.tcompose((String)this.getPlayerGameOverMessage(pidx), (Object)this.getPlayerDisplayName(pidx)));
    }

    protected String getPlayerGameOverMessage(int pidx) {
        return "m.player_game_over";
    }

    protected void playerGameDidEnd(int pidx) {
        this.announcePlayerGameOver(pidx);
    }

    protected boolean shouldEndGame() {
        return this._gameobj.isInPlay() && this._gameobj.getActivePlayerCount() == 1;
    }

    protected void assignWinners(boolean[] winners) {
        Arrays.fill(winners, false);
    }

    protected void gameWillEnd() {
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).gameWillEnd();
            }
        });
    }

    protected void gameDidEnd() {
        this.stopAITicker();
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).gameDidEnd();
            }
        });
        Arrays.fill(this._playerOids, 0);
        this._pendingOids.clear();
        int winnerCount = this._gameobj.getWinnerCount();
        if (this.shouldConcludeGame() && winnerCount > 0 && !this._gameobj.isDraw()) {
            this.reportWinnersAndLosers();
        }
    }

    protected void gameWasCancelled() {
        this.stopAITicker();
    }

    protected void reportWinnersAndLosers() {
        int numPlayers = this._playerOids.length;
        ArrayIntSet winners = new ArrayIntSet(numPlayers);
        ArrayIntSet losers = new ArrayIntSet(numPlayers);
        ArrayIntSet places = new ArrayIntSet(numPlayers);
        int ii = 0;
        while (ii < numPlayers) {
            BodyObject user = this.getPlayer(ii);
            if (user != null) {
                places.add(user.getPlaceOid());
                (this._gameobj.isWinner(ii) ? winners : losers).add(user.getOid());
            }
            ++ii;
        }
        Object[] args = new Object[]{winners.toIntArray(), losers.toIntArray()};
        int ii2 = 0;
        int nn = places.size();
        while (ii2 < nn) {
            DObject place = this._omgr.getObject(places.get(ii2));
            if (place != null) {
                place.postMessage("winnersAndLosers", args);
            }
            ++ii2;
        }
    }

    protected void gameWillReset() {
        this._gameobj.setPlayerStatus(new int[this.getPlayerSlots()]);
        this.applyToDelegates(new PlaceManager.DelegateOp(GameManagerDelegate.class){

            public void apply(PlaceManagerDelegate delegate) {
                ((GameManagerDelegate)delegate).gameWillReset();
            }
        });
    }

    protected void tick(long tickStamp) {
    }
}

