/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.game.client;

import com.threerings.crowd.client.PlaceController;
import com.threerings.crowd.client.PlaceControllerDelegate;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.parlor.Log;
import com.threerings.parlor.game.client.GameControllerDelegate;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.parlor.util.ParlorContext;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DObject;
import java.awt.event.ActionEvent;

public abstract class GameController
extends PlaceController
implements AttributeChangeListener {
    protected ParlorContext _ctx;
    protected GameConfig _config;
    protected GameObject _gobj;
    protected boolean _gameOver;

    public void init(CrowdContext ctx, PlaceConfig config) {
        this._ctx = (ParlorContext)ctx;
        this._config = (GameConfig)config;
        super.init(ctx, config);
    }

    public void willEnterPlace(PlaceObject plobj) {
        super.willEnterPlace(plobj);
        this._gobj = (GameObject)plobj;
        BodyObject bobj = (BodyObject)this._ctx.getClient().getClientObject();
        if (bobj.location == null || bobj.location.placeOid != plobj.getOid()) {
            this._ctx.getChatDirector().addAuxiliarySource((DObject)this._gobj, "gameChat");
        }
        this._gobj.addListener((ChangeListener)this);
        Log.log.info((Object)("Entering game " + this._gobj.which() + "."), new Object[0]);
        if (this._gobj.getPlayerIndex(bobj.getVisibleName()) != -1) {
            this._ctx.getClient().getRunQueue().postRunnable(new Runnable(){

                @Override
                public void run() {
                    GameController.this.playerReady();
                }
            });
        }
    }

    public void didLeavePlace(PlaceObject plobj) {
        super.didLeavePlace(plobj);
        this._ctx.getChatDirector().removeAuxiliarySource((DObject)this._gobj);
        this._gobj.removeListener((ChangeListener)this);
        this._gobj = null;
    }

    public int getMatchType() {
        return this._config.getMatchType();
    }

    public boolean isGameOver() {
        boolean gameOver;
        boolean bl = gameOver = this._gobj == null || this._gobj.state != 1;
        return this._gameOver || gameOver;
    }

    public void setGameOver(boolean gameOver) {
        this._gameOver = gameOver;
    }

    public void resetGame() {
        this.gameWillReset();
        this.setGameOver(true);
    }

    public int getSessionId() {
        return this._gobj == null ? -1 : this._gobj.sessionId;
    }

    public boolean handleAction(ActionEvent action) {
        return super.handleAction(action);
    }

    public void systemMessage(String bundle, String msg) {
        this._ctx.getChatDirector().displayInfo(bundle, msg, "gameChat");
    }

    public void attributeChanged(AttributeChangedEvent event) {
        int newState;
        if (event.getName().equals("state") && !this.stateDidChange(newState = event.getIntValue())) {
            Log.log.warning((Object)"Game transitioned to unknown state", new Object[]{"gobj", this._gobj, "state", newState});
        }
    }

    protected boolean stateDidChange(int state) {
        switch (state) {
            case 0: {
                return true;
            }
            case 1: {
                this.gameDidStart();
                return true;
            }
            case 2: {
                this.gameDidEnd();
                return true;
            }
            case 3: {
                this.gameWasCancelled();
                return true;
            }
        }
        return false;
    }

    protected void playerReady() {
        Log.log.info((Object)("Reporting ready " + this._gobj.which() + "."), new Object[0]);
        this._gobj.manager.invoke("playerReady", new Object[0]);
    }

    protected void gameDidStart() {
        if (this._gobj == null) {
            Log.log.info((Object)"Received gameDidStart() after leaving game room.", new Object[0]);
            return;
        }
        this.setGameOver(false);
        this.applyToDelegates(new PlaceController.DelegateOp(GameControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((GameControllerDelegate)delegate).gameDidStart();
            }
        });
    }

    protected void gameDidEnd() {
        this.applyToDelegates(new PlaceController.DelegateOp(GameControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((GameControllerDelegate)delegate).gameDidEnd();
            }
        });
    }

    protected void gameWasCancelled() {
        this.applyToDelegates(new PlaceController.DelegateOp(GameControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((GameControllerDelegate)delegate).gameWasCancelled();
            }
        });
    }

    protected void gameWillReset() {
        this.applyToDelegates(new PlaceController.DelegateOp(GameControllerDelegate.class){

            public void apply(PlaceControllerDelegate delegate) {
                ((GameControllerDelegate)delegate).gameWillReset();
            }
        });
    }
}

