/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.parlor.data.ParlorCodes;
import com.threerings.parlor.data.TableConfig;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.util.ActionScript;
import com.threerings.util.Name;
import java.util.ArrayList;
import java.util.HashSet;

public class Table
implements DSet.Entry,
ParlorCodes {
    public static final int ANY_POSITION = -1;
    public int tableId;
    public int lobbyOid;
    public int gameOid = -1;
    public Name[] players;
    public Name[] watchers = this.createPlayerNamesArray(0);
    public transient int[] bodyOids;
    public GameConfig config;
    public TableConfig tconfig;
    protected static int _tableIdCounter = 0;
    protected transient HashSet<Name> _bannedUsers;

    @ActionScript(omit=true)
    public void init(int lobbyOid, TableConfig tconfig, GameConfig config) {
        this.tableId = ++_tableIdCounter;
        this.lobbyOid = lobbyOid;
        this.tconfig = tconfig;
        this.config = config;
        if (config.getMatchType() != 2) {
            this.players = this.createPlayerNamesArray(tconfig.desiredPlayerCount);
            this.bodyOids = new int[this.players.length];
            int acount = config.ais == null ? 0 : config.ais.length;
            int ii = 0;
            while (ii < acount) {
                this.players[ii] = new Name("AI " + (ii + 1));
                ++ii;
            }
        } else {
            this.players = this.createPlayerNamesArray(0);
            this.bodyOids = new int[0];
        }
    }

    @ActionScript(omit=true)
    public boolean isEmpty() {
        int[] nArray = this.bodyOids;
        int n = this.bodyOids.length;
        int n2 = 0;
        while (n2 < n) {
            int bodyOid = nArray[n2];
            if (bodyOid != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int getOccupiedCount() {
        int count = 0;
        if (this.players != null) {
            Name[] nameArray = this.players;
            int n = this.players.length;
            int n2 = 0;
            while (n2 < n) {
                Name player = nameArray[n2];
                if (player != null) {
                    ++count;
                }
                ++n2;
            }
        }
        return count;
    }

    public Name[] getPlayers() {
        if (1 == this.config.getMatchType()) {
            return this.createPlayerNamesArray(this.tconfig.desiredPlayerCount);
        }
        Name[] plist = this.createPlayerNamesArray(this.getOccupiedCount());
        if (this.players != null) {
            int ii = 0;
            int dex = 0;
            while (ii < this.players.length) {
                if (this.players[ii] != null) {
                    plist[dex++] = this.players[ii];
                }
                ++ii;
            }
        }
        return plist;
    }

    public int[][] getTeamMemberIndices() {
        int[][] teams = this.tconfig.teamMemberIndices;
        if (teams == null) {
            return null;
        }
        ArrayIntSet set = new ArrayIntSet();
        int[][] newTeams = new int[teams.length][];
        Object[] plist = this.getPlayers();
        int ii = 0;
        while (ii < teams.length) {
            set.clear();
            int jj = 0;
            while (jj < teams[ii].length) {
                Name occ = this.players[teams[ii][jj]];
                if (occ != null) {
                    set.add(ListUtil.indexOf((Object[])plist, (Object)occ));
                }
                ++jj;
            }
            newTeams[ii] = set.toIntArray();
            ++ii;
        }
        return newTeams;
    }

    @ActionScript(omit=true)
    public String setPlayer(int position, BodyObject player) {
        if (this._bannedUsers != null && this._bannedUsers.contains(player.getVisibleName())) {
            return "m.banned_from_table";
        }
        if (position == -1) {
            int ii = 0;
            while (ii < this.tconfig.desiredPlayerCount) {
                if (this.players[ii] == null) {
                    this.setPlayerPos(ii, player);
                    return null;
                }
                ++ii;
            }
            return "m.table_position_occupied";
        }
        if (position >= this.tconfig.desiredPlayerCount || position < 0) {
            return "m.invalid_table_position";
        }
        if (this.players[position] != null) {
            return "m.table_position_occupied";
        }
        this.setPlayerPos(position, player);
        return null;
    }

    @ActionScript(omit=true)
    public void setPlayerPos(int position, BodyObject player) {
        this.players[position] = player.getVisibleName();
        this.bodyOids[position] = player.getOid();
    }

    public void addBannedUser(Name player) {
        if (this._bannedUsers == null) {
            this._bannedUsers = Sets.newHashSet();
        }
        this._bannedUsers.add(player);
    }

    @ActionScript(omit=true)
    public boolean clearPlayer(Name username) {
        if (this.players != null) {
            int ii = 0;
            while (ii < this.players.length) {
                if (username.equals((Object)this.players[ii])) {
                    this.clearPlayerPos(ii);
                    return true;
                }
                ++ii;
            }
        }
        return false;
    }

    @ActionScript(omit=true)
    public boolean clearPlayerByOid(int bodyOid) {
        if (this.bodyOids != null) {
            int ii = 0;
            while (ii < this.bodyOids.length) {
                if (bodyOid == this.bodyOids[ii]) {
                    this.clearPlayerPos(ii);
                    return true;
                }
                ++ii;
            }
        }
        return false;
    }

    @ActionScript(omit=true)
    public void clearPlayerPos(int position) {
        this.players[position] = null;
        this.bodyOids[position] = 0;
    }

    @ActionScript(omit=true)
    public boolean containsPlayer(Name player) {
        return this.players != null && ListUtil.indexOf((Object[])this.players, (Object)player) != -1;
    }

    @ActionScript(omit=true)
    public void updateOccupants(GameObject gameobj) {
        ArrayList wlist = Lists.newArrayList();
        for (OccupantInfo info : gameobj.occupantInfo) {
            if (this.containsPlayer(info.username)) continue;
            wlist.add(info.username);
        }
        this.watchers = wlist.toArray(this.createPlayerNamesArray(wlist.size()));
    }

    public boolean mayBeStarted() {
        int[][] teams;
        switch (this.config.getMatchType()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        if (this.tconfig.teamMemberIndices == null) {
            return this.tconfig.minimumPlayerCount <= this.getOccupiedCount();
        }
        int[][] nArray = teams = this.tconfig.teamMemberIndices;
        int n = teams.length;
        int n2 = 0;
        while (n2 < n) {
            int[] team = nArray[n2];
            int teamCount = 0;
            int[] nArray2 = team;
            int n3 = team.length;
            int n4 = 0;
            while (n4 < n3) {
                int element = nArray2[n4];
                if (this.players[element] != null) {
                    ++teamCount;
                }
                ++n4;
            }
            if (teamCount < this.tconfig.minimumPlayerCount) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean shouldBeStarted() {
        switch (this.config.getMatchType()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return this.tconfig.desiredPlayerCount <= this.getOccupiedCount();
    }

    public boolean inPlay() {
        return this.gameOid != -1;
    }

    public Comparable<?> getKey() {
        return this.tableId;
    }

    public boolean equals(Object other) {
        return other instanceof Table && this.tableId == ((Table)other).tableId;
    }

    public int hashCode() {
        return this.tableId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.shortClassName((Object)this));
        buf.append(" [");
        this.toString(buf);
        buf.append("]");
        return buf.toString();
    }

    @ActionScript(name="toStringBuilder")
    protected void toString(StringBuilder buf) {
        buf.append("tableId=").append(this.tableId);
        buf.append(", lobbyOid=").append(this.lobbyOid);
        buf.append(", gameOid=").append(this.gameOid);
        buf.append(", players=").append(StringUtil.toString((Object)this.players));
        buf.append(", config=").append(this.config);
    }

    protected Name[] createPlayerNamesArray(int length) {
        return new Name[length];
    }
}

