/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.client;

import com.google.common.collect.Lists;
import com.samskivert.util.HashIntMap;
import com.threerings.parlor.Log;
import com.threerings.parlor.client.GameReadyObserver;
import com.threerings.parlor.client.Invitation;
import com.threerings.parlor.client.InvitationHandler;
import com.threerings.parlor.client.InvitationResponseObserver;
import com.threerings.parlor.client.ParlorDecoder;
import com.threerings.parlor.client.ParlorReceiver;
import com.threerings.parlor.client.ParlorService;
import com.threerings.parlor.data.ParlorCodes;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.util.ParlorContext;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationDecoder;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.util.PresentsContext;
import com.threerings.util.Name;
import java.util.List;

public class ParlorDirector
extends BasicDirector
implements ParlorCodes,
ParlorReceiver {
    protected ParlorContext _ctx;
    protected ParlorService _pservice;
    protected InvitationHandler _handler;
    protected HashIntMap<Invitation> _pendingInvites = new HashIntMap();
    protected List<GameReadyObserver> _grobs = Lists.newArrayList();

    public ParlorDirector(ParlorContext ctx) {
        super((PresentsContext)ctx);
        this._ctx = ctx;
        this._ctx.getClient().getInvocationDirector().registerReceiver((InvocationDecoder)new ParlorDecoder(this));
    }

    public void setInvitationHandler(InvitationHandler handler) {
        this._handler = handler;
    }

    public void addGameReadyObserver(GameReadyObserver observer) {
        this._grobs.add(observer);
    }

    public void removeGameReadyObserver(GameReadyObserver observer) {
        this._grobs.remove(observer);
    }

    public Invitation invite(Name invitee, GameConfig config, InvitationResponseObserver observer) {
        Invitation invite = new Invitation(this._ctx, this._pservice, invitee, config, observer);
        this._pservice.invite(invitee, config, invite);
        return invite;
    }

    public void startSolitaire(GameConfig config, InvocationService.ConfirmListener listener) {
        this._pservice.startSolitaire(config, listener);
    }

    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        this._pservice = null;
        this._pendingInvites.clear();
    }

    @Override
    public void gameIsReady(int gameOid) {
        Log.log.info((Object)("Handling game ready [goid=" + gameOid + "]."), new Object[0]);
        boolean handled = false;
        int ii = 0;
        while (ii < this._grobs.size()) {
            GameReadyObserver grob = this._grobs.get(ii);
            handled = grob.receivedGameReady(gameOid) || handled;
            ++ii;
        }
        if (!handled) {
            this._ctx.getLocationDirector().moveTo(gameOid);
        }
    }

    @Override
    public void receivedInvite(int remoteId, Name inviter, GameConfig config) {
        Invitation invite = new Invitation(this._ctx, this._pservice, inviter, config, null);
        invite.inviteId = remoteId;
        this._pendingInvites.put(remoteId, (Object)invite);
        try {
            this._handler.invitationReceived(invite);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Invitation handler choked on invite notification " + invite + "."), new Object[]{e});
        }
    }

    @Override
    public void receivedInviteResponse(int remoteId, int code, Object arg) {
        Invitation invite = (Invitation)this._pendingInvites.get(remoteId);
        if (invite == null) {
            Log.log.warning((Object)("Have no record of invitation for which we received a response?! [remoteId=" + remoteId + ", code=" + code + ", arg=" + arg + "]."), new Object[0]);
        } else {
            invite.receivedResponse(code, arg);
        }
    }

    @Override
    public void receivedInviteCancellation(int remoteId) {
    }

    protected void registerServices(Client client) {
        client.addServiceGroup("parlor");
    }

    protected void fetchServices(Client client) {
        this._pservice = (ParlorService)client.requireService(ParlorService.class);
    }

    protected void registerInvitation(Invitation invite) {
        this._pendingInvites.put(invite.inviteId, (Object)invite);
    }

    protected void clearInvitation(Invitation invite) {
        this._pendingInvites.remove(invite.inviteId);
    }
}

